/*
 * $Source: /mit/netbsd/athena/kerberos/lib/krb/RCS/in_tkt.c,v $
 * $Author: jtkohl $
 *
 * Copyright 1985, 1986, 1987, 1988 by the Massachusetts Institute
 * of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 */

#ifndef lint
static char *rcsid_in_tkt_c =
"$Id: in_tkt.c,v 1.2 1994/07/20 19:51:26 jtkohl Exp $";
#endif /* lint */

#include <mit-copyright.h>
#include <stdio.h>
#include <krb.h>
#include <sys/types.h>
#include <sys/file.h>
#ifdef NEED_SYS_FCNTL_H
/* just for O_RDWR for sco */
#include <sys/fcntl.h>
#endif
#include <sys/stat.h>
#include <sys/param.h>

extern int krb_debug;

/*
 * in_tkt() is used to initialize the ticket store.  It creates the
 * file to contain the tickets and writes the given user's name "pname"
 * and instance "pinst" in the file.  in_tkt() returns KSUCCESS on
 * success, or KFAILURE if something goes wrong.
 */

#ifdef BSD4_4
/* can't set ruid, but can set euid back and forth. */
#define setreuid(r,e) seteuid(e)
#else
#ifdef hpux
/* should be HAS_RESUID */
#define setreuid(r,e) setresuid(r,e,-1)
#endif
#ifdef solaris20
#define setreuid(r,e) setuid(r)
#endif
#endif

in_tkt(pname,pinst)
    char *pname;
    char *pinst;
{
    int tktfile;
    uid_t ruid, euid, getuid(), geteuid();
    struct stat buf;
    int count;
    char *file = TKT_FILE;
    int fd;
    register int i;
    char charbuf[BUFSIZ];
#ifdef TKT_SHMEM
    char shmidname[MAXPATHLEN];
#endif /* TKT_SHMEM */

    ruid = getuid ();
    euid = geteuid();
    if (lstat(file,&buf) == 0) {
	if (buf.st_uid != ruid || !(buf.st_mode & S_IFREG) ||
	    buf.st_mode & 077) {
	    if (krb_debug)
		fprintf(stderr,"Error initializing %s",file);
	    return(KFAILURE);
	}
	/* file already exists, and permissions appear ok, so nuke it */
	if ((fd = open(file, O_RDWR|O_SYNC, 0)) < 0)
	    goto out; /* can't zero it, but we can still try truncating it */

	memset(charbuf, 0, sizeof(charbuf));

	for (i = 0; i < buf.st_size; i += sizeof(charbuf))
	    if (write(fd, charbuf, sizeof(charbuf)) != sizeof(charbuf)) {
#ifndef NO_FSYNC
		(void) fsync(fd);
#endif
		(void) close(fd);
		goto out;
	    }
	
#ifndef NO_FSYNC
	(void) fsync(fd);
#endif
	(void) close(fd);
    }
 out:
    /* arrange so the file is owned by the ruid
       (swap real & effective uid if necessary).
       This isn't a security problem, since the ticket file, if it already
       exists, has the right uid (== ruid) and mode. */
    if (ruid != euid) {
	if (setreuid(euid, ruid) < 0) {
	    /* can't switch??? barf! */
	    if (krb_debug)
		perror("in_tkt: setreuid");
	    return(KFAILURE);
	} else
	    if (krb_debug)
		printf("swapped UID's %d and %d\n",euid,ruid);
    }
    if ((tktfile = creat(file,0600)) < 0) {
	if (krb_debug)
	    fprintf(stderr,"Error initializing %s",TKT_FILE);
        return(KFAILURE);
    }
    if (ruid != euid) {
	if (setreuid(ruid, euid) < 0) {
	    /* can't switch??? barf! */
	    if (krb_debug)
		perror("in_tkt: setreuid2");
	    return(KFAILURE);
	} else
	    if (krb_debug)
		printf("swapped UID's %d and %d\n",ruid,euid);
    }
    if (lstat(file,&buf) < 0) {
	if (krb_debug)
	    fprintf(stderr,"Error initializing %s",TKT_FILE);
        return(KFAILURE);
    }

    if (buf.st_uid != ruid || !(buf.st_mode & S_IFREG) ||
        buf.st_mode & 077) {
	if (krb_debug)
	    fprintf(stderr,"Error initializing %s",TKT_FILE);
        return(KFAILURE);
    }

    count = strlen(pname)+1;
    if (write(tktfile,pname,count) != count) {
        (void) close(tktfile);
        return(KFAILURE);
    }
    count = strlen(pinst)+1;
    if (write(tktfile,pinst,count) != count) {
        (void) close(tktfile);
        return(KFAILURE);
    }
    (void) close(tktfile);
#ifdef TKT_SHMEM
    (void) strcpy(shmidname, file);
    (void) strcat(shmidname, ".shm");
    return(krb_shm_create(shmidname));
#else /* !TKT_SHMEM */
    return(KSUCCESS);
#endif /* TKT_SHMEM */
}
