#if !defined(lint) && !defined(SABER)
static char rcsid[] = "$Id: util.c,v 1.4 96/03/15 16:15:20 warlord Exp $";
#endif

#include "mkserv.h"

/* find_in_string(char *f, char *instr)
 *	Finds string f in instr if it exists starting from beginning 
 *	Returns pointer to begining of match or NULL;
 */

/* Gcc will not allow instr to be defined as const... */
char *
find_in_string(Const char *f, char *instr)
{
	int 	instrlen = strlen(instr);
	int 	flen = strlen(f);
	char   *p = instr;

	while(((p - instr) + flen) <= instrlen) {
		if((*f == *p) && !strncmp(f, p, flen)) return p;
		p++;
	}
	return NULL;
}

#if !defined(sun) && !defined(__NetBSD__) && !defined(linux)
char *
strdup(char *s)
{
	char *p;

	if(!s) return NULL;

	if((p = (char *) malloc(strlen(s) + 1)) != NULL) 
		strcpy(p, s);
	return p; /* Can return NULL */
}
#endif

/*
 * Compare version strings v1 and v2
 *	Returns:
 *	  -1 if v1 < v2
 *	   0 if v1 = v2
 *	   1 if v1 > v2
 */

cmp_version(char *v1, char *v2)
{
	register char *s1, *s2;
	register int n1, n2;

	/* Handle NULL pointers */
	s1 = (v1 == NULL) ? "" : v1;
	s2 = (v2 == NULL) ? "" : v2;

	/* Iterate over items */
	do {
		n1 = 0;
		while(isdigit(*s1)) {
			n1 = n1*10 + (*s1 - '0');
			s1++;
		}
		/* Handle a '.' if it exists */
		if(*s1=='.') s1++;

		n2 = 0;
		while(isdigit(*s2)) {
			n2 = n2*10 + (*s2 - '0');
			s2++;
		}
		/* Handle a '.' if it exists */
		if(*s2=='.') s2++;
	} while ((n1 == n2) && (*s1 != '\0') && (*s2!='\0'));

	/* Either at end of a string of n1 != n2 */
	if (n1 != n2) 
		return ((n1-n2 > 0) ? -1 : 1);
		
	if((*s1 == '\0') && (*s2 == '\0')) return 0;

	/* Ok - identical up to this point - one is longer */
	/* Shorter if less i.e. 1.1 < 1.1.1 */
	return (*s1 == '\0') ? 1 : -1;
}
