/**********************************************************************
 * Error table generator for kerberos
 *
 * $Author: brlewis $
 * $Source: /afs/athena.mit.edu/astaff/project/eosdev/src/ets/RCS/mk_krb_err.c,v $
 * $Header: /afs/athena.mit.edu/astaff/project/eosdev/src/ets/RCS/mk_krb_err.c,v 1.1 90/09/25 10:56:19 brlewis Exp $
 *
 * Copyright 1989, 1990 by the Massachusetts Institute of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 **********************************************************************/

#include <mit-copyright.h>
#include "krb.h"

main()
{
  int i;
  char *msg;

  printf("############################################################\n");
  printf("# File Exchange kerberos error table\n");
  printf("# This file is automatically generated.  Do not edit it.\n");
  printf("############################################################\n\n");

  printf("error_table\tkrb\n\n");

  for (i=0; i < MAX_KRB_ERRORS; i++) {
    msg = krb_err_txt[i];
    if (!msg) msg = "";
    printf("error_code\tERR_KRB_%d,\n\t\t\"%s\"\n\n", i, msg);
  }
  printf("end\n");
  exit(0);
}
