/*
 * This file is part of the OLC On-Line Consulting System.
 * It contains procedures for dealing with administrative functions
 *
 *	Lucien Van Elsen
 *      MIT Project Athena
 *
 * Copyright (C) 1991 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *	$Source: /afs/athena.mit.edu/astaff/project/olcdev/src/clients/lib/RCS/admin.c,v $
 *	$Id: admin.c,v 1.1 91/11/05 14:06:09 lwvanels Exp $
 *	$Author: lwvanels $
 */

#ifndef lint
#ifndef SABER
static char rcsid[] ="$Header: /afs/athena.mit.edu/astaff/project/olcdev/src/clients/lib/RCS/admin.c,v 1.1 91/11/05 14:06:09 lwvanels Exp $";
#endif
#endif

#include <mit-copyright.h>
#include <olc/olc.h>


/*
 * Function:	OTweakZephyr(&Request,what, how_long) 
 * Description: turns on/off zephyr use on the server;
 *		what = 1 means turn it off, for how_long minutes
 *		    (how_long = 0 means indefinitely, -1 = server default)
 *		what = 0 means turn it on; how_long ignored
 * Returns:	ERRCODE
 */


ERRCODE
OTweakZephyr(Request,what,how_long)
     REQUEST *Request;
     int what;
     int how_long;
{
  int fd;
  int status;

  if (what == 1) {
    Request->options = OFF_OPT;
  } else {
    Request->options = NO_OPT;
  }

  status = open_connection_to_daemon(Request, &fd);
  if(status)
    return(status);

  status = send_request(fd, Request);
  if(status) {
    close(fd);
    return(status);
  }

  read_response(fd, &status);  
 
  if ((status == SUCCESS) && (what == 1)) {
    status = write_int_to_fd(fd,how_long);
  }

  close(fd);
  return(status);
}
