/*
 * This file is part of the OLH system.
 *
 *      Lucien Van Elsen
 *	MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *	$Source: /afs/sipb/project/sipb-athena/src/olh/ascii/RCS/help.c,v $
 *	$Id: help.c,v 1.4 1996/06/01 19:40:54 yoav Exp $
 *	$Author: yoav $
 */

#ifndef lint
#ifndef SABER
static char *RCSid = "$Header: /afs/sipb/project/sipb-athena/src/olh/ascii/RCS/help.c,v 1.4 1996/06/01 19:40:54 yoav Exp $";
#endif
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#ifdef SYSV
#include <sys/fcntl.h>
#endif
#include "olh.h"
#include "help.h"

#ifdef __STDC__
# define        P(s) s
#else
# define P(s) ()
#endif

static char *load_help_file P((char *filename ));

#undef P

extern int errno;
#ifndef __NetBSD__
extern char *sys_errlist[];
#endif

char* help_filename[] =
{
  "ascii_primary",
  "ascii_keyword",
};

char* help_text[] =
{
  NULL,
  NULL,
};

char* instr_text[][NUM_INSTR_LINES] =
{
/* INSTR_NORMAL */
  {
    "",
    "To choose a topic, type its number and press the Return key.",
    "Additionally, you can use the arrow keys to move and select items",
    "Press the '?' key for help.  Press the 'q' key to quit.",
    "To go up to the previous menu, press the 'u' key.",
  },
/* INSTR_NORMAL_TOP */
  {
    "",
    "To choose a topic, type its number and press the Return key.",
    "Additionally, you can use the arrow keys to move and select items",
    "Press the '?' key for help.  Press the 'q' key to quit.",
    "",
  },
/* INSTR_KEYWORD_NUM */
  {
    "To choose a keyword, type its number and press the Return key,",
    "or press 'k', then type the keyword itself and press the Return key.",
    "Additionally, you can use the arrow keys to move and select items",
    "Press the '?' key for help.  Press the 'q' key to quit.",
    "To go up to the previous menu, press the 'u' key.",
  },
/* INSTR_KEYWORD_WORD */
  {
    "",
    "Type a keyword and press the Return key.",
    "To get out of keyword-entry mode, press Ctrl-G.",
    "Press the '?' key for help.",
    "",
  },
};

void
  OLH_ui_help_primary( )
{
  if (help_text[HELP_PRIM] == NULL)
    help_text[HELP_PRIM] = load_help_file(help_filename[HELP_PRIM]);
  show_help_message(help_text[HELP_PRIM]);
}


void
  OLH_ui_help_keyword( )
{
  if (help_text[HELP_KWD] == NULL)
    help_text[HELP_KWD] = load_help_file(help_filename[HELP_KWD]);
  show_help_message(help_text[HELP_KWD]);
}


static char *
load_help_file(filename)
     char *filename;
{
  char path[128];
  int fd;
  char *info;
  struct stat statbuf;


  strcpy(path,HELP_FILE_PREFIX);
  strcat(path,filename);

  fd = open(path,O_RDONLY,0);
  if (fd < 0) {
    info = malloc(300);
    sprintf(info,"The help file %s could not be opened:\n %s\n", path,
	    sys_errlist[errno]);
    return(info);
  }
  if (fstat(fd,&statbuf) < 0) {
    perror("load_help_file: fstat");
    return(NULL);
  }

  if ((info = malloc(statbuf.st_size)) == NULL) {
    fprintf(stderr,"load_help_file: Could not allocate memory\n");
    close(fd);
    return(NULL);
  }
  read(fd,info,statbuf.st_size);
  return(info);
}

void
  show_help_message( buffer )
char* buffer;
{
  if (buffer == NULL)
    {
      OLH_ui_message("Sorry, help is currently unavailable...");
      return;
    }
  
  set_current_screen(SCR_VIEW);
  display_buffer(buffer);
  wait_for_key(win_view_wait);
  set_current_screen(SCR_PRIM);
}


void
  paint_instructions( )
{
  int i;
  
  for (i = 0; i < NUM_INSTR_LINES; i++)
    {
      wmove(win_instr, i, 0);
      waddstr(win_instr, instr_text[current_instr][i]);
    }
}

