/*
 * This file is part of the OLH system.
 *
 *      Lucien Van Elsen
 *	MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *	$Source: /mit/sipb-athena/src/olh/ascii/RCS/interrupt.c,v $
 *	$Id: interrupt.c,v 1.3 1996/03/19 00:41:14 warlord Exp $
 *	$Author: warlord $
 */

#ifndef lint
#ifndef SABER
static char *RCSid = "$Header: /mit/sipb-athena/src/olh/ascii/RCS/interrupt.c,v 1.3 1996/03/19 00:41:14 warlord Exp $";
#endif
#endif

#ifdef __NetBSD__
#include <sys/ioctl.h>
#endif

#ifdef linux
#include <termios.h>
#endif

#include "olh.h"

void
  handle_resize_event( )
{
  struct winsize ws;
  int lines;
  int cols;
  
  signal(SIGWINCH, SIG_IGN);
  
  delete_windows();
  
  /*  Find out the new size.  */
  
  if (ioctl(fileno(stdout), TIOCGWINSZ, &ws) == -1) {
    curses_shutdown();
    perror("handle_resize_event: ioctl:");
    exit(-2);
  }
  if (ws.ws_row != 0)
    lines = ws.ws_row;
  if (ws.ws_col != 0)
    cols = ws.ws_col;
  
  /*  Check that it is large enough  */
  
  if ((lines < MIN_LINES) || (cols < MIN_COLS))
    {
      curses_shutdown();
      printf("\n\nYou have made the window too small.\n\n");
      printf("Please enlarge it to %d columns by %d lines (or larger)\n",
	     MIN_COLS, MIN_LINES);
      printf("and start the On-Line Help program again.\n\n");
      exit(-2);
    }
  
  if ((lines > max_lines) || (cols > max_cols))
    {
      curses_shutdown();
      LINES = lines;
      COLS = cols;
      if (! curses_init())
	exit(-2);
    }
  else
    {
      LINES = lines;
      COLS = cols;
    }
  
  /*  Refresh everything  */
  
  create_windows();
  paint_windows();
  set_current_screen(current_screen);
  
  signal(SIGWINCH, handle_resize_event);
  return;
}

void
  handle_interrupt_event( )
{
  signal(SIGINT, SIG_IGN);
  
  curses_shutdown();
  exit(0);
}
