/*
 * This file is part of the OLH system.
 *
 *      Lucien Van Elsen
 *	MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *	$Source: /afs/athena.mit.edu/astaff/project/olhdev/src/ascii/RCS/olh.h,v $
 *	$Id: olh.h,v 1.14 91/06/30 18:26:23 lwvanels Exp $
 *	$Author:
 */

#ifndef __olh_h
#define __olh_h __FILE__

#include <curses.h>
#include <signal.h>
#include <strings.h>
#include <menu.h>
#include "menupath.h"
#include "text.h"

/*
 * System specific defines
 */

#ifdef TERMIO
#define cbreak() crmode()
#define nocbreak() nocrmode()
#endif

/*
 * Procedure shortcuts
 */

#define max(a,b)	((a) > (b)) ? (a) : (b)
#define min(a,b)	((a) < (b)) ? (a) : (b)

/*
 * Global Variables
 * 
 * This cruft should be changed/reduced/eliminated.
 */

extern Menu *menu[];
extern MenuEntry *menu_entry[], *top_entry;

extern short current[],viewed[], current_menu;

extern char *top_pointer;

extern char *program;
extern int hist_on;

extern int max_lines;
extern int max_cols;

extern char current_input[];

extern int scount;
extern WINDOW* scr[];

extern WINDOW* scr_prim;
extern WINDOW* scr_view;
extern WINDOW* scr_sugg;

extern int current_screen;


extern int wcount;
extern WINDOW* win[];

extern WINDOW* win_heading;
extern WINDOW* win_instr;
extern WINDOW* win_label;
extern WINDOW* win_entries;
extern WINDOW* win_above;
extern WINDOW* win_below;
extern WINDOW* win_prompt;
extern WINDOW* win_message;
extern WINDOW* win_view_wait;
extern WINDOW* win_sugg_wait;

extern int current_offset;
extern int selection;
extern int menu_lines;
extern int prev_above;
extern int prev_below;
extern int doing_keywords;
extern int keyword_level;

extern char* current_prompt;
extern char current_input[];

extern char current_message[];

extern int max_lines;
extern int max_cols;

extern int current_instr;



/*
 *  Constants
 */

/*  Screens  */

#define SCR_MAX		3
#define SCR_PRIM	0
#define SCR_VIEW	1
#define SCR_SUGG	2

#define MAX_DIGITS	5
#define MAX_CHARS	40
#define MIN_LINES	18
#define MIN_COLS	80
#define WIN_MAX		20

#define END_OF_STRING	'\000'
#define CTRL_B		'\002'
#define CTRL_C		'\003'
#define CTRL_F		'\006'
#define CTRL_G		'\007'
#define CTRL_N		'\016'
#define CTRL_P		'\018'
#define NEWLINE		'\n'
#define CTRL_L		'\f'
#define RETURN		'\r'
#define CTRL_U		'\025'
#define DELETE		'\177'
#define ESC		'\033'

#define TOKEN_NONE	0
#define TOKEN_HELP	1
#define TOKEN_UP	2
#define TOKEN_NEXT	3
#define TOKEN_CURR	4
#define TOKEN_PREV	5
#define TOKEN_ABOVE	6
#define TOKEN_BELOW	7
#define TOKEN_TOP	8
#define TOKEN_SUGGEST	9
#define TOKEN_BUG	10
#define TOKEN_OLC	11
#define TOKEN_SEL_NEXT	12
#define TOKEN_SEL_PREV	13
#define TOKEN_PRINT	14
#define TOKEN_COPY	15
#define TOKEN_INFO	16
#define TOKEN_KEYWORD	17
#define TOKEN_SHOW_PATH	18
#define TOKEN_SHOW_VERSION 19

#define TOKEN_EXIT	999
#define TOKEN_NUMBER	1000

#define SMALL_BUFFER	256
#define LARGE_BUFFER	1024

#define INSTR_NORMAL		0
#define INSTR_NORMAL_TOP	1
#define INSTR_KEYWORD_NUM	2
#define INSTR_KEYWORD_WORD	3

#define OLH_SUGGEST	0
#define OLH_BUG		1

/*
 * Functions
 */

#ifdef __STDC__
# define	P(s) s
#else
# define P(s) ()
#endif


/* system */
char *malloc P((unsigned size));
char *realloc P((char *ptr, unsigned size));
char *getenv P((char *name));

#ifdef NEEDS_ERRNO_DEFS
extern int errno;
extern int sys_nerr;
extern char *sys_errlist[];
#endif

/* context.c */
void show_context_path P((void ));
void construct_context P((char *p ));

/* copy.c */
void copy_module P((void ));

/* curses.c */
int curses_init P((void ));
void curses_shutdown P((void ));
void delete_char_from_buffer P((char **ptr ));
void sound_bell P((void ));
void OLH_ui_viewer_wait P((void ));
void wait_for_key P((WINDOW *w ));
void create_windows P((void ));
void delete_windows P((void ));
void paint_windows P((void ));
void paint_menu P((void ));
void paint_prompt P((void ));
void paint_message P((void ));
void paint_sugg P((void ));
void paint_bugs P((void ));
void set_current_screen P((int snumber ));

/* get_keyword.c */
int find_keyword_index P((char *key , int unique ));
int get_keyword P((void ));
void display_keyword_menu P((void ));
void invoke_k_item P((int number ));

/* get_number.c */
int get_number P((int ch ));

/* get_token.c */
int get_token P((char *prompt_string ));

/* help.c */
void OLH_ui_help_primary P((void ));
void OLH_ui_help_keyword P((void ));
void show_help_message P((char *buffer ));
void paint_instructions P((void ));

/* hooks.c */
void attach_hook P((char *filsys ));
void attach_done_hook P((char *filsys , long status ));

/* info.c */
void show_info P((void ));

/* interrupt.c */
void handle_resize_event P((void ));
void handle_interrupt_event P((void ));

/* keyword.c */
void do_keyword_startup P((char *kw ));

/* main.c */
void main P((int argc , char **argv ));
void MainLoop P((void ));

/* menupath.c */
void init_menupath P((void ));
void build_menupath P((MenuEntry *e [], int n ));
void add_to_menupath P((MenuEntry *e ));
void make_parents_menupath P((MenuEntry *e ));
void add_parent_to_menupath P((MenuEntry *e ));
void resize_menupath P((int size ));
void del_last_menupath P((void ));

/* mkstemp.c */
int mkstemp P((char *template ));

/* olc.c */
void invoke_olc P((void ));

/* print.c */
void print_module P((void ));

/* screen.c */
void OLH_ui_update_menus P((void ));
void OLH_ui_message P((char *str ));
void up_to_prev_menu P((void ));
void scroll_above P((void ));
void scroll_below P((void ));
void erase_message P((void ));
void select_item P((int num ));
void update_instructions P((void ));
void show_message P((char *string ));

/* suggest.c */
void take_bug_or_suggest P((int which ));
void OLH_edit_buffer P((char **buffer ));

/* view.c */
void invoke_item P((int number ));
int display_file P((char *path ));
int display_buffer P((char *buffer ));

#undef P
     
#endif
