/*
 * This file is part of the OLH system.
 * It is used to show the information on a node
 *
 *      Lucien Van Elsen
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /afs/athena.mit.edu/astaff/project/olhdev/src/ascii/RCS/print.c,v $
 *      $Id: print.c,v 1.6 91/04/23 12:26:55 lwvanels Exp $
 *      $Author: lwvanels $
 */

#include <hesiod.h>

#include <olh.h>

#ifdef ATHENA
#define DEFAULT_PRINTER		"linus"
#else
#define DEFAULT_PRINTER		"postscript"
#endif

#ifdef __STDC__
# define        P(s) s
#else
# define P(s) ()
#endif

static char *get_default_printer P((void ));

#undef P



void
print_module()
{
  MenuEntry *e;
  char *def_printer;
  char buffer[80],new_printer[80],new_prompt[80];
  char **h;
  char ch;
  long code;

  if (current[current_menu] == 0) {
    sprintf(buffer,"Please select an item first.");
    OLH_ui_message(buffer);
    return;
  }

  e = nth_entry(menu[current_menu],current[current_menu]);

  if (is_menu(e)) {
    sprintf(buffer,"You cannnot print a menu.  Please select a document instead and try again.");
    OLH_ui_message(buffer);
    return;
  }

  def_printer = getenv("PRINTER");

  /* No printer set, try to get it from the cluster information */
  if (def_printer == NULL)
#ifdef ATHENA
    def_printer = get_default_printer();
#else
    /* Insert whatever is appropriate for your site */
    def_printer = "Yourprinter";
#endif

  sprintf(buffer,"Default: %s",def_printer);
  sprintf(new_prompt,"Print \"%s\" to: ",field_value(e,NODE_LABEL));

  while(1) {
    current_prompt = new_prompt;
    OLH_ui_message(buffer);
    paint_prompt();
    wrefresh(win_prompt);
    
    echo();
    if (wgetstr(win_prompt,new_printer) == OK) {
      if (new_printer[0] == '\0') {
	strcpy(new_printer,def_printer);
	break;
      }
#ifdef HESIOD
      else {
	/* check that it's a valid printer; valid printers must have a PCAP */
	/* entry */
	h = hes_resolve(new_printer,"pcap");
	if ((h == NULL) || (*h == NULL)) {
	  OLH_ui_message("Invalid printer name; press any key to continue");
	  noecho();
	  ch = wgetch(win_prompt);
	  continue;
	}
#endif

#ifdef PUTENV
	sprintf(buffer,"PRINTER=%s",new_printer);
	(void) putenv(buffer);
#else
	setenv("PRINTER",new_printer,TRUE);
#endif
	break;
      }
    }
  }
  
  noecho();
  code = viewdoc(e,LPTLN,NULL);
  if (code == 0)
    OLH_ui_message("Printing successful.");
  else
    OLH_ui_message("Error printing; press any key to continue");
}

#ifdef ATHENA
static char *
get_default_printer()
{
  static char p[32];
  char host[32];
  char **hv;
  int len = 4;  /* length of string "lpr " */

  if (p[0] == '\0')
    strcpy(p,DEFAULT_PRINTER);
  gethostname(host, sizeof (host));
  if ((hv = hes_resolve(host, "cluster")) == NULL)
    return p;
  while (*hv) {
    if (strncmp(*hv, "lpr ", len) == NULL) {
      strcpy(p, *hv + len);
      return(p);
    }
    ++hv;
  }
  return p;
}
#endif
