/*
 * This file is part of the OLH On-Line Help system
 *
 *	Chris VanHaren
 *	Lucien Van Elsen
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /afs/sipb/project/sipb-athena/olh/motif/RCS/visual.c,v $
 *      $Id: visual.c,v 1.14 1992/07/07 18:34:31 lwvanels Exp $
 *      $Author: lwvanels $
 */

#include "global.h"
#include "widget_num.h"
#include "MuMenu.h"

#include <hesiod.h>

#include "olh.xbm"

#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/SeparatoG.h>
#include <Xm/LabelG.h>
#include <Xm/Frame.h>
#include <Xm/Mu.h>
#include <Xm/RowColumn.h>
#include <Xm/MessageB.h>
#include <Xm/MenuShell.h>
#include <Xm/Text.h>
#include <Xm/List.h>
#include <Xm/PanedW.h>
#include <Xm/DialogS.h>
#include <Xm/SelectioB.h>

#ifdef __STDC__
# define        P(s) s
#else
# define P(s) ()
#endif

static char *get_default_printer P((void ));

extern char *getenv P((char *name));

#undef P

static MuCallbacksRec callbacks[] = {
  {"button",	ButtonCB },
  {"File",	File },
  {"toggleb",	toggleCB },
};

Widget  W, w[LAST_WIDGET];

#define N_DIALOGS	7

#define N_SENDBUG_DLG	0
#define N_SUGGEST_DLG	1
#define N_INFO_DLG	2
#define N_COPY_DLG	3
#define N_KWD_DLG	4
#define N_BKMK_DLG	5
#define N_PRINT_DLG	6

static int d_made[N_DIALOGS];

static char *buttons[] = {"file",
			    "search",
			    "options",
			    "suggest",
			    "help",
			  };
#define NUM_BUTTONS	(sizeof(buttons)/sizeof(char *))


/****************************************************************
 * MakeInterface() -- build interface				*
 ****************************************************************/
void
MakeInterface()
{
  int i;
  Arg A[10];
  Pixmap icon_pixmap = None;
  Widget W;

  add_help_menus();

  W = w[MAIN] = XtCreateManagedWidget("main", xmFormWidgetClass,
				  w[TOPLEVEL], NULL, 0);
  XtAddRawEventHandler(W, KeyPressMask, FALSE, ListExtra, MENU_LIST);

  (void) XtCreateManagedWidget("banner", xmLabelGadgetClass,
			       w[MAIN], NULL, 0);

  MuRegisterMenuCallbacks( callbacks, XtNumber(callbacks) );
  
  W = w[MENU_BAR] = MuCreateMenuBar( w[MAIN], "menubar", NULL, 0);
  XtManageChild(W);
/*
  XtAddRawEventHandler(W, KeyPressMask, FALSE, ListExtra, MENU_LIST);
*/

  /* Fix menu button for External viewers so that it is correct given the */
  /* default.*/

  W = MuLookupWidget("ev");
  if (W != NULL)
    XmToggleButtonGadgetSetState(W,olh_res.use_viewers,FALSE);

  XtSetArg (A[0], XtNiconPixmap, &icon_pixmap);
  XtGetValues(w[TOPLEVEL], A, 1);
  if (icon_pixmap == None) {
    XtSetArg(A[0], XtNiconPixmap,
	     XCreateBitmapFromData(XtDisplay(w[TOPLEVEL]),
				   XtScreen(w[TOPLEVEL])->root,
				   help_bits, help_width, help_height));
    XtSetValues (w[TOPLEVEL], A, 1);
  }

  MakeMessageLabel();

#ifdef HIDDEN
/*
 * Paned window and children
 */

  w[PANE_FORM] = XtCreateManagedWidget("paneForm", xmFormWidgetClass,
				       w[MAIN], NULL, 0);

  w[PANE] = XtCreateManagedWidget("pane", xmPanedWindowWidgetClass,
				  w[PANE_FORM], NULL, 0);
#endif

  MakeMenuForm();
#ifdef HIDDEN
  MakeHistForm();
#endif
  MakeTextView();

  XtInstallAllAccelerators(w[MAIN], w[MAIN]);
  XtInstallAllAccelerators(w[MENU_FORM], w[MAIN]);
  XtInstallAllAccelerators(w[MENU_LIST], w[MAIN]);
#ifdef HIDDEN
  XtInstallAllAccelerators(w[HIST_FORM], w[MAIN]);
#endif
  XtInstallAllAccelerators(w[MENU_OPT], w[MAIN]);
  XtInstallAllAccelerators(w[MENU_BAR], w[MAIN]);

  for (i=0; i < NUM_BUTTONS; i++)
    if ((W = MuGetWidget(buttons[i])) == NULL)
      fprintf(stderr, "%s: Unable to set accelerator on %s button\n",
	      program, buttons[i]);
    else
      XtInstallAllAccelerators(W, w[MAIN]);
}



/****************************************************************
 * Message Label and Separator
 ****************************************************************/
void
MakeMessageLabel()
{
  w[MSG_LBL] = XtCreateManagedWidget("message", xmLabelGadgetClass,
				     w[MAIN], NULL, 0);

  W = w[QUIT_BTN2] = XtCreateManagedWidget("quit",
					   xmPushButtonWidgetClass,
					   w[MAIN], NULL, 0);
  XtAddCallback(W, XmNactivateCallback, ButtonCB, QUIT_BTN);
  XtAddRawEventHandler(W, KeyPressMask, FALSE, ListExtra, MENU_LIST);

  (void) XtCreateManagedWidget("messageSep", xmSeparatorGadgetClass,
			       w[MAIN], NULL, 0);
}


/****************************************************************
 * Menu Form and Children
 ****************************************************************/
void
MakeMenuForm()
{
  Arg args[2];

  w[MENU_FORM] = XtCreateManagedWidget("menuForm", xmFormWidgetClass,
#ifdef HIDDEN
				       w[PANE],
#else
				       w[MAIN],
#endif
				       NULL, 0);

/*
  W = w[FOO] = XmCreatePopupMenu(w[MENU_FORM], "foo", NULL, 0);

  W = w[FOO2] = XtCreateManagedWidget("foo2",
				      xmPushButtonWidgetClass,
				      w[FOO], NULL, 0);
  XtAddCallback(W, XmNactivateCallback, ButtonCB, FOO2);

  W = XtCreateManagedWidget("bar", xmPushButtonWidgetClass,
			    w[MENU_FORM], NULL, 0);
  XtAddCallback(W, XmNactivateCallback, ButtonCB, MENU_FORM);
*/

  w[MENU_MENU] = XmCreatePulldownMenu(w[MENU_FORM], "menuPulldown", NULL, 0);

  XtSetArg(args[0], XmNsubMenuId, w[MENU_MENU]);
  XtSetArg(args[1], XmNrowColumnType, XmMENU_OPTION);
  W = w[MENU_OPT] = XmCreateRowColumn(w[MENU_FORM], "menuName",
				      args, 2);
  XtManageChild(W);
  XtAddRawEventHandler(W, KeyPressMask, FALSE, ListExtra, MENU_LIST);

/* Buttons */

  W = w[PREV_BTN] = XtCreateManagedWidget("previous",
					  xmPushButtonWidgetClass,
					  w[MENU_FORM], NULL, 0);
  XtAddCallback(W, XmNactivateCallback, ButtonCB, PREV_BTN);
  XtAddRawEventHandler(W, KeyPressMask, FALSE, ListExtra, MENU_LIST);

  W = w[VIEW_BTN] = XtCreateManagedWidget("view",
					  xmPushButtonWidgetClass,
					  w[MENU_FORM], NULL, 0);
  XtAddCallback(W, XmNactivateCallback, ButtonCB, VIEW_BTN);
  XtAddRawEventHandler(W, KeyPressMask, FALSE, ListExtra, MENU_LIST);

  W = w[NEXT_BTN] = XtCreateManagedWidget("next",
					  xmPushButtonWidgetClass,
					  w[MENU_FORM], NULL, 0);
  XtAddCallback(W, XmNactivateCallback, ButtonCB, NEXT_BTN);
  XtAddRawEventHandler(W, KeyPressMask, FALSE, ListExtra, MENU_LIST);

  W = w[UP_BTN] = XtCreateManagedWidget("up",
					xmPushButtonWidgetClass,
					w[MENU_FORM], NULL, 0);
  XtAddCallback(W, XmNactivateCallback, ButtonCB, UP_BTN);
  XtAddRawEventHandler(W, KeyPressMask, FALSE, ListExtra, MENU_LIST);

/* List widget */

  W = w[MENU_LIST] = XmCreateScrolledList(w[MENU_FORM], "menuList", NULL, 0);
  XtAddCallback(W, XmNsingleSelectionCallback, list_1_click, MENU_LIST);
  XtAddCallback(W, XmNdefaultActionCallback, list_2_click, MENU_LIST);
  XtManageChild(W);
  XmAddTabGroup(W);
  XtAddRawEventHandler(W, KeyPressMask, FALSE, ListExtra, MENU_LIST);
}


#ifdef HIDDEN
/****************************************************************
 * History Form and Children
 ****************************************************************/
void
MakeHistForm()
{
  w[HIST_FORM] = XtCreateWidget("histForm", xmFormWidgetClass,
				       w[PANE], NULL, 0);

  (void) XtCreateManagedWidget("history", xmLabelGadgetClass,
			       w[HIST_FORM], NULL, 0);

/* Buttons */

  W = w[BACK_BTN] = XtCreateManagedWidget("back",
					xmPushButtonWidgetClass,
					w[HIST_FORM], NULL, 0);
  XtAddCallback(W, XmNactivateCallback, ButtonCB, UP_BTN);

  W = w[LAST_BTN] = XtCreateManagedWidget("last",
					  xmPushButtonWidgetClass,
					  w[HIST_FORM], NULL, 0);
  XtAddCallback(W, XmNactivateCallback, ButtonCB, LAST_BTN);

  W = w[GOTO_BTN] = XtCreateManagedWidget("goto",
					  xmPushButtonWidgetClass,
					  w[HIST_FORM], NULL, 0);
  XtAddCallback(W, XmNactivateCallback, ButtonCB, GOTO_BTN);

  W = w[FORW_BTN] = XtCreateManagedWidget("forward",
					  xmPushButtonWidgetClass,
					  w[HIST_FORM], NULL, 0);
  XtAddCallback(W, XmNactivateCallback, ButtonCB, FORW_BTN);

/* Frame and List */

  w[HIST_FRM] = XtCreateManagedWidget("histFrame", xmFrameWidgetClass,
				      w[HIST_FORM], NULL, 0);

  W = w[HIST_LIST] = XmCreateScrolledList(w[HIST_FRM], "histList", NULL, 0);
  XtAddCallback(W, XmNsingleSelectionCallback, list_1_click, HIST_LIST);
  XtAddCallback(W, XmNdefaultActionCallback, list_2_click, HIST_LIST);
  XtManageChild(W);
  XmAddTabGroup(W);
  XtAddRawEventHandler(W, KeyPressMask, FALSE, ListExtra, HIST_LIST);
}
#endif


/****************************************************************
 * Pop-up Text window with scroll-bar
 ****************************************************************/
void
MakeTextView()
{
  Arg arg;

  XtSetArg(arg, XmNmappedWhenManaged, FALSE);
  w[TEXT_DLG] = XtAppCreateShell("textView", "Olh",
				 topLevelShellWidgetClass,
				 XtDisplay(w[TOPLEVEL]), &arg, 1);

  w[TEXT_FORM]  = XtCreateManagedWidget("textForm", xmFormWidgetClass,
					w[TEXT_DLG], NULL, 0);

  w[TEXT_LBL] = XtCreateManagedWidget("textLabel", xmLabelGadgetClass,
				      w[TEXT_FORM], NULL, 0);

  W = w[TEXT_CLOSE_BTN] = XtCreateManagedWidget("textClose",
						xmPushButtonWidgetClass,
						w[TEXT_FORM], NULL, 0);
  XtAddCallback(W, XmNactivateCallback, ButtonCB, TEXT_CLOSE_BTN);

  W = w[TEXT_TEXT] = XmCreateScrolledText(w[TEXT_FORM], "text", NULL, 0);
  MuSetEmacsBindings(W);
  XtManageChild(W);

  XtRealizeWidget(w[TEXT_DLG]);

  XtInstallAllAccelerators(w[TEXT_FORM], w[TEXT_FORM]);
  XtInstallAllAccelerators(XtParent(w[TEXT_TEXT]), w[TEXT_FORM]);
  XtInstallAllAccelerators(w[TEXT_TEXT], w[TEXT_FORM]);
  XtInstallAllAccelerators(w[TEXT_CLOSE_BTN], w[TEXT_FORM]);

  XtSetArg(arg, XmNverticalScrollBar, &W);
  XtGetValues(XtParent(w[TEXT_TEXT]), &arg, 1);
  if (W != NULL)
    XtInstallAllAccelerators(W, w[TEXT_FORM]);
}


/****************************************************************
 * Pop-up dialog boxes
 ****************************************************************/
void
MakeDialog(which)
     int which;
{
  Arg args[3];
  int n;
  char printer_list[2048];
  char *ptr, *end;
  XmString printers[100];
  extern void do_keyword_expose();

/*
 * Sendbug dialog box.
 */

  switch(which) {
  case SENDBUG_DLG:
    if (d_made[N_SENDBUG_DLG])
      break;
    XtSetArg(args[0], XmNmappedWhenManaged, FALSE);
    W = w[SENDBUG_DLG] = XtAppCreateShell("sendbugDialog", "Olh",
					  topLevelShellWidgetClass,
					  XtDisplay(w[TOPLEVEL]), args, 1);
    W = w[SENDBUG_FORM] = XtCreateManagedWidget("sendbugForm",
						xmFormWidgetClass,
						w[SENDBUG_DLG], NULL, 0);
    (void) XtCreateManagedWidget("sendbugLabel", xmLabelGadgetClass,
				 w[SENDBUG_FORM], NULL, 0);
    W = w[SENDBUG_SEND_BTN] = XtCreateManagedWidget("sendbugSend",
						    xmPushButtonWidgetClass,
						    w[SENDBUG_FORM], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, SENDBUG_SEND_BTN);
    W = w[SENDBUG_CLOSE_BTN] = XtCreateManagedWidget("sendbugClose",
						     xmPushButtonWidgetClass,
						     w[SENDBUG_FORM], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, SENDBUG_CLOSE_BTN);
    W = XtCreateManagedWidget("sendbugSep", xmSeparatorGadgetClass,
			      w[SENDBUG_FORM], NULL, 0);
    W = w[SENDBUG_TEXT] = XmCreateScrolledText(w[SENDBUG_FORM], "sendbugText",
					       NULL, 0);
    MuSetEmacsBindings(W);
    XtManageChild(W);
    d_made[N_SENDBUG_DLG] = 1;
    XtRealizeWidget(w[SENDBUG_DLG]);
    break;
    
/*
 * Send suggestion dialog box.
 */
  case SUGGEST_DLG:
    if (d_made[N_SUGGEST_DLG])
      break;
    XtSetArg(args[0], XmNmappedWhenManaged, FALSE);
    W = w[SUGGEST_DLG] = XtAppCreateShell("suggestDialog", "Olh",
					  topLevelShellWidgetClass,
					  XtDisplay(w[TOPLEVEL]), args, 1);
    W = w[SUGGEST_FORM] = XtCreateManagedWidget("suggestForm",
						xmFormWidgetClass,
						w[SUGGEST_DLG], NULL, 0);
    (void) XtCreateManagedWidget("suggestLabel", xmLabelGadgetClass,
				 w[SUGGEST_FORM], NULL, 0);
    W = w[SUGGEST_SEND_BTN] = XtCreateManagedWidget("suggestSend",
						    xmPushButtonWidgetClass,
						    w[SUGGEST_FORM], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, SUGGEST_SEND_BTN);
    W = w[SUGGEST_CLOSE_BTN] = XtCreateManagedWidget("suggestClose",
						     xmPushButtonWidgetClass,
						     w[SUGGEST_FORM], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, SUGGEST_CLOSE_BTN);
    W = XtCreateManagedWidget("suggestSep", xmSeparatorGadgetClass,
			      w[SUGGEST_FORM], NULL, 0);
    W = w[SUGGEST_TEXT] = XmCreateScrolledText(w[SUGGEST_FORM], "suggestText",
					       NULL, 0);
    MuSetEmacsBindings(W);
    XtManageChild(W);
    d_made[N_SUGGEST_DLG] = 1;
    XtRealizeWidget(w[SUGGEST_DLG]);
    break;

/*
 * Info dialog box.
 */

  case INFO_DLG:
    if (d_made[N_INFO_DLG])
      break;
    W = w[INFO_DLG] = XmCreateFormDialog(w[TOPLEVEL], "infoDialog",
					 NULL, 0);
    w[INFO_LBL] = XtCreateManagedWidget("infoLabel", xmLabelGadgetClass,
					w[INFO_DLG], NULL, 0);
    W = w[INFO_CLOSE_BTN] = XtCreateManagedWidget("infoClose",
						  xmPushButtonWidgetClass,
						  w[INFO_DLG], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, INFO_CLOSE_BTN);
    W = XtCreateManagedWidget("infoSep", xmSeparatorGadgetClass,
			      w[INFO_DLG], NULL, 0);
    W = w[INFO_TEXT] = XmCreateScrolledText(w[INFO_DLG], "infoText",
					    NULL, 0);
    XtManageChild(W);
    XtInstallAllAccelerators(w[INFO_DLG], w[INFO_DLG]);
    XtInstallAllAccelerators(XtParent(w[INFO_TEXT]), w[INFO_DLG]);
    XtInstallAllAccelerators(w[INFO_TEXT], w[INFO_DLG]);
    d_made[N_INFO_DLG] =1;
    break;

/*
 * Copy dialog box.
 */

  case COPY_DLG:
    if (d_made[N_COPY_DLG])
      break;
    W = w[COPY_DLG] = XmCreateFormDialog(w[TOPLEVEL], "copyDialog",
					 NULL, 0);
    w[COPY_LBL] = XtCreateManagedWidget("copyLabel", xmLabelGadgetClass,
					w[COPY_DLG], NULL, 0);
    W = w[COPY_OK_BTN] = XtCreateManagedWidget("copyOK",
					       xmPushButtonWidgetClass,
					       w[COPY_DLG], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, COPY_OK_BTN);
    W = w[COPY_CLOSE_BTN] = XtCreateManagedWidget("copyClose",
						  xmPushButtonWidgetClass,
						  w[COPY_DLG], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, COPY_CLOSE_BTN);
    W = XtCreateManagedWidget("copySep", xmSeparatorGadgetClass,
			      w[COPY_DLG], NULL, 0);
    W = w[COPY_TEXT] = XtCreateManagedWidget("copyText", xmTextWidgetClass,
					     w[COPY_DLG], NULL, 0);
    MuSetEmacsBindings(W);
    XtAddCallback(W, XmNactivateCallback, File_ok, COPY_DLG);
    d_made[N_COPY_DLG] = 1;
    break;

/*
 * Keyword dialog box.
 */

  case KWD_DLG:
    if (d_made[N_KWD_DLG])
      {
	show_message(" ");
	break;
      }
    XtSetArg(args[0], XmNmappedWhenManaged, FALSE);
    w[KWD_DLG] = XtAppCreateShell("keywordDialog", "Olh",
				  topLevelShellWidgetClass,
				  XtDisplay(w[TOPLEVEL]), args, 1);
    w[KWD_FORM] = XtCreateManagedWidget("keywordForm", xmFormWidgetClass,
					w[KWD_DLG], NULL, 0);
    w[KWD_MSG] = XtCreateManagedWidget("keywordMessage",
					   xmLabelGadgetClass, w[KWD_FORM],
					   NULL, 0);
    W = w[KWD_CLOSE_BTN] = XtCreateManagedWidget("keywordClose",
						 xmPushButtonWidgetClass,
						 w[KWD_FORM], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, KWD_CLOSE_BTN);
    (void) XtCreateManagedWidget("keywordMessageSep",
				 xmSeparatorGadgetClass, w[KWD_FORM], NULL,
				 0);
    W = w[KWD_SEND_BTN] = XtCreateManagedWidget("keywordSend",
						xmPushButtonWidgetClass,
						w[KWD_FORM], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, KWD_SEND_BTN);
    W = w[KWD_UP_BTN] = XtCreateManagedWidget("keywordUp",
					      xmPushButtonWidgetClass,
					      w[KWD_FORM], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, KWD_UP_BTN);
    (void) XtCreateManagedWidget("keywordEntryLabel",
				 xmLabelGadgetClass,
				 w[KWD_FORM], NULL, 0);
    W = w[KWD_TEXT] = XtCreateManagedWidget("keywordText", xmTextWidgetClass,
					    w[KWD_FORM], NULL, 0);
    MuSetEmacsBindings(W);
/*    XmAddTabGroup(W); */
    W = w[KWD_LIST] = XmCreateScrolledList(w[KWD_FORM],
					   "keywordList", NULL, 0);
    XtAddCallback(W, XmNsingleSelectionCallback, list_1_click, KWD_LIST);
    XtAddCallback(W, XmNdefaultActionCallback, list_2_click, KWD_LIST);
    XtManageChild(W);
    XmAddTabGroup(W);
    XtAddRawEventHandler(W, KeyPressMask, FALSE, ListExtra, KWD_LIST);
    XtAddRawEventHandler(W, ExposureMask, FALSE, do_keyword_expose, KWD_LIST); 
    XtRealizeWidget(w[KWD_DLG]);

    XtInstallAllAccelerators(w[KWD_FORM], w[KWD_FORM]);
    XtInstallAllAccelerators(XtParent(w[KWD_LIST]), w[KWD_FORM]);
    XtInstallAllAccelerators(w[KWD_LIST], w[KWD_FORM]);
/*
 *  The accelerators screw up the motif 1.1.x text widget, so we'll just
 *  leave them out. Sigh.  Motif strikes again...
 *
    XtInstallAllAccelerators(w[KWD_TEXT], w[KWD_FORM]);
*/
    XtInstallAllAccelerators(w[KWD_SEND_BTN], w[KWD_FORM]);
    XtInstallAllAccelerators(w[KWD_CLOSE_BTN], w[KWD_FORM]);
    XtInstallAllAccelerators(w[KWD_UP_BTN], w[KWD_FORM]);

    XtAddCallback(w[KWD_TEXT], XmNactivateCallback, k_entered, NULL);
    XtAddCallback(w[KWD_TEXT], XmNvalueChangedCallback, k_changed, NULL);

    show_k_message(" ");
    d_made[N_KWD_DLG] = 1;
    break;

#ifdef HIDDEN
/*
 * Bookmark dialog box.
 */
  case BKMK_DLG:
    if (d_made[N_BKMK_DLG])
      break;
    XtSetArg(args[0], XmNautoUnmanage, FALSE);
    W = w[BKMK_DLG] = XmCreateFormDialog(w[TOPLEVEL], "bookmarkDialog",
					 args, 1);
    
    (void) XtCreateManagedWidget("bookmarkLabel", xmLabelGadgetClass,
				 w[BKMK_DLG], NULL, 0);
    
    W = w[BKMK_SEND_BTN] = XtCreateManagedWidget("bookmarkSend",
						 xmPushButtonWidgetClass,
						 w[BKMK_DLG], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, BKMK_SEND_BTN);
    
    W = w[BKMK_DEL_BTN] = XtCreateManagedWidget("bookmarkDelete",
						xmPushButtonWidgetClass,
						w[BKMK_DLG], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, BKMK_DEL_BTN);
    
    W = w[BKMK_CLOSE_BTN] = XtCreateManagedWidget("bookmarkClose",
						  xmPushButtonWidgetClass,
						  w[BKMK_DLG], NULL, 0);
    XtAddCallback(W, XmNactivateCallback, ButtonCB, BKMK_CLOSE_BTN);
    
    W = w[BKMK_LIST] = XmCreateScrolledList(w[BKMK_DLG], "bookmarkList",
					    NULL, 0);
    XtManageChild(W);
    XmAddTabGroup(W);
    d_made[N_BKMK_DLG] = 1;
    break;
#endif


/*
 * Printer dialog box.
 */

  case PRINT_DLG:
    if (d_made[N_PRINT_DLG])
      break;
    if ((ptr = GetDefault(XtDisplay(w[TOPLEVEL]), "Olh", "printerList"))
	== NULL)
      ptr = "error:printer_list_is_empty"; 
    strcpy(printer_list, ptr);
    
    ptr = printer_list;
    for (n=0; end = index(ptr, ' '); n++)
      {
	*end = '\0';
	printers[n] = MOTIF_STRING(ptr);
	ptr = ++end;
      }
    printers[n++] = MOTIF_STRING(ptr);
    
    XtSetArg(args[0], XmNlistItems, printers);
    XtSetArg(args[1], XmNlistItemCount, n);
    
    if ((ptr = get_default_printer()) != NULL)
      {
	XtSetArg(args[2], XmNtextString, MOTIF_STRING(ptr));
	n=3;
      }
    else
      n=2;
    
    W = w[PRINT_DLG] = XmCreateSelectionDialog(w[TOPLEVEL], "printDialog",
					       args, n);
    XtAddCallback(W, XmNokCallback, File_ok, PRINT_DLG);
    XtDestroyWidget(XmSelectionBoxGetChild(W, XmDIALOG_HELP_BUTTON));
    d_made[N_PRINT_DLG] = 1;
    MuSetEmacsBindings(XmSelectionBoxGetChild(W, XmDIALOG_TEXT));
    break;

  default:
    fprintf(stderr,"Unknown dialog make request %d\n",which);
  }
}

static char *
get_default_printer()
{
  static char p[32];
  char *foo;
  char host[32];
  char **hv;
  int len = 4;  /* length of string "lpr " */

  foo = getenv("PRINTER");
  if (foo != NULL) {
    strcpy(p,foo);
    return(p);
  }

  gethostname(host, sizeof (host));

  if ((hv = hes_resolve(host, "cluster")) == NULL)
    return(NULL);
  while (*hv) {
    if (strncmp(*hv, "lpr ", len) == 0) {
      strcpy(p, *hv + len);
      return(p);
    }
    ++hv;
  }
  return(NULL);
}
