#include <iostream.h>
#include <Fork.h>

static void print (char* name, pid_t child)
{
  if (child) {
    cerr << "Parent " << getppid () << "; "
      << name << ' ' << getpid () << "; Child " << child << ";\n";
  } else if (0) {
    cerr << "Parent " << getppid () << "; "
      << name << "'s child " << getpid () << ";\n";
  }
}

int main (int ac, char** av)
{
  Fork::suicide_signal (SIGTERM);

  Fork a(0, 1);
  
  print ("a", a.process_id ());

  if (a.is_child ()) {
    sleep (3000);
  } else if (a.is_parent ()) {
    Fork b (1, 1);
    print ("b", b.process_id ());
    {
      Fork c (b.is_parent (), 1);
      if (b.is_child ())
	print ("cchild", c.process_id ());
      else
	print ("cparent", c.process_id ());
      if (c.is_child ()) {
	sleep (3000);
	return 0;
      }
    }
    if (b.is_child ()) {
      sleep (120);
      return 0x8;
    }
  }

  return 0;
}
      
