/* $Id: xmalloc.c,v 1.9 2002/12/27 20:31:20 relson Exp $ */

/*
* NAME:
*    xmalloc.c -- front-end to standard heap manipulation routines, with error checking.
*
* AUTHOR:
*    Gyepi Sam <gyepi@praxis-sw.com>
*
*/

#include <stdlib.h>
#include "xmalloc.h"


void *
xmalloc(size_t size){
	void *x;
	x = malloc(size);
	if (x == NULL && size == 0)
	    x = malloc(1);
	if (x == NULL) {
	    xmem_error("xmalloc"); 
	}
	return x;
}

void
xfree(void *ptr){
  if (ptr) free(ptr);
}

