#include <stdio.h>
#include <string.h>

#include "configure.h"

#define streq(a,b) (!(strcmp((a), (b))))

int logtype = LOG_COMMON;

char *configfile = 0;
char servername[81];
char logfile[81];
char filepath[81];
char webpath[81];
char webhome[81];

char *ignored_sites[SITES_MAX];
int ignored_sites_t = 0;

char *items[ITEMS_MAX];
int item_accs[ITEMS_MAX];
int items_t = 0;

char *hidden_items[ITEMS_MAX];
int hidden_items_t = 0;
char *ignored_items[ITEMS_MAX];
int ignored_items_t = 0;

void remove_trailing_sp(/* char *s */);

void configure() {
	if (!configfile) {
		fprintf(stderr, "Error: -c option not specified.\n");
		fprintf(stderr, "-c must be used to specify a configuration file.\n");
		usage();
		exit(-1);
	} else {
		FILE *in;
		char s[81];
		in = fopen(configfile, "r");
		if (!in) {
			fprintf(stderr, "Error: configuration file %s not found.\n", configfile);
			exit(-1);
		}
		if (!getline(in, s)) {
			fprintf(stderr, "Error in configuration file: empty?\n");
			exit(-1);
		}
		if (streq(s, "CERN_HTTPD")) {
			logtype = LOG_CERN_OLD;
			getline(in, servername);
		} else if (streq(s, "NCSA_HTTPD")) {
			logtype = LOG_NCSA_OLD;
			getline(in, servername);
		} else if (streq(s, "COMMON")) {
			logtype = LOG_COMMON;
			getline(in, servername);
		} else {
			strcpy(servername, s);
		} 
		getline(in, filepath);
		getline(in, webpath);
		getline(in, webhome);
		getline(in, logfile);
	
		if (!getline(in, s)) {
			/* Old-style configuration file- that's OK */
			return;
		}
		if (!streq(s, "{")) {
			fprintf(stderr, 
				"{ expected at start of hidden items.\n");
			fprintf(stderr,
				"(Did you not yet remove the pbmplus path line\n");
			fprintf(stderr,
				"and the wusage binary path line?\n");
			fprintf(stderr,
				"They are no longer required in versions 3.0\n");
			fprintf(stderr,
				"and above.)\n");
			exit(-1);
		}
		while(1) {
			if (!getline(in, s)) {
				fprintf(stderr,
					"unexpected end of file\n");
				exit(-1);
			}
			if (streq(s, "}")) {
				break;
			}
			remove_trailing_sp(s);
			hidden_items[hidden_items_t++] = strdup(s);
		}	
		if (!getline(in, s)) {
			/* No more stanzas- we can tolerate that */
			return;
		}
		if (!streq(s, "{")) {
			fprintf(stderr, 
				"{ expected at start of ignored items\n");
			exit(-1);
		}
		while(1) {
			if (!getline(in, s)) {
				fprintf(stderr,
					"unexpected end of file\n");
				exit(-1);
			}
			if (streq(s, "}")) {
				break;
			}
			remove_trailing_sp(s);
			ignored_items[ignored_items_t++] = strdup(s);
		}	
		if (!getline(in, s)) {
			/* No more stanzas- we can tolerate that */
			return;
		}
		if (!streq(s, "{")) {
			fprintf(stderr, 
				"{ expected at start of ignored sites\n");
			exit(-1);
		}
		while(1) {
			if (!getline(in, s)) {
				fprintf(stderr,
					"unexpected end of file\n");
				exit(-1);
			}
			if (streq(s, "}")) {
				break;
			}
			remove_trailing_sp(s);
			ignored_sites[ignored_sites_t++] = strdup(s);
		}	
	}
}

int getline(in, s)
	FILE *in; 
	char *s; 
{
	while(!feof(in)) {
		if (!fgets(s, 80, in)) {
			return 0;
		}
		if (s[0] == '#') {
			continue;
		}
		if (s[strlen(s)-1] == '\n') {
			s[strlen(s)-1] = '\0';
		}
		return 1;
	}
	return 0;
}	

void remove_trailing_sp(s)
	char *s; 
{
	int i;
	while(1) {
		int l;
		l = strlen(s);
		if (!l) {
			return;
		}
		if (s[l-1] == ' ') {
			s[l-1] = '\0';
		} else {
			return;
		}
	}
}
