/* gd.h: declarations file for the gifdraw module.

	Written by Tom Boutell, 5/94.
	Copyright 1994, Cold Spring Harbor Labs.
	Permission granted to use this code in any fashion provided
	that this notice is retained and any alterations are
	labeled as such. It is requested, but not required, that
	you share extensions to this module with us so that we
	can incorporate them into new versions. */

/* This can't be changed, it's part of the GIF specification. */

#define gdMaxColors 256

/* Image type. See functions below; you will not need to access
	the elements directly. */
typedef struct {
	unsigned char ** pixels;
	int sx;
	int sy;
	int colorsTotal;
	int red[gdMaxColors];
	int green[gdMaxColors];
	int blue[gdMaxColors]; 
} gdImage;

typedef gdImage * gdImagePtr;

/* Width and height of a character in the gd font, for use in your
	computations. (The font is derived from a public domain
	font in the X11 distribution.) */

#define gdFontWidth 8
#define gdFontHeight 16

/* Functions to manipulate images. */

gdImagePtr gdImageCreate(/* int sx, int sy */);
void gdImageDestroy(/* gdImagePtr im */);
void gdImageSetPixel(/* gdImagePtr im, int x, int y, int color */);
int gdImageGetPixel(/* gdImagePtr im, int x, int y */);
void gdImageLine(/* gdImagePtr im, int x1, int y1, 
	int x2, int y2, int color */);
int gdImageBoundsSafe(/* gdImagePtr im, int x, int y */);
void gdImageChar(/* gdImagePtr im, int x, int y, char c, int color */);
void gdImageCharUp(/* gdImagePtr im, int x, int y, char c, int color */);
void gdImageString(/* gdImagePtr im, int x, int y, char *s, int color */);
void gdImageStringUp(/* gdImagePtr im, int x, int y, char *s, int color */);
int gdImageColorAllocate(/* gdImagePtr im, int r, int g, int b */);
void gdImageGif(/* gdImagePtr im, FILE *out */);
