/*
 * Prototypes for Fast Fourier Transform algorithms.
 * Adapted from "Numerical Recipes".
 *
 * $Date: 1997/06/09 19:18:00 $
 */

#ifndef _FFT_H
#define _FFT_H

#include "complex.h"

void fft(complex[], unsigned long, int);

typedef struct FFT_Context_Data {
  unsigned long nn;
  int isign;
  complex *Wbase;
  complex *Wexp;
} *FFT_Context;

void nr_fft2(real[],    unsigned long, int);
void   offt2(real[],    unsigned long, int);
void    fft2(real[],    unsigned long, int);

FFT_Context init_nfft2 (unsigned long, int);
FFT_Context init_mfft2 (unsigned long, int);
void   nfft2(complex[], FFT_Context);
void   mfft2(complex[], FFT_Context);

#endif
