/* Driver for routine fourn */

#include <stdio.h>
#include <stdlib.h>
#include <sys/times.h>
#include "complex.h"

#define NDAT  8
#define XFFT2 nfft2
#define INIT  init_nfft2

#include "fft.h"

complex crand48_m1_p1(void)
{
  return (2*drand48()-1) + (2*drand48()-1)*1i;
}

int main(void)
{
  unsigned long i;
  complex data1[NDAT*NDAT], data2[NDAT*NDAT];
  complex data3[NDAT*NDAT], data4[NDAT*NDAT];
  FFT_Context nor_fft, inv_fft;
  struct tms start, stop;
  long Ton, Tnn, Toi, Tni, Son, Snn, Soi, Sni;

  /* Initialize the arrays to a sequence which will always be the same. */
  srand48(-23);
  for (i=0; i < NDAT*NDAT; i++)
    data1[i] = data2[i] = data3[i] = data4[i] = crand48_m1_p1();

  /* nfft2 requires initialization before first call */
  nor_fft = INIT(NDAT, 1);
  inv_fft = INIT(NDAT, -1);

  /* Perform a single FFT on each array, using different algorithms. */

  times(&start);
  fft2 ((real*) data1,    NDAT, 1);	/* normal */
  times(&stop);
  Ton = stop.tms_utime - start.tms_utime;
  Son = stop.tms_stime - start.tms_stime;
  times(&start);
  XFFT2((complex*) data2, nor_fft);	/* normal */
  times(&stop);
  Tnn = stop.tms_utime - start.tms_utime;
  Snn = stop.tms_stime - start.tms_stime;
  times(&start);
  fft2 ((real*) data3,    NDAT, -1);	/* inverse */
  times(&stop);
  Toi = stop.tms_utime - start.tms_utime;
  Soi = stop.tms_stime - start.tms_stime;
  times(&start);
  XFFT2((complex*) data4, inv_fft);	/* inverse */
  times(&stop);
  Tni = stop.tms_utime - start.tms_utime;
  Sni = stop.tms_stime - start.tms_stime;

  fprintf(stderr, "TIME(ticks) old %ld(%ld)/%ld(%ld)  new %ld(%ld)/%ld(%ld)\n",
	  Ton,Son, Toi,Soi, Tnn,Snn, Tni,Sni);

  /* Spew results. */

  printf("Comparison of 2-dimensional transforms (normal):\n\n");
  printf("%9s %9s %9.2s %9.2s %16s %14s\n",
	 "Re_1", "Im_1", "Re_2", "Im_2", "delta Re", "delta Im");
  for (i=0; i < NDAT*NDAT; i++)
    printf("%9.2" LFMT "f %9.2" LFMT "f %9.2" LFMT "f %9.2" LFMT "f"
	   " %16.10f %14.10f\n",
	   Re(data1[i]), Im(data1[i]), Re(data2[i]), Im(data2[i]),
	   fabs(Re(data2[i]-data1[i])), fabs(Im(data2[i]-data1[i])));

  printf("\nComparison of 2-dimensional transforms (inverse):\n\n");
  printf("%9s %9s %9.2s %9.2s %16s %14s\n",
	 "Re_3", "Im_3", "Re_4", "Im_4", "delta Re", "delta Im");
  for (i=0; i < NDAT*NDAT; i++)
    printf("%9.2" LFMT "f %9.2" LFMT "f %9.2" LFMT "f %9.2" LFMT "f"
	   " %16.10f %14.10f\n",
	   Re(data3[i]), Im(data3[i]), Re(data4[i]), Im(data4[i]),
	   fabs(Re(data4[i]-data3[i])), fabs(Im(data4[i]-data3[i])));

  return 0;
}

