#!/afs/athena/contrib/perl5/perl -w

use strict;

my (@flag, %flag);
sub flag { /^-/ || return 0; push(@flag, map(($_,1), split(//, $'))); 1; }
@ARGV = grep(!flag(), @ARGV);
%flag = @flag;

my (@lines);
LINE:
  while (<>) {
    /^>>/ && do { process(@lines) if @lines;   @lines=();   next LINE };
    /^TIME/ && next LINE;
    chomp;
    push(@lines, $_);
  }

sub process {
  my (@lines) = @_;
  my (@data) = map([split /\s+/], @lines);

  my (@blocks) = map($_->[2], @data);
  print STDERR "Non-uniform blocks: @blocks\n"
    if scalar grep($_ != $blocks[0], @blocks);
  print "BLK: $blocks[0]\n";

  my (%fmap) = map(($_->[0], $_->[1]), @data);
  my (%rmap) = map(($_->[1], $_->[0]), @data);
  my $i;
  if ($flag{'r'}) {
    for $i (sort {$a<=>$b} keys %rmap) { print "$i<-$rmap{$i} "; }  print "\n";
  } else {
    for $i (sort {$a<=>$b} keys %fmap) { print "$i->$fmap{$i} "; }  print "\n";
  }
}
