/* Driver for routine fourn */

#include <stdio.h>
#include "complex.h"

#define NDIM 2
#define NDAT  128
#define NDAT2 2*NDAT*NDAT

#ifdef FFT_NAME
#define fft2 FFT_NAME
#endif

void fft2(real[], unsigned long, int);
float ran1(long *idum);

int main(void)
{
  int isign;
  long idum=(-23);
  unsigned long i,j,k,l,ndum=2,nn[NDIM];
  real data1[NDAT2],data2[NDAT2];

/*  for (i=1;i<=NDIM;i++) nn[i-1]=(ndum <<= 1); */
  for (i=1;i<=NDIM;i++) nn[i-1]=NDAT;

  for (j=1;j<=nn[1];j++)
    for (k=1;k<=nn[0];k++) {
      l=k+(j-1)*nn[0];
      l=(l<<1)-1;
      /* real part of component */
      data2[l-1]=data1[l-1]=2*ran1(&idum)-1;
      /* imaginary part of component */
      l++;
      data2[l-1]=data1[l-1]=2*ran1(&idum)-1;
    }
  isign=1;
  fft2(data2,nn[0],isign);
  /* here would be any processing to be done in Fourier space */
  isign = -1;
  fft2(data2,nn[0],isign);
  printf("Double 2-dimensional transform\n\n");
  printf("%19s %18s %18s\n",
	 "Double transf.","Original data","Ratio skew");
  printf("%9s %9s %9s %9s %12s %17s\n\n",
	 "real","imag.","real","imag.","real","imag.");
  ndum=nn[0]*nn[1];
  for (j=1;j<=nn[1];j++)
    for (k=1;k<=nn[0];k++) {
      l=k+(j-1)*nn[0];
      l=(l<<1)-1;
      printf("%9.2" LFMT "f %9.2" LFMT "f %9.2" LFMT "f %9.2" LFMT "f"
	     "%17.10" LFMT "e %17.10" LFMT "e\n",
	     data2[l-1],data2[l],data1[l-1],data1[l],
	     (data2[l-1]/data1[l-1])-ndum,
	     (data2[l]/data1[l])-ndum);
    }
  printf("\nThe product of transform lengths is: %4lu\n",ndum);
  return 0;
}
