/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scaladoc;

import ch.epfl.lamp.util.Pair;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import scala.tools.scalac.ast.parser.Parser$class;
import scala.tools.scaladoc.SymbolBooleanFunction;
import scala.tools.util.SourceFile;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Name;
import scalac.util.NameTransformer;

public class ScalaSearch {
    public static Comparator symAlphaOrder = new 4();
    public static Comparator symPathOrder = new 5();
    public static int queryCounter = 0;

    static boolean isContainer(Symbol symbol) {
        return symbol.isClass() || symbol.isModule() || symbol.isPackage() || symbol.isPackageClass();
    }

    static boolean isLazy(Symbol symbol) {
        return symbol.rawInfo() instanceof Type.LazyType || symbol.rawInfo() instanceof Type.TypeRef && symbol.rawInfo().symbol().rawInfo() instanceof Type.LazyType;
    }

    static boolean isPrivate(Symbol symbol) {
        return (symbol.flags & 4) != 0;
    }

    public static boolean isGenerated(Symbol symbol) {
        return symbol.isSynthetic() && !symbol.isRoot() || symbol.name.indexOf('$') >= 0 && NameTransformer.decode(symbol.name).equals(symbol.name.toString()) || NameTransformer.decode(symbol.name).endsWith("_=");
    }

    public static boolean isEmptyJavaModule(Symbol symbol) {
        return symbol.isModule() && symbol.isJava() && !symbol.isPackage() && !symbol.isPackageClass() && ScalaSearch.members(symbol).length == 0;
    }

    public static boolean isValMethod(Symbol symbol) {
        return symbol.isInitializedMethod() && (symbol.flags & 0x800000) != 0;
    }

    public static boolean isPhantom(Symbol symbol) {
        return symbol.isClass() && symbol.info().isError() || symbol.isModule() && symbol.info() == Type.NoType;
    }

    public static boolean isRelevant(Symbol symbol) {
        return !ScalaSearch.isGenerated(symbol) && !ScalaSearch.isLazy(symbol) && !ScalaSearch.isPrivate(symbol) && !symbol.isConstructor() && !symbol.isCaseFactory() && !ScalaSearch.isEmptyJavaModule(symbol) && !ScalaSearch.isPhantom(symbol);
    }

    public static void foreach(Symbol symbol, SymFun symFun) {
        if (ScalaSearch.isRelevant(symbol)) {
            symFun.apply(symbol);
            Symbol[] symbolArray = ScalaSearch.members(symbol);
            for (int i = 0; i < symbolArray.length; ++i) {
                ScalaSearch.foreach(symbolArray[i], symFun);
            }
        }
    }

    public static Symbol[] members(Symbol symbol) {
        if (ScalaSearch.isContainer(symbol) && !ScalaSearch.isLazy(symbol)) {
            LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
            LazySymbolIterator lazySymbolIterator = new LazySymbolIterator(symbol.members());
            while (((Scope.SymbolIterator)lazySymbolIterator).hasNext()) {
                Symbol symbol2 = ((Scope.SymbolIterator)lazySymbolIterator).next();
                if (!ScalaSearch.isRelevant(symbol2)) continue;
                linkedList.add(symbol2);
            }
            return linkedList.toArray(new Symbol[linkedList.size()]);
        }
        return new Symbol[0];
    }

    public static void foreach(Symbol symbol, SymFun symFun, SymbolBooleanFunction symbolBooleanFunction) {
        if (symbolBooleanFunction.apply(symbol) && ScalaSearch.isRelevant(symbol)) {
            symFun.apply(symbol);
            Symbol[] symbolArray = ScalaSearch.members(symbol, symbolBooleanFunction);
            for (int i = 0; i < symbolArray.length; ++i) {
                ScalaSearch.foreach(symbolArray[i], symFun, symbolBooleanFunction);
            }
        }
    }

    public static Symbol[] members(Symbol symbol, SymbolBooleanFunction symbolBooleanFunction) {
        if (ScalaSearch.isContainer(symbol) && !ScalaSearch.isLazy(symbol)) {
            LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
            LazySymbolIterator lazySymbolIterator = new LazySymbolIterator(symbol.members());
            while (((Scope.SymbolIterator)lazySymbolIterator).hasNext()) {
                Symbol symbol2 = ((Scope.SymbolIterator)lazySymbolIterator).next();
                if (!symbolBooleanFunction.apply(symbol2) || !ScalaSearch.isRelevant(symbol)) continue;
                linkedList.add(symbol2);
            }
            return linkedList.toArray(new Symbol[linkedList.size()]);
        }
        return new Symbol[0];
    }

    public static Symbol[] getSortedPackageList(Symbol symbol, SymbolBooleanFunction symbolBooleanFunction) {
        LinkedList linkedList = new LinkedList();
        ScalaSearch.foreach(symbol, new 6(linkedList), symbolBooleanFunction);
        Symbol[] symbolArray = linkedList.toArray(new Symbol[linkedList.size()]);
        Arrays.sort(symbolArray, symPathOrder);
        return symbolArray;
    }

    public static Symbol[][] getSubContainerMembers(Symbol symbol, SymbolBooleanFunction symbolBooleanFunction) {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = new LinkedList();
        ScalaSearch.foreach(symbol, new 7(linkedList2, linkedList3, linkedList), symbolBooleanFunction);
        Symbol[] symbolArray = linkedList.toArray(new Symbol[linkedList.size()]);
        Symbol[] symbolArray2 = linkedList2.toArray(new Symbol[linkedList2.size()]);
        Symbol[] symbolArray3 = linkedList3.toArray(new Symbol[linkedList3.size()]);
        Arrays.sort(symbolArray, symAlphaOrder);
        Arrays.sort(symbolArray2, symAlphaOrder);
        Arrays.sort(symbolArray3, symAlphaOrder);
        return new Symbol[][]{symbolArray, symbolArray2, symbolArray3};
    }

    public static Symbol[][] splitMembers(Symbol[] symbolArray) {
        LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
        LinkedList<Symbol> linkedList2 = new LinkedList<Symbol>();
        LinkedList<Symbol> linkedList3 = new LinkedList<Symbol>();
        LinkedList<Symbol> linkedList4 = new LinkedList<Symbol>();
        LinkedList<Symbol> linkedList5 = new LinkedList<Symbol>();
        LinkedList<Symbol> linkedList6 = new LinkedList<Symbol>();
        for (int i = 0; i < symbolArray.length; ++i) {
            Symbol symbol = symbolArray[i];
            if (symbol.isTrait()) {
                linkedList4.add(symbol);
                continue;
            }
            if (symbol.isClass()) {
                linkedList5.add(symbol);
                continue;
            }
            if (symbol.isPackage() || symbol.isPackageClass()) {
                linkedList6.add(symbol);
                continue;
            }
            if (symbol.isModule()) {
                linkedList3.add(symbol);
                continue;
            }
            if (symbol.isMethod() && !ScalaSearch.isValMethod(symbol)) {
                linkedList2.add(symbol);
                continue;
            }
            linkedList.add(symbol);
        }
        return new Symbol[][]{linkedList.toArray(new Symbol[linkedList.size()]), linkedList2.toArray(new Symbol[linkedList2.size()]), linkedList3.toArray(new Symbol[linkedList3.size()]), linkedList4.toArray(new Symbol[linkedList4.size()]), linkedList5.toArray(new Symbol[linkedList5.size()]), linkedList6.toArray(new Symbol[linkedList6.size()])};
    }

    public static void categorizeSymbols(List list, List list2, List list3, List list4) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (symbol.isPackage() || symbol.isPackageClass() || symbol.isModule()) {
                list3.add(symbol);
                continue;
            }
            if (symbol.isTerm()) {
                list2.add(symbol);
                continue;
            }
            list4.add(symbol);
        }
    }

    public static Symbol[] sortList(List list) {
        Symbol[] symbolArray = list.toArray(new Symbol[list.size()]);
        Arrays.sort(symbolArray, symAlphaOrder);
        return symbolArray;
    }

    public static Map subTemplates(Symbol symbol, SymbolBooleanFunction symbolBooleanFunction) {
        HashMap hashMap = new HashMap();
        ScalaSearch.foreach(symbol, new 8(hashMap), symbolBooleanFunction);
        return hashMap;
    }

    public static Pair index(Symbol symbol, SymbolBooleanFunction symbolBooleanFunction) {
        HashMap<Object, Symbol[]> hashMap = new HashMap<Object, Symbol[]>();
        ScalaSearch.foreach(symbol, new 9(hashMap), symbolBooleanFunction);
        Object[] objectArray = hashMap.keySet().toArray(new Character[hashMap.keySet().size()]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            List list = (List)hashMap.get(object);
            Symbol[] symbolArray = list.toArray(new Symbol[list.size()]);
            Arrays.sort(symbolArray, symAlphaOrder);
            hashMap.put(object, symbolArray);
        }
        return new Pair(objectArray, hashMap);
    }

    public static Symbol[] collectMembers(Symbol symbol) {
        Object object;
        Type type = symbol.thisType();
        Name[] nameArray = ScalaSearch.collectNames(type);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < nameArray.length; ++i) {
            object = type.lookup(nameArray[i]);
            if (object == Symbol.NONE) continue;
            linkedList.add(object);
        }
        object = new LinkedList();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Symbol[] symbolArray = ((Symbol)iterator.next()).alternativeSymbols();
            for (int i = 0; i < symbolArray.length; ++i) {
                if (!ScalaSearch.isRelevant(symbolArray[i])) continue;
                object.add(symbolArray[i]);
            }
        }
        return object.toArray(new Symbol[object.size()]);
    }

    protected static Name[] collectNames(Type type) {
        LinkedList linkedList = new LinkedList();
        ScalaSearch.collectNames(type, linkedList);
        return linkedList.toArray(new Name[linkedList.size()]);
    }

    protected static void collectNames(Type type, List list) {
        Object object;
        LazySymbolIterator lazySymbolIterator = new LazySymbolIterator(type.members());
        while (((Scope.SymbolIterator)lazySymbolIterator).hasNext()) {
            object = ((Scope.SymbolIterator)lazySymbolIterator).next().name;
            if (list.contains(object)) continue;
            list.add(object);
        }
        object = type.parents();
        for (int i = 0; i < ((Type[])object).length; ++i) {
            ScalaSearch.collectNames(object[i], list);
        }
    }

    public static Pair groupSymbols(Symbol[] symbolArray) {
        Object object;
        HashMap<Symbol, Symbol[]> hashMap = new HashMap<Symbol, Symbol[]>();
        for (int i = 0; i < symbolArray.length; ++i) {
            object = (Symbol[])hashMap.get(symbolArray[i].owner());
            if (object == null) {
                object = new LinkedList();
                hashMap.put(symbolArray[i].owner(), (Symbol[])object);
            }
            object.add(symbolArray[i]);
        }
        object = hashMap.keySet().toArray(new Symbol[hashMap.keySet().size()]);
        Arrays.sort(object, symPathOrder);
        for (int i = 0; i < ((Symbol[])object).length; ++i) {
            List list = (List)hashMap.get(object[i]);
            Symbol[] symbolArray2 = list.toArray(new Symbol[list.size()]);
            Arrays.sort(symbolArray2, symAlphaOrder);
            hashMap.put(object[i], symbolArray2);
        }
        return new Pair(object, hashMap);
    }

    public static Symbol overridenBySymbol(Symbol symbol) {
        Symbol symbol2 = symbol.owner();
        if (symbol2.isRoot() || symbol2.isPackageClass()) {
            return Symbol.NONE;
        }
        Type.CompoundType compoundType = Type.compoundTypeWithOwner(symbol2, symbol.owner().info().parents(), Scope.EMPTY);
        return symbol.overriddenSymbol(compoundType);
    }

    public static Type typeOfString(String string, Global global) {
        int n = global.reporter.errors();
        String string2 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("trait tmp$".concat(String.valueOf(queryCounter)))).concat(" extends Option[unit] { def f"))).concat(String.valueOf(String.valueOf(string))))).concat("; }");
        ++queryCounter;
        SourceFile sourceFile = global.getSourceFile("tmp.scala", string2);
        CompilationUnit compilationUnit = new CompilationUnit(global, sourceFile, false);
        compilationUnit.body = new Parser$class(compilationUnit).parse();
        global.PHASE.NAMER.phase().apply(compilationUnit);
        global.PHASE.ANALYZER.phase().apply(compilationUnit);
        if (global.reporter.errors() == n) {
            Scope scope = compilationUnit.body[0].symbol().members();
            Type type = scope.lookup(Name.fromString("f")).type();
            return type;
        }
        return Type.NoType;
    }

    static class 5
    implements Comparator {
        private static final /* synthetic */ boolean $assertionsDisabled;

        public int compare(Object object, Object object2) {
            int n = this.compare0(object, object2);
            return n;
        }

        public int compare0(Object object, Object object2) {
            LinkedList linkedList = this.getOwners((Symbol)object);
            LinkedList linkedList2 = this.getOwners((Symbol)object2);
            int n = 0;
            while (n != linkedList.size() && n != linkedList2.size()) {
                Symbol symbol;
                Symbol symbol2 = (Symbol)linkedList.get(n);
                if (symbol2 != (symbol = (Symbol)linkedList2.get(n))) {
                    int n2 = symbol2.nameString().compareTo(symbol.nameString());
                    if (n2 != 0) {
                        return n2;
                    }
                    if (symbol2.isTerm() && symbol.isType()) {
                        return -1;
                    }
                    if (symbol2.isType() && symbol.isTerm()) {
                        return 1;
                    }
                    return symbol2.id - symbol.id;
                }
                ++n;
            }
            return linkedList.size() - linkedList2.size();
        }

        public boolean equals(Object object) {
            return false;
        }

        public LinkedList getOwners(Symbol symbol) {
            LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
            while (true) {
                if (!$assertionsDisabled && (symbol.isNone() || symbol.isError())) {
                    throw new AssertionError();
                }
                linkedList.addFirst(symbol);
                if (symbol.isRoot() || symbol.isNone() || symbol.isError()) break;
                symbol = symbol.owner();
            }
            return linkedList;
        }

        5() {
        }

        static {
            $assertionsDisabled = !Class.forName("scala.tools.scaladoc.ScalaSearch").desiredAssertionStatus();
        }
    }

    static class 4
    implements Comparator {
        public int compare(Object object, Object object2) {
            Symbol symbol = (Symbol)object;
            Symbol symbol2 = (Symbol)object2;
            String string = symbol.nameString();
            String string2 = symbol2.nameString();
            return string.compareTo(string2);
        }

        public boolean equals(Object object) {
            return false;
        }

        4() {
        }
    }

    static class 9
    extends SymFun {
        final /* synthetic */ Map val$index;

        public void apply(Symbol symbol) {
            String string = symbol.nameString();
            if (string.length() > 0) {
                char c = Character.toUpperCase(string.charAt(0));
                Character c2 = new Character(c);
                LinkedList<Symbol> linkedList = (LinkedList<Symbol>)this.val$index.get(c2);
                if (linkedList == null) {
                    linkedList = new LinkedList<Symbol>();
                    this.val$index.put(c2, linkedList);
                }
                linkedList.add(symbol);
            }
        }

        9(Map map) {
            this.val$index = map;
        }
    }

    static class 8
    extends SymFun {
        final /* synthetic */ Map val$subs;

        public void apply(Symbol symbol) {
            if (symbol.isClass() || symbol.isModule()) {
                Type[] typeArray = (symbol.isModule() ? symbol.moduleClass() : symbol).parents();
                for (int i = 0; i < typeArray.length; ++i) {
                    Symbol symbol2 = typeArray[i].symbol();
                    LinkedList<Pair> linkedList = (LinkedList<Pair>)this.val$subs.get(symbol2);
                    if (linkedList == null) {
                        linkedList = new LinkedList<Pair>();
                        this.val$subs.put(symbol2, linkedList);
                    }
                    linkedList.add(new Pair(symbol, typeArray[i]));
                }
            }
        }

        8(Map map) {
            this.val$subs = map;
        }
    }

    static class 7
    extends SymFun {
        final /* synthetic */ List val$traitsAcc;
        final /* synthetic */ List val$classesAcc;
        final /* synthetic */ List val$objectsAcc;

        public void apply(Symbol symbol) {
            if (symbol.isTrait() && !symbol.isModuleClass()) {
                this.val$traitsAcc.add(symbol);
            } else if (symbol.isClass() && !symbol.isModuleClass()) {
                this.val$classesAcc.add(symbol);
            } else if (symbol.isModule() && !symbol.isPackage() && !symbol.isPackageClass()) {
                this.val$objectsAcc.add(symbol);
            }
        }

        7(List list, List list2, List list3) {
            this.val$traitsAcc = list;
            this.val$classesAcc = list2;
            this.val$objectsAcc = list3;
        }
    }

    static class 6
    extends SymFun {
        final /* synthetic */ List val$packagesAcc;

        public void apply(Symbol symbol) {
            if (symbol.isPackage() || symbol.isPackageClass()) {
                this.val$packagesAcc.add(symbol);
            }
        }

        6(List list) {
            this.val$packagesAcc = list;
        }
    }

    static class LazySymbolIterator
    extends Scope.SymbolIterator {
        private Symbol[] alternatives = Symbol.EMPTY_ARRAY;
        private int altindex = 0;
        private int elemindex = 0;
        private Scope scope;

        public LazySymbolIterator(Scope scope) {
            this.scope = scope;
            scope.elements();
        }

        public boolean hasNext() {
            return this.altindex < this.alternatives.length || this.elemindex < this.scope.getElemsCache().length;
        }

        public Symbol next() {
            if (this.altindex < this.alternatives.length) {
                return this.alternatives[this.altindex++];
            }
            Symbol symbol = this.scope.getElemsCache()[this.elemindex++];
            if (ScalaSearch.isLazy(symbol)) {
                return symbol;
            }
            Type type = symbol.type();
            if (type.$tag == 4) {
                Type.OverloadedType overloadedType = (Type.OverloadedType)type;
                Symbol[] symbolArray = overloadedType.alts;
                this.alternatives = symbolArray;
                this.altindex = 0;
                return this.next();
            }
            return symbol;
        }
    }

    public static abstract class SymFun {
        public abstract void apply(Symbol var1);
    }
}

