/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalai;

import java.util.ArrayList;
import scala.tools.scalai.Code;
import scala.tools.scalai.CodeBuffer;
import scala.tools.scalai.CodeContainer;
import scala.tools.scalai.Constants;
import scala.tools.scalai.ExpressionContext;
import scala.tools.scalai.Function;
import scala.tools.scalai.ScalaTemplate;
import scala.tools.scalai.Template;
import scala.tools.scalai.Variable;
import scala.tools.util.debug.Debug;
import scalac.ast.Tree;
import scalac.atree.AConstant;
import scalac.backend.Primitives;
import scalac.symtab.Definitions;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Name;

public class ExpressionCompiler {
    private final Definitions definitions;
    private final Primitives primitives;
    private final Constants constants;
    private final ExpressionContext context;
    private static final Name plus_N;
    private static final Name minus_N;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public ExpressionCompiler(Definitions definitions, Primitives primitives, Constants constants, ExpressionContext expressionContext, Symbol[] symbolArray) {
        this.definitions = definitions;
        this.primitives = primitives;
        this.constants = constants;
        this.context = expressionContext;
        for (int i = 0; i < symbolArray.length; ++i) {
            expressionContext.insertVariable(symbolArray[i], Variable.Argument(i));
        }
    }

    public CodeContainer compile(Tree tree) {
        Code code = this.compute(tree);
        return new CodeContainer(this.context.source(), this.context.owner(), code, this.context.stackmax());
    }

    public CodeContainer compile(ArrayList arrayList) {
        Code code;
        Code code2 = Code.Literal(this.constants.literal());
        CodeBuffer codeBuffer = new CodeBuffer();
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            if (n > 0) {
                codeBuffer.append(code2);
            }
            code = arrayList.get(n++);
            code2 = this.compute((Tree)((Object)code));
        }
        code = codeBuffer.code(code2);
        return new CodeContainer(this.context.source(), this.context.owner(), code, this.context.stackmax());
    }

    private void declare(Tree tree, CodeBuffer codeBuffer) {
        switch (tree.$tag) {
            case 42: {
                return;
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Tree tree2 = valDef.rhs;
                Symbol symbol = tree.symbol();
                Variable.Local local = Variable.Local(this.context.push());
                this.context.insertVariable(symbol, local);
                Code code = tree2 != Tree.Empty ? this.compute(tree2) : Code.Literal(this.constants.zero(symbol.type()));
                codeBuffer.append(Code.Store(Code.Self, local, code));
                return;
            }
        }
        codeBuffer.append(this.compute(tree));
    }

    private Code[] compute(Tree[] treeArray) {
        Code[] codeArray = new Code[treeArray.length];
        for (int i = 0; i < codeArray.length; ++i) {
            codeArray[i] = this.compute(treeArray[i]);
        }
        return codeArray;
    }

    private Code compute(Tree tree) {
        switch (tree.$tag) {
            case 20: {
                Tree.LabelDef labelDef = (Tree.LabelDef)tree;
                Tree.Ident[] identArray = labelDef.params;
                Tree tree2 = labelDef.rhs;
                Symbol symbol = tree.symbol();
                Variable[] variableArray = new Variable[identArray.length];
                for (int i = 0; i < identArray.length; ++i) {
                    variableArray[i] = this.context.lookupVariable(identArray[i].symbol());
                    if (!($assertionsDisabled || variableArray[i] instanceof Variable.Argument || variableArray[i] instanceof Variable.Local)) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(variableArray[i]))));
                    }
                }
                this.context.insertLabel(symbol);
                return Code.Label(symbol, variableArray, this.compute(tree2));
            }
            case 8: {
                Tree.Block block = (Tree.Block)tree;
                Tree[] treeArray = block.stats;
                Tree tree3 = block.expr;
                if (treeArray.length == 0) {
                    return this.compute(tree3);
                }
                CodeBuffer codeBuffer = new CodeBuffer();
                int n = this.context.stacksize();
                for (int i = 0; i < treeArray.length; ++i) {
                    this.declare(treeArray[i], codeBuffer);
                }
                Code code = this.compute(tree3);
                this.context.stacksize(n);
                return codeBuffer.code(code);
            }
            case 5: {
                Tree.Assign assign = (Tree.Assign)tree;
                Tree tree4 = assign.lhs;
                Tree tree5 = assign.rhs;
                return this.store(tree4, tree4.symbol(), this.compute(tree5));
            }
            case 18: {
                Tree.If if_ = (Tree.If)tree;
                Tree tree6 = if_.cond;
                Tree tree7 = if_.thenp;
                Tree tree8 = if_.elsep;
                return Code.If(this.compute(tree6), this.compute(tree7), tree8 == Tree.Empty ? Code.Literal(this.constants.literal()) : this.compute(tree8));
            }
            case 32: {
                Tree.Switch switch_ = (Tree.Switch)tree;
                Tree tree9 = switch_.test;
                int[] nArray = switch_.tags;
                Tree[] treeArray = switch_.bodies;
                Tree tree10 = switch_.otherwise;
                return Code.Switch(this.compute(tree9), nArray, this.compute(treeArray), this.compute(tree10));
            }
            case 23: {
                Tree.New new_ = (Tree.New)tree;
                Tree tree11 = new_.init;
                Template template = this.context.lookupTemplate(tree.getType().symbol());
                if (template.$tag == 0) {
                    Template.Global global = (Template.Global)template;
                    ScalaTemplate scalaTemplate = global.template;
                    Variable.Local local = Variable.Local(this.context.push());
                    Code.Create create = Code.Create(scalaTemplate);
                    Code.Store store = Code.Store(Code.Null, local, create);
                    Code.Load load = Code.Load(Code.Null, local);
                    Code code = this.compute(tree11);
                    if (code.$tag == 5) {
                        Code.Invoke invoke = (Code.Invoke)code;
                        if (invoke.target.$tag == 14) {
                            Function function = invoke.function;
                            Code[] codeArray = invoke.arguments;
                            int n = invoke.pos;
                            Code.Invoke invoke2 = Code.Invoke(load, function, codeArray, n);
                            return Code.Block(new Code[]{store, invoke2}, load);
                        }
                    }
                    throw Debug.abort("illegal case", code);
                }
                return this.compute(tree11);
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                if (apply.fun.$tag == 37) {
                    Tree.TypeApply typeApply = (Tree.TypeApply)apply.fun;
                    Tree tree12 = typeApply.fun;
                    Tree[] treeArray = typeApply.args;
                    Tree[] treeArray2 = apply.args;
                    return this.tapply(tree12, tree12.symbol(), treeArray, treeArray2);
                }
                Tree tree13 = apply.fun;
                Tree[] treeArray = apply.args;
                return this.vapply(tree13, tree13.symbol(), treeArray);
            }
            case 34: {
                return Code.Self;
            }
            case 21: {
                Tree.Literal literal = (Tree.Literal)tree;
                AConstant aConstant = literal.value;
                switch (aConstant.$tag) {
                    case 11: {
                        return Code.Literal(this.constants.literal());
                    }
                    case 0: {
                        AConstant.BOOLEAN bOOLEAN = (AConstant.BOOLEAN)aConstant;
                        boolean bl = bOOLEAN.value;
                        return Code.Literal(new Boolean(bl));
                    }
                    case 1: {
                        AConstant.BYTE bYTE = (AConstant.BYTE)aConstant;
                        byte by = bYTE.value;
                        return Code.Literal(new Byte(by));
                    }
                    case 7: {
                        AConstant.SHORT sHORT = (AConstant.SHORT)aConstant;
                        short s = sHORT.value;
                        return Code.Literal(new Short(s));
                    }
                    case 2: {
                        AConstant.CHAR cHAR = (AConstant.CHAR)aConstant;
                        char c = cHAR.value;
                        return Code.Literal(new Character(c));
                    }
                    case 5: {
                        AConstant.INT iNT = (AConstant.INT)aConstant;
                        int n = iNT.value;
                        return Code.Literal(new Integer(n));
                    }
                    case 6: {
                        AConstant.LONG lONG = (AConstant.LONG)aConstant;
                        long l = lONG.value;
                        return Code.Literal(new Long(l));
                    }
                    case 4: {
                        AConstant.FLOAT fLOAT = (AConstant.FLOAT)aConstant;
                        float f = fLOAT.value;
                        return Code.Literal(new Float(f));
                    }
                    case 3: {
                        AConstant.DOUBLE dOUBLE = (AConstant.DOUBLE)aConstant;
                        double d = dOUBLE.value;
                        return Code.Literal(new Double(d));
                    }
                    case 8: {
                        AConstant.STRING sTRING = (AConstant.STRING)aConstant;
                        String string = sTRING.value;
                        return Code.Literal(new String(string));
                    }
                    case 10: {
                        return Code.Null;
                    }
                }
                throw Debug.abort("illegal case", aConstant);
            }
        }
        return this.load(tree, tree.symbol());
    }

    private Code object(Tree tree) {
        switch (tree.$tag) {
            case 27: {
                Tree.Select select = (Tree.Select)tree;
                switch (select.qualifier.$tag) {
                    case 31: {
                        return Code.Self;
                    }
                    case 12: {
                        return Code.Null;
                    }
                }
                Tree tree2 = select.qualifier;
                return this.compute(tree2);
            }
            case 17: {
                return Code.Null;
            }
        }
        throw Debug.abort("illegal tree", tree);
    }

    private Code tapply(Tree tree, Symbol symbol, Tree[] treeArray, Tree[] treeArray2) {
        Code code = this.object(tree);
        if (symbol == this.definitions.ANY_IS_ERASED || symbol == this.definitions.ANY_AS_ERASED) {
            if (!$assertionsDisabled && treeArray.length != 1) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(treeArray))));
            }
            if (!$assertionsDisabled && treeArray2.length != 0) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(treeArray2))));
            }
            boolean bl = symbol == this.definitions.ANY_AS_ERASED;
            Type type = treeArray[0].type();
            return Code.IsAs(code, type, this.context.getClass(type), bl);
        }
        if (symbol == this.primitives.NEW_OARRAY) {
            if (!$assertionsDisabled && code != Code.Null) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(code)));
            }
            if (!$assertionsDisabled && treeArray.length != 1) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(treeArray))));
            }
            if (!$assertionsDisabled && treeArray2.length != 1) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(treeArray2))));
            }
            Type.UnboxedArrayType unboxedArrayType = Type.UnboxedArrayType(treeArray[0].type());
            Class<?> clazz = this.context.getClass(unboxedArrayType).getComponentType();
            return Code.CreateArray(clazz, this.compute(treeArray2[0]));
        }
        throw Debug.abort("unknown method", symbol);
    }

    private Code vapply(Tree tree, Symbol symbol, Tree[] treeArray) {
        Code[] codeArray;
        Code code = this.object(tree);
        if (symbol == this.definitions.BOOLEAN_OR()) {
            return Code.Or(code, this.compute(treeArray[0]));
        }
        if (symbol == this.definitions.BOOLEAN_AND()) {
            return Code.And(code, this.compute(treeArray[0]));
        }
        if (symbol == this.definitions.OBJECT_SYNCHRONIZED) {
            return Code.Synchronized(code, this.compute(treeArray[0]));
        }
        Function function = this.context.lookupFunction(symbol);
        if (treeArray.length == 0 && (symbol.name == plus_N || symbol.name == minus_N) && (symbol.owner().isSubClass(this.definitions.INT_CLASS) || symbol.owner().isSubClass(this.definitions.LONG_CLASS) || symbol.owner().isSubClass(this.definitions.FLOAT_CLASS) || symbol.owner().isSubClass(this.definitions.DOUBLE_CLASS))) {
            Function function2 = function = symbol.name == plus_N ? Function.Pos : Function.Neg;
        }
        if (tree.$tag == 27) {
            codeArray = (Code[])tree;
            if (codeArray.qualifier.$tag == 31) {
                Template template = this.context.lookupTemplate(symbol.owner());
                switch (template.$tag) {
                    case 0: {
                        Template.Global global = (Template.Global)template;
                        ScalaTemplate scalaTemplate = global.template;
                        function = Function.Global(scalaTemplate.getMethod(symbol));
                        break;
                    }
                    case 1: {
                        if (symbol.isInitializer()) break;
                        throw Debug.abort("!!! illegal super on java class", symbol);
                    }
                    default: {
                        throw Debug.abort("illegal template", template);
                    }
                }
            }
        }
        codeArray = this.compute(treeArray);
        return Code.Invoke(code, function, codeArray, tree.pos);
    }

    private Code load(Tree tree, Symbol symbol) {
        return Code.Load(this.object(tree), this.context.lookupVariable(symbol));
    }

    private Code store(Tree tree, Symbol symbol, Code code) {
        return Code.Store(this.object(tree), this.context.lookupVariable(symbol), code);
    }

    static {
        $assertionsDisabled = !Class.forName("scala.tools.scalai.ExpressionCompiler").desiredAssertionStatus();
        plus_N = Name.fromString("$plus");
        minus_N = Name.fromString("$minus");
    }
}

