/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalatest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.text.MessageFormat;

class Console {
    public static final String BLACK = "\u001b[30m";
    public static final String RED = "\u001b[31m";
    public static final String GREEN = "\u001b[32m";
    public static final String YELLOW = "\u001b[33m";
    public static final String BLUE = "\u001b[34m";
    public static final String MAGENTA = "\u001b[35m";
    public static final String CYAN = "\u001b[36m";
    public static final String WHITE = "\u001b[37m";
    public static final String COLOR38 = "\u001b[38m";
    public static final String COLOR39 = "\u001b[39m";
    public static final String BLACK_B = "\u001b[40m";
    public static final String RED_B = "\u001b[41m";
    public static final String GREEN_B = "\u001b[42m";
    public static final String YELLOW_B = "\u001b[43m";
    public static final String BLUE_B = "\u001b[44m";
    public static final String MAGENTA_B = "\u001b[45m";
    public static final String CYAN_B = "\u001b[46m";
    public static final String WHITE_B = "\u001b[47m";
    public static final String RESET = "\u001b[0m";
    public static final String BOLD = "\u001b[1m";
    public static final String UNDERLINED = "\u001b[4m";
    public static final String BLINK = "\u001b[5m";
    public static final String REVERSED = "\u001b[7m";
    public static final String INVISIBLE = "\u001b[8m";
    private PrintStream out = System.out;
    private BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

    public void setOut(PrintStream printStream) {
        this.out = printStream;
    }

    public void setIn(InputStream inputStream) {
        this.in = new BufferedReader(new InputStreamReader(inputStream));
    }

    public void setIn(Reader reader) {
        this.in = new BufferedReader(reader);
    }

    public void print(Object object) {
        this.out.print(object == null ? "null" : object.toString());
    }

    public void flush() {
        this.out.flush();
    }

    public void println() {
        this.out.println();
    }

    public void println(Object object) {
        this.out.println(object);
    }

    public void printf(String string, Object[] objectArray) {
        if (string == null) {
            this.out.print("null");
        } else {
            this.out.print(MessageFormat.format(string, objectArray));
        }
    }

    public String readLine() throws IOException {
        return this.in.readLine();
    }

    public boolean readBoolean() throws IOException {
        String string = this.in.readLine().toLowerCase();
        return "true".equals(string) || "t".equals(string) || "yes".equals(string) || "y".equals(string);
    }

    public byte readByte() throws IOException {
        return Byte.decode(this.in.readLine());
    }

    public short readShort() throws IOException {
        return Short.decode(this.in.readLine());
    }

    public char readChar() throws IOException {
        return this.in.readLine().charAt(0);
    }

    public int readInt() throws IOException {
        return Integer.decode(this.in.readLine());
    }

    public float readFloat() throws IOException {
        return Float.parseFloat(this.in.readLine());
    }

    public double readDouble() throws IOException {
        return Double.parseDouble(this.in.readLine());
    }
}

