/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalatest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import scala.tools.scalatest.Diff;
import scala.tools.scalatest.UnaryPredicate;

public class DiffPrint {
    static String[] slurp(String string) throws IOException {
        Object[] objectArray;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        Vector<Object[]> vector = new Vector<Object[]>();
        while ((objectArray = bufferedReader.readLine()) != null) {
            vector.addElement(objectArray);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void main(String[] stringArray) throws IOException {
        String string = stringArray[stringArray.length - 2];
        String string2 = stringArray[stringArray.length - 1];
        Object[] objectArray = DiffPrint.slurp(string);
        Object[] objectArray2 = DiffPrint.slurp(string2);
        Diff diff = new Diff(objectArray, objectArray2);
        int n = 110;
        for (int i = 0; i < stringArray.length - 2; ++i) {
            String string3 = stringArray[i];
            if (!string3.startsWith("-")) continue;
            block11: for (int j = 1; j < string3.length(); ++j) {
                switch (string3.charAt(j)) {
                    case 'e': {
                        n = 101;
                        continue block11;
                    }
                    case 'c': {
                        n = 99;
                        continue block11;
                    }
                    case 'u': {
                        n = 117;
                    }
                }
            }
        }
        boolean bl = n == 101;
        Diff.change change2 = diff.diff_2(bl);
        if (change2 == null) {
            System.err.println("No differences");
        } else {
            Base base;
            switch (n) {
                case 101: {
                    base = new EdPrint(objectArray, objectArray2);
                    break;
                }
                case 99: {
                    base = new ContextPrint(objectArray, objectArray2);
                    break;
                }
                case 117: {
                    base = new UnifiedPrint(objectArray, objectArray2);
                    break;
                }
                default: {
                    base = new NormalPrint(objectArray, objectArray2);
                }
            }
            base.print_header(string, string2);
            base.print_script(change2);
        }
    }

    public static class NormalPrint
    extends Base {
        public NormalPrint(Object[] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        protected void print_hunk(Diff.change change2) {
            this.analyze_hunk(change2);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.print_number_range(',', this.first0, this.last0);
            this.outfile.print(Base.change_letter(this.inserts, this.deletes));
            this.print_number_range(',', this.first1, this.last1);
            this.outfile.println();
            if (this.deletes != 0) {
                for (int i = this.first0; i <= this.last0; ++i) {
                    this.print_1_line("< ", this.file0[i]);
                }
            }
            if (this.inserts != 0 && this.deletes != 0) {
                this.outfile.println("---");
            }
            if (this.inserts != 0) {
                for (int i = this.first1; i <= this.last1; ++i) {
                    this.print_1_line("> ", this.file1[i]);
                }
            }
        }
    }

    public static class UnifiedPrint
    extends ContextPrint {
        public UnifiedPrint(Object[] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        public void print_header(String string, String string2) {
            this.print_context_label("---", new File(string), string);
            this.print_context_label("+++", new File(string2), string2);
        }

        private void print_number_range(int n, int n2) {
            if (n2 < n) {
                this.outfile.print(String.valueOf(n2).concat(",0"));
            } else {
                super.print_number_range(',', n, n2);
            }
        }

        protected void print_hunk(Diff.change change2) {
            this.analyze_hunk(change2);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.first0 = Math.max(this.first0 - this.context, 0);
            this.first1 = Math.max(this.first1 - this.context, 0);
            this.last0 = Math.min(this.last0 + this.context, this.file0.length - 1);
            this.last1 = Math.min(this.last1 + this.context, this.file1.length - 1);
            this.outfile.print("@@ -");
            this.print_number_range(this.first0, this.last0);
            this.outfile.print(" +");
            this.print_number_range(this.first1, this.last1);
            this.outfile.print(" @@");
            this.print_function(this.file0, this.first0);
            this.outfile.println();
            Diff.change change3 = change2;
            int n = this.first0;
            int n2 = this.first1;
            while (n <= this.last0 || n2 <= this.last1) {
                if (change3 == null || n < change3.line0) {
                    this.outfile.print(' ');
                    this.print_1_line("", this.file0[n++]);
                    ++n2;
                    continue;
                }
                int n3 = change3.deleted;
                while (n3-- > 0) {
                    this.outfile.print('-');
                    this.print_1_line("", this.file0[n++]);
                }
                n3 = change3.inserted;
                while (n3-- > 0) {
                    this.outfile.print('+');
                    this.print_1_line("", this.file1[n2++]);
                }
                change3 = change3.link;
            }
        }
    }

    public static class ContextPrint
    extends Base {
        protected int context = 3;

        public ContextPrint(Object[] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        protected void print_context_label(String string, File file, String string2) {
            if (string2 != null) {
                this.outfile.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat(String.valueOf(' ')))).concat(String.valueOf(String.valueOf(string2))));
            } else if (file.lastModified() > 0L) {
                this.outfile.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat(String.valueOf(' ')))).concat(String.valueOf(String.valueOf(file.getPath()))))).concat(String.valueOf('\t')))).concat(String.valueOf(String.valueOf(new Date(file.lastModified())))));
            } else {
                this.outfile.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat(String.valueOf(' ')))).concat(String.valueOf(String.valueOf(file.getPath()))));
            }
        }

        public void print_header(String string, String string2) {
            this.print_context_label("***", new File(string), string);
            this.print_context_label("---", new File(string2), string2);
        }

        private String find_function(Object[] objectArray, int n) {
            return null;
        }

        protected void print_function(Object[] objectArray, int n) {
            String string = this.find_function(this.file0, this.first0);
            if (string != null) {
                this.outfile.print(" ");
                this.outfile.print(string.length() < 40 ? string : string.substring(0, 40));
            }
        }

        protected void print_hunk(Diff.change change2) {
            String string;
            int n;
            Diff.change change3;
            this.analyze_hunk(change2);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.first0 = Math.max(this.first0 - this.context, 0);
            this.first1 = Math.max(this.first1 - this.context, 0);
            this.last0 = Math.min(this.last0 + this.context, this.file0.length - 1);
            this.last1 = Math.min(this.last1 + this.context, this.file1.length - 1);
            this.outfile.print("***************");
            this.print_function(this.file0, this.first0);
            this.outfile.println();
            this.outfile.print("*** ");
            this.print_number_range(',', this.first0, this.last0);
            this.outfile.println(" ****");
            if (this.deletes != 0) {
                change3 = change2;
                for (n = this.first0; n <= this.last0; ++n) {
                    while (change3 != null && change3.line0 + change3.deleted <= n) {
                        change3 = change3.link;
                    }
                    string = " ";
                    if (change3 != null && change3.line0 <= n) {
                        string = change3.inserted > 0 ? "!" : "-";
                    }
                    this.print_1_line(string, this.file0[n]);
                }
            }
            this.outfile.print("--- ");
            this.print_number_range(',', this.first1, this.last1);
            this.outfile.println(" ----");
            if (this.inserts != 0) {
                change3 = change2;
                for (n = this.first1; n <= this.last1; ++n) {
                    while (change3 != null && change3.line1 + change3.inserted <= n) {
                        change3 = change3.link;
                    }
                    string = " ";
                    if (change3 != null && change3.line1 <= n) {
                        string = change3.deleted > 0 ? "!" : "+";
                    }
                    this.print_1_line(string, this.file1[n]);
                }
            }
        }
    }

    public static class EdPrint
    extends Base {
        public EdPrint(Object[] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        protected void print_hunk(Diff.change change2) {
            this.analyze_hunk(change2);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.print_number_range(',', this.first0, this.last0);
            this.outfile.println(Base.change_letter(this.inserts, this.deletes));
            if (this.inserts != 0) {
                boolean bl = true;
                for (int i = this.first1; i <= this.last1; ++i) {
                    if (!bl) {
                        this.outfile.println(String.valueOf(i - this.first1 + this.first0).concat("a"));
                    }
                    bl = true;
                    if (".".equals(this.file1[i])) {
                        this.outfile.println("..");
                        this.outfile.println(".");
                        this.outfile.println(String.valueOf(i - this.first1 + this.first0 + 1).concat("s/^\\.\\././"));
                        bl = false;
                        continue;
                    }
                    this.print_1_line("", this.file1[i]);
                }
                if (bl) {
                    this.outfile.println(".");
                }
            }
        }
    }

    public static abstract class Base {
        protected UnaryPredicate ignore = null;
        protected Object[] file0;
        protected Object[] file1;
        protected int first0;
        protected int last0;
        protected int first1;
        protected int last1;
        protected int deletes;
        protected int inserts;
        protected PrintWriter outfile = new PrintWriter(new OutputStreamWriter(System.out));

        protected Base(Object[] objectArray, Object[] objectArray2) {
            this.file0 = objectArray;
            this.file1 = objectArray2;
        }

        public void print_script(Diff.change change2) {
            Diff.change change3 = change2;
            while (change3 != null) {
                Diff.change change4 = change3;
                Diff.change change5 = this.hunkfun(change3);
                change3 = change5.link;
                change5.link = null;
                this.print_hunk(change4);
                change5.link = change3;
            }
            this.outfile.flush();
        }

        protected Diff.change hunkfun(Diff.change change2) {
            return change2;
        }

        protected void analyze_hunk(Diff.change change2) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            boolean bl = this.ignore == null;
            n4 = 0;
            n3 = 0;
            int n5 = change2.line0;
            int n6 = change2.line1;
            Diff.change change3 = change2;
            while (change3 != null) {
                int n7;
                n = change3.line0 + change3.deleted - 1;
                n2 = change3.line1 + change3.inserted - 1;
                n3 += change3.deleted;
                n4 += change3.inserted;
                for (n7 = change3.line0; n7 <= n && !bl; ++n7) {
                    if (this.ignore.execute(this.file0[n7])) continue;
                    bl = true;
                }
                for (n7 = change3.line1; n7 <= n2 && !bl; ++n7) {
                    if (this.ignore.execute(this.file1[n7])) continue;
                    bl = true;
                }
                change3 = change3.link;
            }
            this.first0 = n5;
            this.last0 = n;
            this.first1 = n6;
            this.last1 = n2;
            if (!bl) {
                n4 = 0;
                n3 = 0;
            }
            this.deletes = n3;
            this.inserts = n4;
        }

        protected void print_header(String string, String string2) {
        }

        protected abstract void print_hunk(Diff.change var1);

        protected void print_1_line(String string, Object object) {
            this.outfile.println(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(object.toString()))));
        }

        protected void print_number_range(char c, int n, int n2) {
            if (++n2 > ++n) {
                this.outfile.print(String.valueOf(String.valueOf(String.valueOf(String.valueOf("".concat(String.valueOf(n)))).concat(String.valueOf(c)))).concat(String.valueOf(n2)));
            } else {
                this.outfile.print(n2);
            }
        }

        public static char change_letter(int n, int n2) {
            if (n == 0) {
                return 'd';
            }
            if (n2 == 0) {
                return 'a';
            }
            return 'c';
        }
    }
}

