/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import scala.tools.util.AbstractFile;
import scala.tools.util.CharArrayFile;
import scala.tools.util.Position;

public class SourceFile {
    public static final char LF = '\n';
    public static final char FF = '\f';
    public static final char CR = '\r';
    public static final char SU = '\u001a';
    private final AbstractFile file;
    private final char[] content;
    private int lineNumber = 0;
    private int lineStart = 0;
    private int lineLength = 0;
    private int nextIndex = 0;

    public SourceFile(String string, char[] cArray) {
        this(new CharArrayFile(string, cArray), cArray);
    }

    public SourceFile(AbstractFile abstractFile, char[] cArray) {
        this.file = abstractFile;
        this.content = SourceFile.normalize(cArray);
    }

    public AbstractFile getFile() {
        return this.file;
    }

    public char[] getContent() {
        return this.content;
    }

    public Position getPosition(int n, int n2) {
        return new Position(this, n, n2);
    }

    public String getLine(int n) {
        int n2;
        int n3 = n2 = this.lineNumber <= n ? this.nextIndex : (this.lineNumber = 0);
        while (n2 < this.content.length && this.lineNumber < n) {
            this.lineStart = n2;
            while (n2 < this.content.length && this.content[n2] != '\r' && this.content[n2] != '\n' && this.content[n2] != '\f') {
                ++n2;
            }
            this.lineLength = n2 - this.lineStart;
            if (n2 < this.content.length) {
                ++n2;
            }
            if (n2 < this.content.length && this.content[n2 - 1] == '\r' && this.content[n2] == '\n') {
                ++n2;
            }
            ++this.lineNumber;
        }
        this.nextIndex = n2;
        return new String(this.content, this.lineStart, this.lineLength);
    }

    public String toString() {
        return this.file.toString();
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof SourceFile && this.file.equals(((SourceFile)object).file);
    }

    private static char[] normalize(char[] cArray) {
        if (cArray.length > 0 && cArray[cArray.length - 1] == '\u001a') {
            return cArray;
        }
        char[] cArray2 = new char[cArray.length + 1];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        cArray2[cArray.length] = 26;
        return cArray2;
    }
}

