/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.tools.util.AbstractFile;
import scala.tools.util.PlainFile;
import scala.tools.util.VirtualFile;

public final class ZipArchive
extends PlainFile {
    private final ZipFile archive;
    private DirEntry root;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public static AbstractFile fromPath(String string) {
        return ZipArchive.fromFile(new File(string));
    }

    public static AbstractFile fromFile(File file) {
        try {
            return new ZipArchive(file, new ZipFile(file));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static AbstractFile fromArchive(ZipFile zipFile) {
        return new ZipArchive(new File(zipFile.getName()), zipFile);
    }

    protected ZipArchive(File file, ZipFile zipFile) {
        super(file);
        this.archive = zipFile;
        if (!$assertionsDisabled && zipFile == null) {
            throw new AssertionError();
        }
    }

    public boolean isDirectory() {
        return true;
    }

    public Iterator list() {
        if (this.root == null) {
            this.load();
        }
        return this.root.list();
    }

    public AbstractFile lookupName(String string, boolean bl) {
        if (this.root == null) {
            this.load();
        }
        return this.root.lookupName(string, bl);
    }

    private void load() {
        this.root = new DirEntry("<root>", "/");
        HashMap<String, DirEntry> hashMap = new HashMap<String, DirEntry>();
        hashMap.put("/", this.root);
        Enumeration<? extends ZipEntry> enumeration = this.archive.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (!$assertionsDisabled && zipEntry.isDirectory() != string.endsWith("/")) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this)).concat("-"))).concat(String.valueOf(String.valueOf(string))))));
            }
            if (zipEntry.isDirectory()) {
                DirEntry dirEntry = this.getDir(hashMap, string);
                if (!$assertionsDisabled && dirEntry.entry != null) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this)).concat(" - "))).concat(String.valueOf(String.valueOf(string))))));
                }
                dirEntry.entry = zipEntry;
                continue;
            }
            int n = string.lastIndexOf(47);
            String string2 = n < 0 ? string : string.substring(n + 1);
            String string3 = n < 0 ? "/" : string.substring(0, n + 1);
            DirEntry dirEntry = this.getDir(hashMap, string3);
            if (!$assertionsDisabled && dirEntry.entries.containsKey(string)) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this)).concat(" - "))).concat(String.valueOf(String.valueOf(string))))));
            }
            dirEntry.entries.put(string2, new FileEntry(string2, string, zipEntry));
        }
    }

    private DirEntry getDir(HashMap hashMap, String string) {
        DirEntry dirEntry = (DirEntry)hashMap.get(string);
        if (dirEntry == null) {
            int n = string.lastIndexOf(47, string.length() - 2);
            String string2 = n < 0 ? string : string.substring(n + 1);
            String string3 = n < 0 ? "/" : string.substring(0, n + 1);
            DirEntry dirEntry2 = this.getDir(hashMap, string3);
            dirEntry = new DirEntry(string2.substring(0, string2.length() - 1), string);
            dirEntry2.entries.put(string2, dirEntry);
            hashMap.put(string, dirEntry);
        }
        return dirEntry;
    }

    final /* synthetic */ ZipFile access$2() {
        return this.archive;
    }

    static {
        $assertionsDisabled = !Class.forName("scala.tools.util.ZipArchive").desiredAssertionStatus();
    }

    private final class FileEntry
    extends Entry {
        public final ZipEntry entry;

        public FileEntry(String string, String string2, ZipEntry zipEntry) {
            super(string, string2);
            this.entry = zipEntry;
        }

        public long lastModified() {
            return this.entry.getTime();
        }

        public byte[] read() throws IOException {
            int n;
            InputStream inputStream = ZipArchive.this.access$2().getInputStream(this.entry);
            int n2 = (int)this.entry.getSize();
            byte[] byArray = new byte[n2];
            do {
                if ((n = inputStream.read(byArray, byArray.length - n2, n2)) != -1) continue;
                throw new IOException("read error");
            } while ((n2 -= n) > 0);
            inputStream.close();
            return byArray;
        }
    }

    private final class DirEntry
    extends Entry {
        public final HashMap entries = new HashMap();
        public ZipEntry entry;

        public DirEntry(String string, String string2) {
            super(string, string2);
        }

        public boolean isDirectory() {
            return true;
        }

        public long lastModified() {
            return this.entry != null ? this.entry.getTime() : super.lastModified();
        }

        public Iterator list() {
            return this.entries.values().iterator();
        }

        public AbstractFile lookupName(String string, boolean bl) {
            return (AbstractFile)this.entries.get(bl ? String.valueOf(String.valueOf(string)).concat("/") : string);
        }
    }

    private abstract class Entry
    extends VirtualFile {
        public Entry(String string, String string2) {
            super(string, string2);
        }

        public final String getPath() {
            return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(ZipArchive.this)).concat("("))).concat(String.valueOf(String.valueOf(super.getPath()))))).concat(")");
        }
    }
}

