/*
 * Decompiled with CFR 0.152.
 */
package scalac;

import scalac.CompilationUnit;
import scalac.Global;
import scalac.PhaseDescriptor;
import scalac.symtab.Symbol;
import scalac.symtab.Type;

public abstract class Phase {
    public final Global global;
    public final PhaseDescriptor descriptor;
    public final int id;
    public final Phase prev;
    public Phase next;

    public Phase(Global global, PhaseDescriptor phaseDescriptor) {
        this.global = global;
        this.descriptor = phaseDescriptor;
        this.id = phaseDescriptor.id();
        this.prev = global.currentPhase;
        if (this.prev != null) {
            this.prev.next = this;
        }
        phaseDescriptor.initialize(this);
        global.currentPhase = this;
    }

    public boolean precedes(Phase phase) {
        return this.id < phase.id;
    }

    public Type transformInfo(Symbol symbol, Type type) {
        return type;
    }

    public abstract void apply(CompilationUnit var1);

    public final String toString() {
        return this.descriptor.name();
    }
}

