/*
 * Decompiled with CFR 0.152.
 */
package scalac.atree;

import java.util.LinkedHashMap;
import java.util.Map;
import scala.tools.util.debug.Debug;
import scalac.atree.AField;
import scalac.atree.AMethod;
import scalac.atree.ARepository;
import scalac.atree.ATreePrinter;
import scalac.symtab.Symbol;
import scalac.symtab.Type;

public class AClass
extends ARepository {
    private final Symbol symbol;
    private final Map fields;
    private final Map methods;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public AClass(Symbol symbol) {
        this.symbol = symbol;
        this.fields = new LinkedHashMap();
        this.methods = new LinkedHashMap();
    }

    public Symbol symbol() {
        return this.symbol;
    }

    public boolean isPublic() {
        return this.symbol().isPublic();
    }

    public boolean isPrivate() {
        return this.symbol().isPrivate();
    }

    public boolean isProtected() {
        return this.symbol().isProtected();
    }

    public boolean isFinal() {
        return false;
    }

    public boolean isAbstract() {
        return this.symbol.isAbstractClass();
    }

    public boolean isInterface() {
        return this.symbol.isInterface();
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isSynthetic() {
        return this.symbol().isSynthetic();
    }

    public void addField(AField aField) {
        if (!$assertionsDisabled && this.fields.containsKey(aField.symbol())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(aField)));
        }
        this.fields.put(aField.symbol(), aField);
    }

    public void addMethod(AMethod aMethod) {
        if (!$assertionsDisabled && this.methods.containsKey(aMethod.symbol())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(aMethod)));
        }
        this.methods.put(aMethod.symbol(), aMethod);
    }

    public AField[] fields() {
        return this.fields.values().toArray(new AField[this.fields.size()]);
    }

    public AMethod[] methods() {
        return this.methods.values().toArray(new AMethod[this.methods.size()]);
    }

    public Symbol[] tparams() {
        return this.symbol.typeParams();
    }

    public Symbol[] vparams() {
        return this.symbol.valueParams();
    }

    public Type[] parents() {
        Type type = this.symbol.info();
        if (type.$tag == 0) {
            Type.CompoundType compoundType = (Type.CompoundType)type;
            Type[] typeArray = compoundType.parts;
            return typeArray;
        }
        throw Debug.abort("illegal case", this.symbol.info());
    }

    public String toString() {
        return new ATreePrinter().printClass(this).toString();
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.atree.AClass").desiredAssertionStatus();
    }
}

