/*
 * Decompiled with CFR 0.152.
 */
package scalac.atree;

import scalac.ast.Tree;
import scalac.atree.AArithmeticOp;
import scalac.atree.ACode;
import scalac.atree.AComparisonOp;
import scalac.atree.AConstant;
import scalac.atree.AFunction;
import scalac.atree.ALocation;
import scalac.atree.ALogicalOp;
import scalac.atree.APrimitive;
import scalac.atree.AShiftOp;
import scalac.atree.ATestOp;
import scalac.atree.ATypeKind;
import scalac.symtab.Symbol;
import scalac.symtab.Type;

public class ATreeFactory {
    public final ACode Void = ACode.Void;
    public final AConstant UNIT = AConstant.UNIT;
    public final AConstant NULL = AConstant.NULL;
    public final AConstant ZERO = AConstant.ZERO;

    public ACode This(Tree tree, Symbol symbol) {
        ACode.This this_ = ACode.This(symbol);
        this_.pos = tree.pos;
        return this_;
    }

    public ACode Constant(Tree tree, AConstant aConstant) {
        ACode.Constant constant = ACode.Constant(aConstant);
        constant.pos = tree.pos;
        return constant;
    }

    public ACode Load(Tree tree, ALocation aLocation) {
        ACode.Load load = ACode.Load(aLocation);
        load.pos = tree.pos;
        return load;
    }

    public ACode Store(Tree tree, ALocation aLocation, ACode aCode) {
        ACode.Store store = ACode.Store(aLocation, aCode);
        store.pos = tree.pos;
        return store;
    }

    public ACode Apply(Tree tree, AFunction aFunction, Type[] typeArray, ACode[] aCodeArray) {
        ACode.Apply apply = ACode.Apply(aFunction, typeArray, aCodeArray);
        apply.pos = tree.pos;
        return apply;
    }

    public ACode Apply(Tree tree, AFunction aFunction, Type[] typeArray) {
        return this.Apply(tree, aFunction, typeArray, ACode.EMPTY_ARRAY);
    }

    public ACode Apply(Tree tree, AFunction aFunction, ACode[] aCodeArray) {
        return this.Apply(tree, aFunction, Type.EMPTY_ARRAY, aCodeArray);
    }

    public ACode Apply(Tree tree, AFunction aFunction) {
        return this.Apply(tree, aFunction, Type.EMPTY_ARRAY, ACode.EMPTY_ARRAY);
    }

    public ACode Apply(Tree tree, APrimitive aPrimitive, ACode aCode) {
        return this.Apply(tree, (AFunction)AFunction.Primitive(aPrimitive), new ACode[]{aCode});
    }

    public ACode Apply(Tree tree, APrimitive aPrimitive, ACode aCode, ACode aCode2) {
        return this.Apply(tree, (AFunction)AFunction.Primitive(aPrimitive), new ACode[]{aCode, aCode2});
    }

    public ACode IsAs(Tree tree, ACode aCode, Type type, boolean bl) {
        ACode.IsAs isAs = ACode.IsAs(aCode, type, bl);
        isAs.pos = tree.pos;
        return isAs;
    }

    public ACode If(Tree tree, ACode aCode, ACode aCode2, ACode aCode3) {
        ACode.If if_ = ACode.If(aCode, aCode2, aCode3);
        if_.pos = tree.pos;
        return if_;
    }

    public ACode Switch(Tree tree, ACode aCode, int[][] nArray, ACode[] aCodeArray) {
        ACode.Switch switch_ = ACode.Switch(aCode, nArray, aCodeArray);
        switch_.pos = tree.pos;
        return switch_;
    }

    public ACode Synchronized(Tree tree, ACode aCode, ACode aCode2) {
        ACode.Synchronized synchronized_ = ACode.Synchronized(aCode, aCode2);
        synchronized_.pos = tree.pos;
        return synchronized_;
    }

    public ACode Block(Tree tree, Symbol[] symbolArray, ACode[] aCodeArray, ACode aCode) {
        ACode.Block block = ACode.Block(symbolArray, aCodeArray, aCode);
        block.pos = tree.pos;
        return block;
    }

    public ACode Label(Tree tree, Symbol symbol, Symbol[] symbolArray, ACode aCode) {
        ACode.Label label = ACode.Label(symbol, symbolArray, aCode);
        label.pos = tree.pos;
        return label;
    }

    public ACode Goto(Tree tree, Symbol symbol, ACode[] aCodeArray) {
        ACode.Goto goto_ = ACode.Goto(symbol, aCodeArray);
        goto_.pos = tree.pos;
        return goto_;
    }

    public ACode Return(Tree tree, Symbol symbol, ACode aCode) {
        ACode.Return return_ = ACode.Return(symbol, aCode);
        return_.pos = tree.pos;
        return return_;
    }

    public ACode Throw(Tree tree, ACode aCode) {
        ACode.Throw throw_ = ACode.Throw(aCode);
        throw_.pos = tree.pos;
        return throw_;
    }

    public ACode Drop(Tree tree, ACode aCode, Type type) {
        ACode.Drop drop = ACode.Drop(aCode, type);
        drop.pos = tree.pos;
        return drop;
    }

    public ACode NOT(Tree tree, ATypeKind aTypeKind, ACode aCode) {
        return this.Apply(tree, this.NOT(aTypeKind), aCode);
    }

    public ACode EQ(Tree tree, ATypeKind aTypeKind, ACode aCode) {
        return this.Apply(tree, this.EQ(aTypeKind, true), aCode);
    }

    public ACode NE(Tree tree, ATypeKind aTypeKind, ACode aCode) {
        return this.Apply(tree, this.NE(aTypeKind, true), aCode);
    }

    public ACode LT(Tree tree, ATypeKind aTypeKind, ACode aCode) {
        return this.Apply(tree, this.LT(aTypeKind, true), aCode);
    }

    public ACode GE(Tree tree, ATypeKind aTypeKind, ACode aCode) {
        return this.Apply(tree, this.GE(aTypeKind, true), aCode);
    }

    public ACode LE(Tree tree, ATypeKind aTypeKind, ACode aCode) {
        return this.Apply(tree, this.LE(aTypeKind, true), aCode);
    }

    public ACode GT(Tree tree, ATypeKind aTypeKind, ACode aCode) {
        return this.Apply(tree, this.GT(aTypeKind, true), aCode);
    }

    public ACode EQ(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.EQ(aTypeKind, false), aCode, aCode2);
    }

    public ACode NE(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.NE(aTypeKind, false), aCode, aCode2);
    }

    public ACode LT(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.LT(aTypeKind, false), aCode, aCode2);
    }

    public ACode GE(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.GE(aTypeKind, false), aCode, aCode2);
    }

    public ACode LE(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.LE(aTypeKind, false), aCode, aCode2);
    }

    public ACode GT(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.GT(aTypeKind, false), aCode, aCode2);
    }

    public ACode CMPL(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.CMPL(aTypeKind), aCode, aCode2);
    }

    public ACode CMP(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.CMP(aTypeKind), aCode, aCode2);
    }

    public ACode CMPG(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.CMPG(aTypeKind), aCode, aCode2);
    }

    public ACode ADD(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.ADD(aTypeKind), aCode, aCode2);
    }

    public ACode SUB(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.SUB(aTypeKind), aCode, aCode2);
    }

    public ACode MUL(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.MUL(aTypeKind), aCode, aCode2);
    }

    public ACode DIV(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.DIV(aTypeKind), aCode, aCode2);
    }

    public ACode REM(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.REM(aTypeKind), aCode, aCode2);
    }

    public ACode AND(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.AND(aTypeKind), aCode, aCode2);
    }

    public ACode OR(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.OR(aTypeKind), aCode, aCode2);
    }

    public ACode XOR(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.XOR(aTypeKind), aCode, aCode2);
    }

    public ACode LSL(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.LSL(aTypeKind), aCode, aCode2);
    }

    public ACode LSR(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.LSR(aTypeKind), aCode, aCode2);
    }

    public ACode ASR(Tree tree, ATypeKind aTypeKind, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.ASR(aTypeKind), aCode, aCode2);
    }

    public ACode CONVERT(Tree tree, ATypeKind aTypeKind, ATypeKind aTypeKind2, ACode aCode) {
        return this.Apply(tree, this.CONVERT(aTypeKind, aTypeKind2), aCode);
    }

    public ACode LENGTH(Tree tree, ATypeKind aTypeKind, ACode aCode) {
        return this.Apply(tree, this.LENGTH(aTypeKind), aCode);
    }

    public ACode CONCAT(Tree tree, ATypeKind aTypeKind, ATypeKind aTypeKind2, ACode aCode, ACode aCode2) {
        return this.Apply(tree, this.CONCAT(aTypeKind, aTypeKind2), aCode, aCode2);
    }

    public APrimitive NOT(ATypeKind aTypeKind) {
        return APrimitive.Negation(aTypeKind);
    }

    public APrimitive EQ(ATypeKind aTypeKind, boolean bl) {
        return APrimitive.Test(ATestOp.EQ, aTypeKind, bl);
    }

    public APrimitive NE(ATypeKind aTypeKind, boolean bl) {
        return APrimitive.Test(ATestOp.NE, aTypeKind, bl);
    }

    public APrimitive LT(ATypeKind aTypeKind, boolean bl) {
        return APrimitive.Test(ATestOp.LT, aTypeKind, bl);
    }

    public APrimitive GE(ATypeKind aTypeKind, boolean bl) {
        return APrimitive.Test(ATestOp.GE, aTypeKind, bl);
    }

    public APrimitive LE(ATypeKind aTypeKind, boolean bl) {
        return APrimitive.Test(ATestOp.LE, aTypeKind, bl);
    }

    public APrimitive GT(ATypeKind aTypeKind, boolean bl) {
        return APrimitive.Test(ATestOp.GT, aTypeKind, bl);
    }

    public APrimitive CMPL(ATypeKind aTypeKind) {
        return APrimitive.Comparison(AComparisonOp.CMPL, aTypeKind);
    }

    public APrimitive CMP(ATypeKind aTypeKind) {
        return APrimitive.Comparison(AComparisonOp.CMP, aTypeKind);
    }

    public APrimitive CMPG(ATypeKind aTypeKind) {
        return APrimitive.Comparison(AComparisonOp.CMPG, aTypeKind);
    }

    public APrimitive ADD(ATypeKind aTypeKind) {
        return APrimitive.Arithmetic(AArithmeticOp.ADD, aTypeKind);
    }

    public APrimitive SUB(ATypeKind aTypeKind) {
        return APrimitive.Arithmetic(AArithmeticOp.SUB, aTypeKind);
    }

    public APrimitive MUL(ATypeKind aTypeKind) {
        return APrimitive.Arithmetic(AArithmeticOp.MUL, aTypeKind);
    }

    public APrimitive DIV(ATypeKind aTypeKind) {
        return APrimitive.Arithmetic(AArithmeticOp.DIV, aTypeKind);
    }

    public APrimitive REM(ATypeKind aTypeKind) {
        return APrimitive.Arithmetic(AArithmeticOp.REM, aTypeKind);
    }

    public APrimitive AND(ATypeKind aTypeKind) {
        return APrimitive.Logical(ALogicalOp.AND, aTypeKind);
    }

    public APrimitive OR(ATypeKind aTypeKind) {
        return APrimitive.Logical(ALogicalOp.OR, aTypeKind);
    }

    public APrimitive XOR(ATypeKind aTypeKind) {
        return APrimitive.Logical(ALogicalOp.XOR, aTypeKind);
    }

    public APrimitive LSL(ATypeKind aTypeKind) {
        return APrimitive.Shift(AShiftOp.LSL, aTypeKind);
    }

    public APrimitive LSR(ATypeKind aTypeKind) {
        return APrimitive.Shift(AShiftOp.LSR, aTypeKind);
    }

    public APrimitive ASR(ATypeKind aTypeKind) {
        return APrimitive.Shift(AShiftOp.ASR, aTypeKind);
    }

    public APrimitive CONVERT(ATypeKind aTypeKind, ATypeKind aTypeKind2) {
        return APrimitive.Conversion(aTypeKind, aTypeKind2);
    }

    public APrimitive LENGTH(ATypeKind aTypeKind) {
        return APrimitive.ArrayLength(aTypeKind);
    }

    public APrimitive CONCAT(ATypeKind aTypeKind, ATypeKind aTypeKind2) {
        return APrimitive.StringConcat(aTypeKind, aTypeKind2);
    }

    public AConstant BOOLEAN(Boolean bl) {
        return this.BOOLEAN((boolean)bl);
    }

    public AConstant BOOLEAN(boolean bl) {
        return AConstant.BOOLEAN(bl);
    }

    public AConstant BYTE(Byte by) {
        return this.BYTE((byte)by);
    }

    public AConstant BYTE(byte by) {
        return AConstant.BYTE(by);
    }

    public AConstant SHORT(Short s) {
        return this.SHORT((short)s);
    }

    public AConstant SHORT(short s) {
        return AConstant.SHORT(s);
    }

    public AConstant CHAR(Character c) {
        return this.CHAR(c.charValue());
    }

    public AConstant CHAR(char c) {
        return AConstant.CHAR(c);
    }

    public AConstant INT(Integer n) {
        return this.INT((int)n);
    }

    public AConstant INT(int n) {
        return AConstant.INT(n);
    }

    public AConstant LONG(Long l) {
        return this.LONG((long)l);
    }

    public AConstant LONG(long l) {
        return AConstant.LONG(l);
    }

    public AConstant FLOAT(Float f) {
        return this.FLOAT(f.floatValue());
    }

    public AConstant FLOAT(float f) {
        return AConstant.FLOAT(f);
    }

    public AConstant DOUBLE(Double d) {
        return this.DOUBLE((double)d);
    }

    public AConstant DOUBLE(double d) {
        return AConstant.DOUBLE(d);
    }

    public AConstant STRING(String string) {
        return AConstant.STRING(string);
    }
}

