/*
 * Decompiled with CFR 0.152.
 */
package scalac.checkers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import scala.tools.util.Position;
import scala.tools.util.debug.Debug;
import scalac.CompilationUnit;
import scalac.ast.Tree;
import scalac.symtab.Definitions;
import scalac.symtab.Symbol;
import scalac.symtab.Type;

public class TreeChecker {
    private final Definitions definitions;
    private final Stack units = new Stack();
    private final Stack classes = new Stack();
    private final Stack members = new Stack();
    private final Stack owners = new Stack();
    private final Set tvars = new HashSet();
    private final Set vvars = new HashSet();
    private final Set labels = new HashSet();
    private final Set symbols = new HashSet();
    private static final /* synthetic */ boolean $assertionsDisabled;

    public TreeChecker(Definitions definitions) {
        this.definitions = definitions;
    }

    public boolean check(CompilationUnit compilationUnit) {
        this.pushUnit(compilationUnit);
        this.template(compilationUnit.body);
        this.popUnit();
        return true;
    }

    private boolean template(Tree[] treeArray) {
        for (int i = 0; i < treeArray.length; ++i) {
            this.template(treeArray[i]);
        }
        return true;
    }

    private boolean template(Tree tree) {
        switch (tree.$tag) {
            case 42: {
                return true;
            }
            case 10: {
                Tree.ClassDef classDef = (Tree.ClassDef)tree;
                if (classDef.impl.$tag != 33) break;
                Tree.Template template = classDef.impl;
                Tree[] treeArray = classDef.tparams;
                Tree.ValDef[][] valDefArray = classDef.vparams;
                Tree[] treeArray2 = template.body;
                Symbol symbol = tree.symbol();
                if (!($assertionsDisabled || symbol != null && symbol.isClass())) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                if (!$assertionsDisabled && valDefArray.length != 1) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                this.containSymbols(treeArray, symbol.typeParams());
                this.containSymbols(valDefArray[0], symbol.valueParams());
                this.registerSymbol(symbol);
                this.scopeInsertParametersOf(symbol);
                this.pushClass(symbol);
                this.member(treeArray2);
                this.popClass();
                this.scopeRemoveParametersOf(symbol);
                return true;
            }
            case 24: {
                Tree.PackageDef packageDef = (Tree.PackageDef)tree;
                if (packageDef.impl.$tag != 33) break;
                Tree.Template template = packageDef.impl;
                Tree tree2 = packageDef.packaged;
                Tree[] treeArray = template.parents;
                Tree[] treeArray3 = template.body;
                Symbol symbol = tree2.symbol();
                if (!($assertionsDisabled || symbol != null && symbol.isPackage())) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree2))));
                }
                if (!$assertionsDisabled && treeArray.length != 0) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                this.pushOwner(symbol);
                this.template(treeArray3);
                this.popOwner();
                return true;
            }
        }
        throw Debug.abort("illegal case", tree);
    }

    private boolean member(Tree[] treeArray) {
        for (int i = 0; i < treeArray.length; ++i) {
            this.member(treeArray[i]);
        }
        return true;
    }

    private boolean member(Tree tree) {
        switch (tree.$tag) {
            case 42: {
                return true;
            }
            case 10: {
                return this.template(tree);
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Tree tree2 = valDef.rhs;
                Symbol symbol = tree.symbol();
                if (!($assertionsDisabled || symbol != null && symbol.isTerm())) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                if (!$assertionsDisabled && tree2 != Tree.Empty) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                this.registerSymbol(symbol);
                this.pushMember(symbol);
                this.popMember();
                return true;
            }
            case 13: {
                Tree.DefDef defDef = (Tree.DefDef)tree;
                Tree[] treeArray = defDef.tparams;
                Tree.ValDef[][] valDefArray = defDef.vparams;
                Tree tree3 = defDef.rhs;
                Symbol symbol = tree.symbol();
                if (!($assertionsDisabled || symbol != null && symbol.isMethod())) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                if (!$assertionsDisabled && valDefArray.length != 1) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                this.containSymbols(treeArray, symbol.typeParams());
                this.containSymbols(valDefArray[0], symbol.valueParams());
                if (!$assertionsDisabled && symbol.isDeferred() != (tree3 == Tree.Empty)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                this.registerSymbol(symbol);
                this.scopeInsertParametersOf(symbol);
                this.pushMember(symbol);
                if (!symbol.isDeferred()) {
                    this.expression(tree3, symbol.resultType());
                }
                this.popMember();
                this.scopeRemoveParametersOf(symbol);
                return true;
            }
        }
        throw Debug.abort("illegal case", tree);
    }

    private boolean statement(Set set, Tree tree) {
        switch (tree.$tag) {
            case 42: {
                return true;
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Tree tree2 = valDef.rhs;
                Symbol symbol = tree.symbol();
                if (!($assertionsDisabled || symbol != null && symbol.isTerm())) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                this.scopeInsertVVariable(symbol, false);
                set.add(symbol);
                this.pushOwner(symbol);
                this.expression(tree2, symbol.type());
                this.popOwner();
                return true;
            }
        }
        return this.expression(tree, tree.type());
    }

    private boolean expression(Tree tree, Type type) {
        type = tree.type();
        switch (tree.$tag) {
            case 20: {
                Tree.LabelDef labelDef = (Tree.LabelDef)tree;
                Tree.Ident[] identArray = labelDef.params;
                Tree tree2 = labelDef.rhs;
                Symbol symbol = tree.symbol();
                if (!($assertionsDisabled || symbol != null && symbol.isLabel())) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                Symbol[] symbolArray = symbol.type().valueParams();
                if (!$assertionsDisabled && symbolArray.length != identArray.length) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.show(tree))).concat(String.valueOf(String.valueOf(this.format("params", Debug.show(symbolArray))))))));
                }
                for (int i = 0; i < identArray.length; ++i) {
                    this.location(identArray[i]);
                    this.conforms(identArray[i], this.definitions.ANY_TYPE(), symbolArray[i].type());
                    Symbol symbol2 = identArray[i].symbol();
                    if (!$assertionsDisabled && (symbol2 == null || symbol2.isModule())) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(identArray[i]))));
                    }
                }
                this.conforms(tree, symbol.resultType());
                this.scopeInsertLabel(symbol);
                this.expression(tree2, symbol.resultType());
                this.scopeRemoveLabel(symbol);
                return true;
            }
            case 8: {
                Tree.Block block = (Tree.Block)tree;
                Tree[] treeArray = block.stats;
                Tree tree3 = block.expr;
                HashSet hashSet = new HashSet();
                for (int i = 0; i < treeArray.length; ++i) {
                    this.statement(hashSet, treeArray[i]);
                }
                this.expression(tree3, type);
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    this.scopeRemoveVVariable((Symbol)iterator.next());
                }
                return true;
            }
            case 5: {
                Tree.Assign assign = (Tree.Assign)tree;
                Tree tree4 = assign.lhs;
                Tree tree5 = assign.rhs;
                this.location(tree4);
                this.expression(tree5, tree4.type().widen());
                return true;
            }
            case 18: {
                Tree.If if_ = (Tree.If)tree;
                Tree tree6 = if_.cond;
                Tree tree7 = if_.thenp;
                Tree tree8 = if_.elsep;
                this.expression(tree6, this.definitions.boolean_TYPE());
                this.expression(tree7, type);
                this.expression(tree8, type);
                return true;
            }
            case 32: {
                Tree.Switch switch_ = (Tree.Switch)tree;
                Tree tree9 = switch_.test;
                Tree[] treeArray = switch_.bodies;
                Tree tree10 = switch_.otherwise;
                this.expression(tree9, this.definitions.int_TYPE());
                for (int i = 0; i < treeArray.length; ++i) {
                    this.expression(treeArray[i], type);
                }
                this.expression(tree10, type);
                return true;
            }
            case 26: {
                Tree.Return return_ = (Tree.Return)tree;
                Tree tree11 = return_.expr;
                Symbol symbol = tree.symbol();
                if (!($assertionsDisabled || symbol != null && symbol.isMethod())) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                if (!$assertionsDisabled && this.currentMember() != symbol) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                return this.expression(tree11, this.currentMember().resultType());
            }
            case 35: {
                Tree.Throw throw_ = (Tree.Throw)tree;
                Tree tree12 = throw_.expr;
                return this.expression(tree12, this.definitions.THROWABLE_TYPE());
            }
            case 23: {
                Tree.New new_ = (Tree.New)tree;
                Tree tree13 = new_.init;
                if (tree13.$tag == 4) {
                    Tree.Apply apply = (Tree.Apply)tree13;
                    if (apply.fun.$tag == 27) {
                        Tree.Select select = (Tree.Select)apply.fun;
                        if (select.qualifier.$tag == 12) {
                            return this.expression(tree13, this.definitions.void_TYPE());
                        }
                    }
                }
                throw Debug.abort("illegal case", this.show(tree));
            }
            case 12: {
                Tree.Create create = (Tree.Create)tree;
                Tree tree14 = create.qualifier;
                if (!$assertionsDisabled && tree14 != Tree.Empty) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                Symbol symbol = tree.symbol();
                if (!($assertionsDisabled || symbol != null && symbol.isClass())) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                return true;
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                Tree tree15 = apply.fun;
                Tree[] treeArray = apply.args;
                this.vapply(tree, tree15.type(), treeArray);
                if (tree15.$tag == 37) {
                    Tree.TypeApply typeApply = (Tree.TypeApply)tree15;
                    Tree tree16 = typeApply.fun;
                    Tree[] treeArray2 = typeApply.args;
                    Symbol symbol = tree16.symbol();
                    if (!$assertionsDisabled && (symbol == null || symbol.isLabel())) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                    }
                    this.tapply(tree, tree16.type(), treeArray2);
                    return this.function(tree16);
                }
                return this.function(tree15);
            }
            case 31: {
                Symbol symbol = tree.symbol();
                if (!($assertionsDisabled || symbol != null && symbol.isClass())) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                if (!$assertionsDisabled && symbol != this.currentClass()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                return true;
            }
            case 34: {
                Symbol symbol = tree.symbol();
                if (!($assertionsDisabled || symbol != null && symbol.isClass())) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                if (!$assertionsDisabled && symbol != this.currentClass()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                return true;
            }
            case 27: {
                return this.location(tree);
            }
            case 17: {
                return this.location(tree);
            }
            case 21: {
                return true;
            }
        }
        throw Debug.abort("illegal case", this.show(tree));
    }

    private boolean tapply(Tree tree, Type type, Tree[] treeArray) {
        Symbol[] symbolArray = type.typeParams();
        if (!$assertionsDisabled && symbolArray.length != treeArray.length) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.show(tree))).concat(String.valueOf(String.valueOf(this.format("params", Debug.show(symbolArray))))))));
        }
        Type.Map map = Type.getSubst(symbolArray, Tree.typeOf(treeArray));
        for (int i = 0; i < treeArray.length; ++i) {
            Type type2 = map.apply(symbolArray[i].info());
            Type type3 = map.apply(symbolArray[i].loBound());
            this.conforms(treeArray[i], type2, type3);
        }
        this.conforms(tree, map.apply(type.resultType()));
        return true;
    }

    private boolean vapply(Tree tree, Type type, Tree[] treeArray) {
        Symbol[] symbolArray = type.valueParams();
        if (!$assertionsDisabled && symbolArray.length != treeArray.length) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.show(tree))).concat(String.valueOf(String.valueOf(this.format("params", Debug.show(symbolArray))))))));
        }
        for (int i = 0; i < treeArray.length; ++i) {
            this.expression(treeArray[i], symbolArray[i].type());
        }
        this.conforms(tree, type.resultType());
        return true;
    }

    private boolean function(Tree tree) {
        Symbol symbol = tree.symbol();
        if (!($assertionsDisabled || symbol != null && symbol.isTerm())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
        }
        if (!$assertionsDisabled && !symbol.isMethod()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
        }
        switch (tree.$tag) {
            case 27: {
                Tree.Select select = (Tree.Select)tree;
                Tree tree2 = select.qualifier;
                if (tree2 instanceof Tree.Create && !$assertionsDisabled && !symbol.isInitializer()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                return this.selection(tree);
            }
            case 17: {
                if (!symbol.isLabel() && symbol.isStatic()) {
                    return true;
                }
                if (!$assertionsDisabled && !this.labels.contains(symbol)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                if (!$assertionsDisabled && symbol.owner() != this.currentMember()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                return true;
            }
        }
        throw Debug.abort("illegal case", tree);
    }

    private boolean location(Tree tree) {
        Symbol symbol = tree.symbol();
        if (!($assertionsDisabled || symbol != null && symbol.isTerm())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
        }
        if (!$assertionsDisabled && symbol.isMethod()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
        }
        switch (tree.$tag) {
            case 27: {
                return this.selection(tree);
            }
            case 17: {
                if (symbol.isStatic()) {
                    return true;
                }
                if (!$assertionsDisabled && !this.vvars.contains(symbol)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                if (!$assertionsDisabled && symbol.owner() != this.currentMember()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
                }
                return true;
            }
        }
        throw Debug.abort("illegal case", tree);
    }

    private boolean selection(Tree tree) {
        if (tree.$tag == 27) {
            Tree.Select select = (Tree.Select)tree;
            Tree tree2 = select.qualifier;
            Symbol symbol = tree.symbol();
            if (!($assertionsDisabled || symbol != null && symbol.isTerm())) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
            }
            Symbol symbol2 = symbol.owner();
            if (!($assertionsDisabled || symbol2.isClass() && !symbol2.isStaticOwner())) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(tree))));
            }
            if (!$assertionsDisabled && tree2.type().baseType(symbol2) == Type.NoType) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.show(tree))).concat(String.valueOf(String.valueOf(this.format("qual.type", tree2.type())))))));
            }
            return this.expression(tree2, tree2.type());
        }
        throw Debug.abort("illegal case", tree);
    }

    private void containSymbols(Tree[] treeArray, Symbol[] symbolArray) {
        boolean bl = treeArray.length == symbolArray.length;
        for (int i = 0; bl && i < treeArray.length; bl &= treeArray[i].symbol() == symbolArray[i], ++i) {
        }
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.show())).concat(String.valueOf(String.valueOf(this.format("trees", treeArray)))))).concat(String.valueOf(String.valueOf(this.format("symbols", symbolArray)))))));
        }
    }

    private void conforms(Tree tree, Type type, Type type2) {
        this.conforms(tree, type);
    }

    private void conforms(Tree tree, Type type) {
        if (!tree.type().isSubType(type)) {
            Type.explainSwitch = true;
            if (!$assertionsDisabled && !tree.type().isSubType(type)) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.show(tree))).concat(String.valueOf(String.valueOf(this.format("expected", type)))))));
            }
            Type.explainSwitch = false;
        }
    }

    private void scopeInsertParametersOf(Symbol symbol) {
        Symbol[] symbolArray = symbol.typeParams();
        for (int i = 0; i < symbolArray.length; ++i) {
            this.scopeInsertTVariable(symbolArray[i], true);
        }
        Symbol[] symbolArray2 = symbol.valueParams();
        for (int i = 0; i < symbolArray2.length; ++i) {
            this.scopeInsertVVariable(symbolArray2[i], true);
        }
    }

    private void scopeInsertTVariable(Symbol symbol, boolean bl) {
        if (!$assertionsDisabled && symbol.owner().isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(symbol))));
        }
        if (!$assertionsDisabled && symbol.isParameter() != bl) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(symbol))));
        }
        this.registerSymbol(symbol);
        this.tvars.add(symbol);
    }

    private void scopeInsertVVariable(Symbol symbol, boolean bl) {
        if (!$assertionsDisabled && symbol.owner().isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(symbol))));
        }
        if (!$assertionsDisabled && symbol.isParameter() != bl) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(symbol))));
        }
        this.registerSymbol(symbol);
        this.vvars.add(symbol);
    }

    private void scopeInsertLabel(Symbol symbol) {
        if (!$assertionsDisabled && symbol.owner().isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(symbol))));
        }
        this.registerSymbol(symbol);
        this.labels.add(symbol);
    }

    private void scopeRemoveParametersOf(Symbol symbol) {
        Symbol[] symbolArray = symbol.typeParams();
        for (int i = 0; i < symbolArray.length; ++i) {
            this.scopeRemoveTVariable(symbolArray[i]);
        }
        Symbol[] symbolArray2 = symbol.valueParams();
        for (int i = 0; i < symbolArray2.length; ++i) {
            this.scopeRemoveVVariable(symbolArray2[i]);
        }
    }

    private void scopeRemoveTVariable(Symbol symbol) {
        boolean bl = this.tvars.remove(symbol);
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(symbol))));
        }
    }

    private void scopeRemoveVVariable(Symbol symbol) {
        boolean bl = this.vvars.remove(symbol);
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(symbol))));
        }
    }

    private void scopeRemoveLabel(Symbol symbol) {
        boolean bl = this.labels.remove(symbol);
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(symbol))));
        }
    }

    private void registerSymbol(Symbol symbol) {
        boolean bl = this.symbols.add(symbol);
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(symbol))));
        }
    }

    private CompilationUnit currentUnit() {
        return this.units.size() > 0 ? (CompilationUnit)this.units.peek() : null;
    }

    private Symbol currentClass() {
        return this.classes.size() > 0 ? (Symbol)this.classes.peek() : null;
    }

    private Symbol currentMember() {
        return this.members.size() > 0 ? (Symbol)this.members.peek() : null;
    }

    private Symbol currentOwner() {
        return this.owners.size() > 0 ? (Symbol)this.owners.peek() : null;
    }

    private void pushUnit(CompilationUnit compilationUnit) {
        if (!$assertionsDisabled && this.units.size() != 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.showPush(compilationUnit))));
        }
        if (!$assertionsDisabled && this.classes.size() != 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.showPush(compilationUnit))));
        }
        if (!$assertionsDisabled && this.members.size() != 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.showPush(compilationUnit))));
        }
        this.units.push(compilationUnit);
    }

    private void pushClass(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.showPush(symbol))));
        }
        if (!$assertionsDisabled && this.members.size() != 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.showPush(symbol))));
        }
        this.classes.push(symbol);
        this.pushOwner(symbol);
    }

    private void pushMember(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.showPush(symbol))));
        }
        if (!$assertionsDisabled && this.members.size() != 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.showPush(symbol))));
        }
        if (!$assertionsDisabled && symbol.owner() != this.currentClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.showPush(symbol))));
        }
        this.members.push(symbol);
        this.pushOwner(symbol);
    }

    private void pushOwner(Symbol symbol) {
        this.owners.push(symbol);
    }

    private void popUnit() {
        if (!$assertionsDisabled && this.units.size() <= 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show())));
        }
        this.units.pop();
    }

    private void popClass() {
        if (!$assertionsDisabled && this.members.size() != 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show())));
        }
        if (!$assertionsDisabled && this.classes.size() <= 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show())));
        }
        this.popOwner();
        this.classes.pop();
    }

    private void popMember() {
        if (!$assertionsDisabled && this.members.size() <= 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show())));
        }
        this.popOwner();
        this.members.pop();
    }

    private void popOwner() {
        if (!$assertionsDisabled && this.owners.size() <= 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show())));
        }
        this.owners.pop();
    }

    private String show() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.format("unit", this.currentUnit()))).concat(String.valueOf(String.valueOf(this.format("clasz", this.currentClass())))))).concat(String.valueOf(String.valueOf(this.format("member", this.currentMember())))))).concat(String.valueOf(String.valueOf(this.format("owner", this.currentOwner()))));
    }

    private String show(String string, Object object) {
        return String.valueOf(String.valueOf(this.show())).concat(String.valueOf(String.valueOf(this.format(string, object))));
    }

    private String show(Symbol symbol) {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.show("symbol", symbol))).concat(String.valueOf(String.valueOf(this.format("symbol.pos", Position.toString(symbol.pos))))))).concat(String.valueOf(String.valueOf(this.format("symbol.info", symbol.info()))));
    }

    private String show(Tree tree) {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.show("tree", tree))).concat(String.valueOf(String.valueOf(this.format("tree.pos", Position.toString(tree.pos))))))).concat(String.valueOf(String.valueOf(this.format("tree.symbol", tree.symbol())))))).concat(String.valueOf(String.valueOf(this.format("tree.type", tree.type()))));
    }

    private String showPush(Object object) {
        return this.show("pushing", object);
    }

    private String format(String string, Object object) {
        while (string.length() < 12) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(' '));
        }
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(string))))).concat(": "))).concat(String.valueOf(String.valueOf(this.toString(object))));
    }

    private String toString(Object object) {
        if (object instanceof Symbol) {
            return Debug.show(object);
        }
        if (object instanceof Object[]) {
            return Debug.show(object);
        }
        return String.valueOf(object);
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.checkers.TreeChecker").desiredAssertionStatus();
    }
}

