/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab;

public interface Modifiers {
    public static final int DEFERRED = 1;
    public static final int FINAL = 2;
    public static final int PRIVATE = 4;
    public static final int PROTECTED = 8;
    public static final int SEALED = 16;
    public static final int OVERRIDE = 32;
    public static final int CASE = 64;
    public static final int ABSTRACT = 128;
    public static final int DEF = 256;
    public static final int REPEATED = 512;
    public static final int SYNTHETIC = 1024;
    public static final int DEPRECATED = 2048;
    public static final int JAVA = 4096;
    public static final int MODUL = 8192;
    public static final int MUTABLE = 16384;
    public static final int VIEWBOUND = 16384;
    public static final int PARAM = 32768;
    public static final int INITIALIZED = 65536;
    public static final int LOCKED = 131072;
    public static final int ACCESSED = 262144;
    public static final int SELECTOR = 524288;
    public static final int PACKAGE = 0x100000;
    public static final int STABLE = 0x800000;
    public static final int CAPTURED = 0x1000000;
    public static final int INCONSTRUCTOR = 0x1000000;
    public static final int PARAMACCESSOR = 0x2000000;
    public static final int CLOSURELOCK = 0x2000000;
    public static final int ACCESSOR = 0x4000000;
    public static final int BRIDGE = 0x8000000;
    public static final int LIFTED = 0x8000000;
    public static final int ALTERNATIVE = 0x8000000;
    public static final int SNDTIME = 0x8000000;
    public static final int INTERFACE = 0x10000000;
    public static final int TRAIT = 0x20000000;
    public static final int COVARIANT = 0x40000000;
    public static final int CONTRAVARIANT = Integer.MIN_VALUE;
    public static final int SOURCEFLAGS = -535764105;
    public static final int ACCESSFLAGS = 12;
    public static final int VARIANCES = -1073741824;
    public static final int CONSTRFLAGS = 4160;
    public static final int MODULE2CLASSFLAGS = 1055820;

    public static class Helper {
        public static boolean isAbstract(int n) {
            return (n & 1) != 0 || (n & 0xA0) == 128;
        }

        public static boolean isFinal(int n) {
            return (n & 2) != 0;
        }

        public static boolean isPrivate(int n) {
            return (n & 4) != 0;
        }

        public static boolean isProtected(int n) {
            return (n & 8) != 0;
        }

        public static boolean isSealed(int n) {
            return (n & 0x10) != 0;
        }

        public static boolean isOverride(int n) {
            return (n & 0x20) != 0;
        }

        public static boolean isCase(int n) {
            return (n & 0x40) != 0;
        }

        public static boolean isCaseAccessor(int n) {
            return (n & 0x2000000) != 0;
        }

        public static boolean isInterface(int n) {
            return (n & 0x10000000) != 0;
        }

        public static boolean isDef(int n) {
            return (n & 0x100) != 0;
        }

        public static boolean isModClass(int n) {
            return (n & 0x2000) != 0;
        }

        public static boolean isJava(int n) {
            return (n & 0x1000) != 0;
        }

        public static boolean isNoVal(int n) {
            return (n & 0x100000) != 0;
        }

        public static String toString(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            Helper.toString(stringBuffer, n);
            return stringBuffer.toString();
        }

        public static void toString(StringBuffer stringBuffer, int n) {
            int n2;
            int n3 = stringBuffer.length();
            if (Helper.isPrivate(n)) {
                stringBuffer.append("private ");
            }
            if (Helper.isProtected(n)) {
                stringBuffer.append("protected ");
            }
            if (Helper.isAbstract(n)) {
                stringBuffer.append("abstract ");
            }
            if (Helper.isFinal(n)) {
                stringBuffer.append("final ");
            }
            if (Helper.isSealed(n)) {
                stringBuffer.append("sealed ");
            }
            if (Helper.isInterface(n)) {
                stringBuffer.append("interface ");
            }
            if (Helper.isCase(n)) {
                stringBuffer.append("case ");
            }
            if (Helper.isDef(n)) {
                stringBuffer.append("def ");
            }
            if (Helper.isOverride(n)) {
                stringBuffer.append("override ");
            }
            stringBuffer.setLength(n2 - ((n2 = stringBuffer.length()) == n3 ? 0 : 1));
        }
    }
}

