/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer;

import scala.tools.util.debug.Debug;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.Phase;
import scalac.PhaseDescriptor;
import scalac.backend.Primitive;
import scalac.backend.Primitives;
import scalac.symtab.Definitions;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.transformer.Erasure;
import scalac.util.Name;
import scalac.util.TypeName;

public class ErasurePhase
extends Phase {
    private final Definitions definitions;
    private final Primitives primitives;
    private final Erasure erasure;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public ErasurePhase(Global global, PhaseDescriptor phaseDescriptor) {
        super(global, phaseDescriptor);
        this.definitions = global.definitions;
        this.primitives = global.primitives;
        this.erasure = new Erasure(global);
    }

    public void apply(CompilationUnit compilationUnit) {
        this.erasure.apply(compilationUnit);
    }

    public Type transformInfo(Symbol symbol, Type type) {
        if (symbol.isConstructor() && symbol.constructorClass().isSubClass(this.definitions.ANYVAL_CLASS)) {
            return type;
        }
        if (symbol.isClass()) {
            if (symbol == this.definitions.ANY_CLASS) {
                return type;
            }
            if (symbol.isJava() && symbol.isModuleClass()) {
                return type;
            }
            if (symbol.isSubClass(this.definitions.ANYVAL_CLASS) && symbol != this.definitions.ANYVAL_CLASS) {
                return type;
            }
            if (type.$tag == 0) {
                Symbol symbol2;
                Type.CompoundType compoundType = (Type.CompoundType)type;
                Type[] typeArray = compoundType.parts;
                Scope scope = compoundType.members;
                if (!$assertionsDisabled && typeArray.length == 0) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(" -- "))).concat(String.valueOf(String.valueOf(type))))));
                }
                if (symbol.isInterface() && (symbol2 = typeArray[0].symbol()).isJava() && !symbol2.isInterface()) {
                    typeArray = Type.cloneArray(typeArray);
                    typeArray[0] = this.definitions.ANYREF_TYPE();
                    type = Type.compoundType(typeArray, scope, symbol);
                }
                return Type.erasureMap.map(type);
            }
            throw Debug.abort("illegal case", type);
        }
        if (symbol.isTerm() && symbol.isParameter()) {
            if (this.primitives.getPrimitive(symbol.owner()) == Primitive.BOX) {
                return this.eraseUnboxMethodType(type);
            }
            if (this.primitives.getPrimitive(symbol.owner()) == Primitive.UNBOX) {
                return this.eraseBoxMethodType(type);
            }
        }
        if (symbol.isType()) {
            return type;
        }
        if (symbol.isThisSym()) {
            return symbol.owner().nextType();
        }
        if (this.global.target == Global.TARGET_INT && symbol == this.primitives.NEW_OARRAY) {
            TypeName typeName = Name.fromString("element").toTypeName();
            Symbol symbol3 = symbol.newTParam(symbol.pos, 0, typeName, this.definitions.ANY_TYPE());
            return Type.PolyType(new Symbol[]{symbol3}, type);
        }
        Primitive primitive = this.primitives.getPrimitive(symbol);
        switch (primitive.$tag) {
            case 65: {
                return Type.PolyType(type.typeParams(), Type.MethodType(type.valueParams(), type.resultType().erasure()));
            }
            case 3: {
                return type;
            }
            case 15: {
                return this.eraseBoxMethodType(type);
            }
            case 116: {
                return this.eraseUnboxMethodType(type);
            }
        }
        return type.erasure();
    }

    private Type eraseBoxMethodType(Type type) {
        switch (type.$tag) {
            case 5: {
                Type.PolyType polyType = (Type.PolyType)type;
                Type type2 = polyType.result;
                return this.eraseBoxMethodType(type2);
            }
            case 3: {
                Type.MethodType methodType = (Type.MethodType)type;
                Symbol[] symbolArray = methodType.vparams;
                Type type3 = methodType.result;
                return Type.MethodType(symbolArray, this.eraseBoxMethodType(type3));
            }
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Type type4 = typeRef.pre;
                Symbol symbol = typeRef.sym;
                return Type.typeRef(type4, symbol, Type.EMPTY_ARRAY);
            }
        }
        throw Debug.abort("illegal case", type);
    }

    private Type eraseUnboxMethodType(Type type) {
        switch (type.$tag) {
            case 5: {
                Type.PolyType polyType = (Type.PolyType)type;
                Type type2 = polyType.result;
                return this.eraseUnboxMethodType(type2);
            }
            case 3: {
                Type.MethodType methodType = (Type.MethodType)type;
                Symbol[] symbolArray = methodType.vparams;
                Type type3 = methodType.result;
                return Type.MethodType(symbolArray, this.eraseUnboxMethodType(type3));
            }
            case 8: {
                Symbol symbol;
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Symbol symbol2 = typeRef.sym;
                Type[] typeArray = typeRef.args;
                if (symbol2 == this.definitions.ARRAY_CLASS && (symbol = typeArray[0].symbol()).isAbstractType() && symbol.info().symbol() == this.definitions.ANY_CLASS) {
                    return this.definitions.ANYREF_CLASS.nextType();
                }
                return type.fullErasure();
            }
        }
        throw Debug.abort("illegal case", type);
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.transformer.ErasurePhase").desiredAssertionStatus();
    }
}

