/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.Phase;
import scalac.PhaseDescriptor;
import scalac.ast.GenTransformer;
import scalac.ast.GenTreeCloner;
import scalac.ast.Tree;
import scalac.ast.TreeInfo;
import scalac.ast.TreeList;
import scalac.symtab.Modifiers;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.SymbolCloner;
import scalac.symtab.Type;
import scalac.transformer.AddInterfacesPhase;
import scalac.util.Debug;
import scalac.util.Names;

public class ExpandMixinsPhase
extends Phase {
    private final Map interfaces;
    private final Map transformers;
    private final Map expansions;
    private final Map bodies;
    private final Map origins;
    private final GenTransformer expander;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public ExpandMixinsPhase(Global global, PhaseDescriptor phaseDescriptor) {
        super(global, phaseDescriptor);
        Phase phase = global.PHASE.ADDINTERFACES.phase();
        this.interfaces = ((AddInterfacesPhase)phase).classToIFace;
        this.transformers = new HashMap();
        this.expansions = new HashMap();
        this.bodies = ((AddInterfacesPhase)phase).classToBody;
        this.origins = new HashMap();
        this.expander = new TreeExpander(global);
    }

    public void apply(CompilationUnit compilationUnit) {
        this.expander.apply(compilationUnit);
    }

    public Type transformInfo(Symbol symbol, Type type) {
        while (!symbol.isJava()) {
            if (symbol.isInterface()) {
                return type;
            }
            if (symbol.isCompoundSym()) {
                return type;
            }
            if (symbol.isClass()) {
                return this.getTypeExpander(symbol).apply(type);
            }
            symbol = symbol.isConstructor() ? symbol.constructorClass() : symbol.owner();
        }
        return type;
    }

    private TypeTransformer getTypeExpander(Symbol symbol) {
        if (!($assertionsDisabled || symbol.isClass() && !symbol.isInterface())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        TypeTransformer typeTransformer = (TypeTransformer)this.transformers.get(symbol);
        if (typeTransformer == null) {
            typeTransformer = new TypeTransformer(symbol);
            this.transformers.put(symbol, typeTransformer);
        }
        return typeTransformer;
    }

    private Tree[] getExpandedBody(Symbol symbol) {
        Tree[] treeArray = (Tree[])this.expansions.get(symbol);
        if (treeArray == null) {
            Object object;
            treeArray = (Tree[])this.bodies.remove(symbol);
            if (!$assertionsDisabled && treeArray == null) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
            }
            TypeTransformer typeTransformer = this.getTypeExpander(symbol);
            TreeList treeList = new TreeList();
            if (!$assertionsDisabled && !Debug.log("expanding tree ", symbol)) {
                throw new AssertionError();
            }
            Type[] typeArray = symbol.parents();
            TreeInliner treeInliner = new TreeInliner(this.global, typeTransformer);
            for (int i = 1; i < typeArray.length; ++i) {
                object = typeArray[i].symbol();
                if (((Symbol)object).isInterface()) continue;
                if (!$assertionsDisabled && !Debug.log("expanding tree ", symbol, ": inlining ", object)) {
                    throw new AssertionError();
                }
                treeList.append(treeInliner.transform(this.getExpandedBody((Symbol)object)));
            }
            object = new ClassTreeExpander(this.global, typeTransformer);
            treeList.append(((GenTransformer)object).transform(treeArray));
            treeArray = treeList.toArray();
            this.expansions.put(symbol, treeArray);
        }
        return treeArray;
    }

    final /* synthetic */ Tree[] access$19(Symbol symbol) {
        return this.getExpandedBody(symbol);
    }

    final /* synthetic */ Map access$20() {
        return this.origins;
    }

    final /* synthetic */ Map access$21() {
        return this.interfaces;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.transformer.ExpandMixinsPhase").desiredAssertionStatus();
    }

    private class ClassTreeExpander
    extends TreeExpander {
        private final Symbol clasz;
        private final Type[] parents;
        private final Map clones;
        private static final /* synthetic */ boolean $assertionsDisabled;

        public ClassTreeExpander(Global global, TypeTransformer typeTransformer) {
            super(global);
            this.clasz = typeTransformer.clasz;
            this.parents = this.clasz.parents();
            this.clones = typeTransformer.cloner.clones;
        }

        private Symbol getSuperMember(Symbol symbol) {
            for (int i = 0; i < this.parents.length; ++i) {
                this.global.nextPhase();
                if (this.parents[i].symbol().isSubClass(symbol.owner())) {
                    Symbol symbol2 = symbol.overridingSymbol(this.parents[i]);
                    this.global.prevPhase();
                    if (!$assertionsDisabled && symbol2.isNone()) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol, this.clasz, this.parents[i]))));
                    }
                    if (i == 0) {
                        return symbol2;
                    }
                    Symbol symbol3 = (Symbol)this.clones.get(symbol2);
                    if (!$assertionsDisabled && symbol3 == null) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol, symbol2, this.clasz))));
                    }
                    return symbol3;
                }
                this.global.prevPhase();
            }
            for (int i = 0; i < this.parents.length; ++i) {
                if (!this.parents[i].symbol().isSubClass(symbol.owner())) continue;
                Symbol symbol4 = symbol.overridingSymbol(this.parents[i]);
                if (!$assertionsDisabled && symbol4.isNone()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol, this.clasz, this.parents[i]))));
                }
                if (i == 0) {
                    return symbol4;
                }
                Symbol symbol5 = (Symbol)this.clones.get(symbol4);
                if (!$assertionsDisabled && symbol5 == null) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol, symbol4, this.clasz))));
                }
                return symbol5;
            }
            throw scala.tools.util.debug.Debug.abort(scala.tools.util.debug.Debug.show(symbol, this.clasz));
        }

        public Tree transform(Tree tree) {
            if (tree.$tag == 27) {
                Tree.Select select = (Tree.Select)tree;
                if (select.qualifier.$tag == 31) {
                    Symbol symbol = this.getSuperMember(tree.symbol());
                    Tree tree2 = symbol.owner() == this.clasz ? this.gen.This(tree.pos, this.clasz) : this.gen.Super(tree.pos, this.clasz);
                    return this.gen.Select(tree.pos, tree2, symbol);
                }
            }
            return super.transform(tree);
        }

        static {
            $assertionsDisabled = !Class.forName("scalac.transformer.ExpandMixinsPhase").desiredAssertionStatus();
        }
    }

    private static class TreeInliner
    extends GenTreeCloner {
        private final Symbol clasz;
        private final Type supertype;
        private boolean initializer;
        private static final /* synthetic */ boolean $assertionsDisabled;

        public TreeInliner(Global global, TypeTransformer typeTransformer) {
            super(global, typeTransformer, typeTransformer.cloner);
            this.clasz = typeTransformer.clasz;
            this.supertype = this.clasz.nextInfo().parents()[0];
        }

        public Symbol getSymbolFor(Tree tree) {
            switch (tree.$tag) {
                case 27: {
                    Tree.Select select = (Tree.Select)tree;
                    if (select.qualifier.$tag != 31) break;
                    if (tree.symbol().isInitializer()) {
                        return tree.symbol();
                    }
                    if (!$assertionsDisabled && !this.supertype.symbol().isSubClass(tree.symbol().owner())) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(tree)).concat(" -- "))).concat(String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(this.clasz)))))));
                    }
                    this.global.nextPhase();
                    Symbol symbol = tree.symbol().overriddenSymbol(this.supertype);
                    if (!$assertionsDisabled && symbol.isNone()) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(tree, this.clasz, this.supertype))));
                    }
                    this.global.prevPhase();
                    return symbol;
                }
                case 31: {
                    return this.clasz;
                }
                case 34: {
                    return this.clasz;
                }
            }
            return super.getSymbolFor(tree);
        }

        public Tree transform(Tree tree) {
            Object object;
            switch (tree.$tag) {
                case 40: {
                    if (!tree.symbol().hasStaticAttribute()) break;
                    return Tree.Empty;
                }
                case 13: {
                    Symbol symbol = this.getSymbolFor(tree);
                    if (symbol.owner() != this.clasz || symbol.hasStaticAttribute()) {
                        return Tree.Empty;
                    }
                    if (symbol.isInitializer()) {
                        this.initializer = true;
                    }
                    tree = super.transform(tree);
                    this.initializer = false;
                    return tree;
                }
                case 4: {
                    object = (Tree.Apply)tree;
                    if (((Tree.Apply)object).fun.$tag != 27) break;
                    Tree.Select select = (Tree.Select)((Tree.Apply)object).fun;
                    if (select.qualifier.$tag != 31 || !TreeInfo.methSymbol(tree).isInitializer() || this.initializer) break;
                    return Tree.Empty;
                }
            }
            if (tree.hasSymbol() && tree.symbol().isParameter() && !((Symbol)(object = this.getSymbolFor(tree))).isParameter()) {
                if (!$assertionsDisabled && !(tree instanceof Tree.Ident)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                }
                return this.gen.Select(this.gen.This(tree.pos, this.clasz), (Symbol)object);
            }
            return super.transform(tree);
        }

        static {
            $assertionsDisabled = !Class.forName("scalac.transformer.ExpandMixinsPhase").desiredAssertionStatus();
        }
    }

    private class TypeTransformer
    extends Type.MapOnlyTypes {
        public final Symbol clasz;
        public final Type[] parents;
        public final SymbolCloner cloner;
        public final Map inlines;
        private static final /* synthetic */ boolean $assertionsDisabled;

        public TypeTransformer(Symbol symbol) {
            this.clasz = symbol;
            this.parents = symbol.parents();
            this.cloner = new SymbolCloner();
            this.inlines = new HashMap();
            this.initialize();
        }

        private void initialize() {
            Modifiers modifiers;
            Object object;
            Type[] typeArray = this.clasz.parents();
            if (typeArray.length > 0) {
                typeArray[0].symbol().nextInfo();
            }
            if (!$assertionsDisabled && !Debug.log("expanding type ", this.clasz)) {
                throw new AssertionError();
            }
            for (int i = typeArray.length - 1; i > 0; --i) {
                object = typeArray[i];
                if (((Type)object).$tag != 8) continue;
                modifiers = (Type.TypeRef)object;
                Symbol symbol = ((Type.TypeRef)modifiers).sym;
                Type[] typeArray2 = ((Type.TypeRef)modifiers).args;
                if (symbol.isInterface()) continue;
                symbol.nextInfo();
                if (!$assertionsDisabled && !Debug.log("expanding type ", this.clasz, ": inlining ", symbol)) {
                    throw new AssertionError();
                }
                this.cloner.owners.put(symbol, this.clasz);
                this.cloner.owners.put(symbol.primaryConstructor(), this.clasz);
                Symbol[] symbolArray = symbol.typeParams();
                for (int j = 0; j < symbolArray.length; ++j) {
                    this.inlines.put(symbolArray[j], typeArray2[j]);
                }
                this.createMixedInMemberSymbols(symbol.nextInfo().members());
            }
            new HashSet(this.cloner.clones.keySet());
            object = this.cloner.clones.values().iterator();
            while (object.hasNext()) {
                modifiers = (Symbol)object.next();
                ((Symbol)modifiers).setInfo(this.apply(((Symbol)modifiers).info()));
            }
        }

        private Symbol getMemberOrigin(Symbol symbol) {
            Object v = ExpandMixinsPhase.this.access$20().get(symbol);
            return v == null ? symbol : (Symbol)v;
        }

        private void createMixedInMemberSymbols(Scope scope) {
            Scope scope2 = this.clasz.members();
            Scope.SymbolIterator symbolIterator = scope.iterator();
            while (symbolIterator.hasNext()) {
                Symbol symbol;
                Symbol symbol2 = symbolIterator.next();
                boolean bl = symbol2.isPrivate() || symbol2.isInitializer() || symbol2.overridingSymbol(this.clasz.thisType()) != symbol2;
                Symbol symbol3 = this.getMemberOrigin(symbol2);
                if (!bl && symbol3 != null && symbol3 == this.getMemberOrigin(symbol = symbol2.overriddenSymbol(this.parents[0]))) {
                    this.cloner.clones.put(symbol2, symbol);
                    continue;
                }
                if (!$assertionsDisabled && !Debug.log("expanding type ", this.clasz, ": cloning ", symbol2)) {
                    throw new AssertionError();
                }
                symbol = this.cloner.cloneSymbol(symbol2);
                if (bl) {
                    symbol.name = Names.MIXIN(symbol2);
                }
                if (bl) {
                    symbol.flags &= 0xFFFFFFDF;
                }
                if (bl) {
                    symbol.flags &= 0xFFFFFFF3;
                }
                if (bl) {
                    symbol.flags |= 4;
                }
                scope2.enterOrOverload(symbol);
                ExpandMixinsPhase.this.access$20().put(symbol, symbol3 != null ? symbol3 : symbol2);
            }
        }

        public Type apply(Type type) {
            switch (type.$tag) {
                case 8: {
                    Symbol symbol;
                    Type.TypeRef typeRef = (Type.TypeRef)type;
                    Type type2 = typeRef.pre;
                    Symbol symbol2 = typeRef.sym;
                    Type[] typeArray = typeRef.args;
                    Type type3 = (Type)this.inlines.get(symbol2);
                    if (type3 != null) {
                        return type3;
                    }
                    if (symbol2.isParameter() && (symbol = (Symbol)this.cloner.clones.get(symbol2)) != null) {
                        if (!($assertionsDisabled || type2 == Type.NoPrefix && typeArray.length == 0)) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(type)));
                        }
                        return Type.typeRef(type2, symbol, typeArray);
                    }
                    return this.map(type);
                }
                case 6: {
                    Type.SingleType singleType = (Type.SingleType)type;
                    Type type4 = singleType.pre;
                    Symbol symbol = singleType.sym;
                    Symbol symbol3 = (Symbol)this.cloner.clones.get(symbol);
                    type4 = this.apply(type4);
                    return Type.singleType(type4, symbol3 != null ? symbol3 : symbol);
                }
                case 7: {
                    return this.clasz.thisType();
                }
                case 0: {
                    Type.CompoundType compoundType = (Type.CompoundType)type;
                    Type[] typeArray = compoundType.parts;
                    Scope scope = compoundType.members;
                    if (type.symbol() != this.clasz) {
                        return this.map(type);
                    }
                    if (typeArray.length <= 1) {
                        return type;
                    }
                    Symbol symbol = (Symbol)ExpandMixinsPhase.this.access$21().get(this.clasz);
                    if (symbol == null) {
                        int n;
                        for (n = 1; n < typeArray.length && typeArray[n].symbol().isInterface(); ++n) {
                        }
                        if (n == typeArray.length) {
                            return type;
                        }
                        typeArray = Type.cloneArray(typeArray);
                        while (n < typeArray.length) {
                            if (!typeArray[n].symbol().isInterface()) {
                                typeArray[n] = Type.typeRef(typeArray[n].prefix(), (Symbol)ExpandMixinsPhase.this.access$21().get(typeArray[n].symbol()), typeArray[n].typeArgs());
                            }
                            ++n;
                        }
                        return Type.compoundType(typeArray, scope, this.clasz);
                    }
                    if (!$assertionsDisabled && typeArray[typeArray.length - 1].symbol() != symbol) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(type)));
                    }
                    if (typeArray.length == 2) {
                        return type;
                    }
                    for (int i = 1; i < typeArray.length - 1; ++i) {
                        Symbol symbol4;
                        Symbol symbol5 = typeArray[i].symbol();
                        Symbol symbol6 = symbol4 = symbol5.isInterface() ? symbol5 : (Symbol)ExpandMixinsPhase.this.access$21().get(symbol5);
                        if (!$assertionsDisabled && !symbol.isSubClass(symbol4)) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(type)).concat(" - "))).concat(String.valueOf(i)))));
                        }
                    }
                    typeArray = new Type[]{typeArray[0], typeArray[typeArray.length - 1]};
                    return Type.compoundType(typeArray, scope, this.clasz);
                }
            }
            return this.map(type);
        }

        static {
            $assertionsDisabled = !Class.forName("scalac.transformer.ExpandMixinsPhase").desiredAssertionStatus();
        }
    }

    private class TreeExpander
    extends GenTransformer {
        private static final /* synthetic */ boolean $assertionsDisabled;

        public TreeExpander(Global global) {
            super(global);
        }

        public void apply(CompilationUnit compilationUnit) {
            if (compilationUnit.mixinOnly) {
                if (!$assertionsDisabled && !Debug.log("removing unit ".concat(String.valueOf(String.valueOf(compilationUnit))))) {
                    throw new AssertionError();
                }
                compilationUnit.body = Tree.EMPTY_ARRAY;
            } else {
                super.apply(compilationUnit);
            }
        }

        public Tree transform(Tree tree) {
            if (tree.$tag == 10) {
                Symbol symbol = tree.symbol();
                if (symbol.isInterface()) {
                    return super.transform(tree);
                }
                return this.gen.ClassDef(symbol, ExpandMixinsPhase.this.access$19(symbol));
            }
            return super.transform(tree);
        }

        static {
            $assertionsDisabled = !Class.forName("scalac.transformer.ExpandMixinsPhase").desiredAssertionStatus();
        }
    }
}

