/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer;

import scalac.CompilationUnit;
import scalac.Global;
import scalac.ast.Transformer;
import scalac.ast.Tree;
import scalac.symtab.Symbol;

public class OwnerTransformer
extends Transformer {
    protected Symbol currentOwner;

    public OwnerTransformer(Global global) {
        super(global);
    }

    public void apply(CompilationUnit compilationUnit) {
        this.currentOwner = this.global.definitions.ROOT_CLASS;
        compilationUnit.body = this.transform(compilationUnit.body);
    }

    public Tree transform(Tree tree, Symbol symbol) {
        Symbol symbol2 = this.currentOwner;
        this.currentOwner = symbol;
        Tree tree2 = this.transform(tree);
        this.currentOwner = symbol2;
        return tree2;
    }

    public Tree.AbsTypeDef[] transform(Tree.AbsTypeDef[] absTypeDefArray, Symbol symbol) {
        Symbol symbol2 = this.currentOwner;
        this.currentOwner = symbol;
        Tree.AbsTypeDef[] absTypeDefArray2 = this.transform(absTypeDefArray);
        this.currentOwner = symbol2;
        return absTypeDefArray2;
    }

    public Tree.ValDef[][] transform(Tree.ValDef[][] valDefArray, Symbol symbol) {
        Symbol symbol2 = this.currentOwner;
        this.currentOwner = symbol;
        Tree.ValDef[][] valDefArray2 = this.transform(valDefArray);
        this.currentOwner = symbol2;
        return valDefArray2;
    }

    public Tree.Template transform(Tree.Template template, Symbol symbol) {
        Symbol symbol2 = this.currentOwner;
        if (symbol.kind == 3) {
            this.currentOwner = symbol.primaryConstructor();
        }
        Tree[] treeArray = this.transform(template.parents);
        this.currentOwner = symbol;
        Tree[] treeArray2 = this.transformTemplateStats(template.body, template.symbol());
        this.currentOwner = symbol2;
        return this.copy.Template(template, treeArray, treeArray2);
    }

    public Tree[] transformTemplateStats(Tree[] treeArray, Symbol symbol) {
        Tree[] treeArray2 = treeArray;
        for (int i = 0; i < treeArray.length; ++i) {
            Tree tree = this.transformTemplateStat(treeArray[i], symbol);
            if (tree != treeArray[i] && treeArray2 == treeArray) {
                treeArray2 = new Tree[treeArray.length];
                System.arraycopy(treeArray, 0, treeArray2, 0, i);
            }
            treeArray2[i] = tree;
        }
        return treeArray2;
    }

    public Tree transformTemplateStat(Tree tree, Symbol symbol) {
        return this.transform(tree, symbol);
    }

    public Tree transform(Tree tree) {
        switch (tree.$tag) {
            case 24: {
                Tree.PackageDef packageDef = (Tree.PackageDef)tree;
                Tree tree2 = packageDef.packaged;
                Tree.Template template = packageDef.impl;
                return this.copy.PackageDef(tree, this.transform(tree2), this.transform(template, tree2.symbol()));
            }
            case 10: {
                Tree.ClassDef classDef = (Tree.ClassDef)tree;
                Tree.AbsTypeDef[] absTypeDefArray = classDef.tparams;
                Tree.ValDef[][] valDefArray = classDef.vparams;
                Tree tree3 = classDef.tpe;
                Tree.Template template = classDef.impl;
                Symbol symbol = tree.symbol();
                return this.copy.ClassDef(tree, symbol, this.transform(absTypeDefArray, symbol.primaryConstructor()), this.transform(valDefArray, symbol.primaryConstructor()), this.transform(tree3, symbol), this.transform(template, symbol));
            }
            case 22: {
                Tree.ModuleDef moduleDef = (Tree.ModuleDef)tree;
                Tree tree4 = moduleDef.tpe;
                Tree.Template template = moduleDef.impl;
                Symbol symbol = tree.symbol();
                return this.copy.ModuleDef(tree, symbol, this.transform(tree4, symbol), this.transform(template, (Symbol)symbol.moduleClass()));
            }
            case 13: {
                Tree.DefDef defDef = (Tree.DefDef)tree;
                Tree.AbsTypeDef[] absTypeDefArray = defDef.tparams;
                Tree.ValDef[][] valDefArray = defDef.vparams;
                Tree tree5 = defDef.tpe;
                Tree tree6 = defDef.rhs;
                Symbol symbol = tree.symbol();
                return this.copy.DefDef(tree, symbol, this.transform(absTypeDefArray, symbol), this.transform(valDefArray, symbol), this.transform(tree5, symbol), this.transform(tree6, symbol));
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Tree tree7 = valDef.tpe;
                Tree tree8 = valDef.rhs;
                Symbol symbol = tree.symbol();
                return this.copy.ValDef(tree, symbol, this.transform(tree7), this.transform(tree8, symbol));
            }
            case 0: {
                Tree.AbsTypeDef absTypeDef = (Tree.AbsTypeDef)tree;
                Tree tree9 = absTypeDef.rhs;
                Tree tree10 = absTypeDef.lobound;
                Symbol symbol = tree.symbol();
                return this.copy.AbsTypeDef(tree, symbol, this.transform(tree9, symbol), this.transform(tree10, symbol));
            }
            case 1: {
                Tree.AliasTypeDef aliasTypeDef = (Tree.AliasTypeDef)tree;
                Tree.AbsTypeDef[] absTypeDefArray = aliasTypeDef.tparams;
                Tree tree11 = aliasTypeDef.rhs;
                Symbol symbol = tree.symbol();
                return this.copy.AliasTypeDef(tree, symbol, this.transform(absTypeDefArray, symbol), this.transform(tree11, symbol));
            }
        }
        return super.transform(tree);
    }
}

