/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import scala.tools.util.debug.Debug;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.Phase;
import scalac.PhaseDescriptor;
import scalac.ast.GenTransformer;
import scalac.ast.Tree;
import scalac.ast.TreeList;
import scalac.backend.Primitives;
import scalac.symtab.Definitions;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Name;
import scalac.util.Names;

public class TypesAsValuesPhase
extends Phase {
    private final GenTransformer transformer;
    private final HashMap membersToAdd = new HashMap();
    private final HashMap paramsToAdd = new HashMap();
    private final HashMap typeAccessor = new HashMap();
    private final HashMap instantiator = new HashMap();
    private final HashMap lazyParentsClass = new HashMap();
    private final HashMap classInitialiser = new HashMap();
    private final HashMap tConstructor = new HashMap();
    private final HashMap constructorNeed = new HashMap();
    private final Definitions defs;
    private final Primitives prims;
    private final Type.MethodType typeAccessorType;
    private final Type.MethodType lazyForceType;
    private final Symbol ARRAY_CONSTRUCTOR;
    private final TEnv EENV;
    private final Map predefTypes;
    private final Map basicTypes;
    private HashMap ancestorCache;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public TypesAsValuesPhase(Global global, PhaseDescriptor phaseDescriptor) {
        super(global, phaseDescriptor);
        this.defs = this.global.definitions;
        this.prims = this.global.primitives;
        this.ARRAY_CONSTRUCTOR = this.defs.ARRAY_CLASS.primaryConstructor();
        this.EENV = new TEnv();
        this.ancestorCache = new HashMap();
        if (global.runTimeTypes && global.target != Global.TARGET_MSIL) {
            this.transformer = new TV_Transformer(global);
            this.typeAccessorType = new Type.MethodType(new Symbol[0], this.defs.TYPE_TYPE());
            this.lazyForceType = new Type.MethodType(Symbol.EMPTY_ARRAY, this.defs.ARRAY_TYPE(this.defs.SCALACLASSTYPE_TYPE()));
            this.predefTypes = new HashMap();
            this.predefTypes.put(this.defs.DOUBLE_CLASS, this.defs.RTT_DOUBLE());
            this.predefTypes.put(this.defs.FLOAT_CLASS, this.defs.RTT_FLOAT());
            this.predefTypes.put(this.defs.LONG_CLASS, this.defs.RTT_LONG());
            this.predefTypes.put(this.defs.INT_CLASS, this.defs.RTT_INT());
            this.predefTypes.put(this.defs.SHORT_CLASS, this.defs.RTT_SHORT());
            this.predefTypes.put(this.defs.CHAR_CLASS, this.defs.RTT_CHAR());
            this.predefTypes.put(this.defs.BYTE_CLASS, this.defs.RTT_BYTE());
            this.predefTypes.put(this.defs.BOOLEAN_CLASS, this.defs.RTT_BOOLEAN());
            this.predefTypes.put(this.defs.UNIT_CLASS, this.defs.RTT_UNIT());
            this.predefTypes.put(this.defs.ANY_CLASS, this.defs.RTT_ANY());
            this.predefTypes.put(this.defs.ANYVAL_CLASS, this.defs.RTT_ANYVAL());
            this.predefTypes.put(this.defs.ALLREF_CLASS, this.defs.RTT_ALLREF());
            this.predefTypes.put(this.defs.ALL_CLASS, this.defs.RTT_ALL());
            this.basicTypes = new HashMap();
            this.basicTypes.put(this.defs.BOOLEAN_TYPE(), "Z");
            this.basicTypes.put(this.defs.BYTE_TYPE(), "B");
            this.basicTypes.put(this.defs.CHAR_TYPE(), "C");
            this.basicTypes.put(this.defs.DOUBLE_TYPE(), "D");
            this.basicTypes.put(this.defs.FLOAT_TYPE(), "F");
            this.basicTypes.put(this.defs.INT_TYPE(), "I");
            this.basicTypes.put(this.defs.LONG_TYPE(), "J");
            this.basicTypes.put(this.defs.SHORT_TYPE(), "S");
            this.membersToAdd.put(this.defs.ARRAY_CLASS, new Symbol[0]);
            this.paramsToAdd.put(this.ARRAY_CONSTRUCTOR, new Symbol[0]);
            this.ancestorCache.put(this.defs.OBJECT_CLASS, new Ancestor[0][]);
        } else {
            this.transformer = new TV_MiniTransformer(global);
            this.lazyForceType = null;
            this.typeAccessorType = null;
            this.basicTypes = null;
            this.predefTypes = null;
        }
    }

    private Symbol getAccessorSym(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isType()) {
            throw new AssertionError();
        }
        Symbol symbol2 = (Symbol)this.typeAccessor.get(symbol);
        if (symbol2 == null) {
            symbol2 = symbol.owner().newVariable(symbol.pos, symbol.flags, Names.TYPE(symbol));
            symbol2.setInfo(this.defs.TYPE_TYPE());
            this.typeAccessor.put(symbol, symbol2);
        }
        return symbol2;
    }

    private Symbol getInstMethSym(Symbol symbol) {
        Symbol symbol2 = (Symbol)this.instantiator.get(symbol);
        if (symbol2 == null) {
            int n = symbol.pos;
            boolean bl = !this.isNestedClass(symbol);
            Name name = Names.INSTANTIATE(symbol, bl);
            int n2 = symbol.isAbstractType() ? 1 : 0;
            symbol2 = bl ? symbol.newStaticMethod(n, 0, name) : symbol.owner().newMethodOrFunction(n, n2, name);
            Symbol symbol3 = symbol2.newVParam(n, 0, Name.fromString("types"));
            symbol3.setInfo(this.defs.ARRAY_TYPE(this.defs.TYPE_TYPE()));
            Symbol[] symbolArray = new Symbol[]{symbol3};
            symbol2.setInfo(new Type.MethodType(symbolArray, bl ? this.defs.SCALACLASSTYPE_TYPE() : this.defs.TYPE_TYPE()));
            this.instantiator.put(symbol, symbol2);
        }
        return symbol2;
    }

    private Symbol getLazyParentClassSym(Symbol symbol) {
        Symbol symbol2 = (Symbol)this.lazyParentsClass.get(symbol);
        if (symbol2 == null) {
            int n = symbol.pos;
            Name name = Names.LAZYPARENTS(symbol);
            symbol2 = symbol.owner().newClass(n, 0, name);
            Type.CompoundType compoundType = Type.compoundType(new Type[]{this.defs.LAZYPARENTS_TYPE()}, new Scope(), symbol2);
            symbol2.setInfo(compoundType);
            Symbol symbol3 = symbol2.primaryConstructor();
            Symbol symbol4 = symbol3.newVParam(n, 0, Name.fromString("types"));
            symbol4.setInfo(this.defs.ARRAY_TYPE(this.defs.TYPE_TYPE()));
            symbol3.setInfo(new Type.MethodType(new Symbol[]{symbol4}, this.defs.UNIT_TYPE()));
            this.lazyParentsClass.put(symbol, symbol2);
        }
        return symbol2;
    }

    private Symbol getTConstructorSym(Symbol symbol) {
        Symbol symbol2 = (Symbol)this.tConstructor.get(symbol);
        if (symbol2 == null) {
            int n = symbol.pos;
            boolean bl = !this.isNestedClass(symbol);
            Name name = Names.TYPECONSTRUCTOR(symbol, bl);
            symbol2 = bl ? symbol.newStaticField(n, 0, name) : symbol.owner().newFieldOrVariable(n, 0, name);
            symbol2.setInfo(this.defs.TYPECONSTRUCTOR_TYPE());
            this.tConstructor.put(symbol, symbol2);
        }
        return symbol2;
    }

    private Symbol getClassInitSym(Symbol symbol) {
        Symbol symbol2 = (Symbol)this.classInitialiser.get(symbol);
        if (symbol2 == null) {
            int n = symbol.pos;
            symbol2 = symbol.newStaticMethod(n, 0, Names.CLASS_CONSTRUCTOR);
            symbol2.setInfo(new Type.MethodType(Symbol.EMPTY_ARRAY, this.defs.UNIT_TYPE()));
            this.classInitialiser.put(symbol, symbol2);
        }
        return symbol2;
    }

    private Symbol[] membersToAdd(Symbol symbol) {
        Symbol[] symbolArray = (Symbol[])this.membersToAdd.get(symbol);
        if (symbolArray == null) {
            HashSet<Symbol> hashSet = new HashSet<Symbol>();
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
            Scope.SymbolIterator symbolIterator = symbol.members().iterator();
            while (symbolIterator.hasNext()) {
                Symbol symbol2 = symbolIterator.next();
                if (symbol2.isModule()) {
                    symbol2 = symbol2.moduleClass();
                }
                if (!hashSet.add(symbol2)) continue;
                if (symbol2.isClass()) {
                    arrayList.add(this.getTConstructorSym(symbol2));
                    arrayList.add(this.getInstMethSym(symbol2));
                    continue;
                }
                if (!symbol2.isType()) continue;
                arrayList.add(this.getInstMethSym(symbol2));
            }
            if (this.needsInstantiationMethod(symbol)) {
                arrayList.add(this.getTConstructorSym(symbol));
                arrayList.add(this.getClassInitSym(symbol));
                arrayList.add(this.getInstMethSym(symbol));
            }
            symbolArray = arrayList.toArray(new Symbol[arrayList.size()]);
            this.membersToAdd.put(symbol, symbolArray);
        }
        return symbolArray;
    }

    private Symbol[] paramsToAdd(Symbol symbol) {
        Symbol[] symbolArray = (Symbol[])this.paramsToAdd.get(symbol);
        if (symbolArray == null) {
            Symbol[] symbolArray2 = symbol.typeParams();
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
            for (int i = 0; i < symbolArray2.length; ++i) {
                arrayList.add(this.getAccessorSym(symbolArray2[i]));
            }
            symbolArray = arrayList.toArray(new Symbol[arrayList.size()]);
            this.paramsToAdd.put(symbol, symbolArray);
        }
        return symbolArray;
    }

    private boolean monoPrimitive(Symbol symbol) {
        return symbol.isJava() || symbol == this.ARRAY_CONSTRUCTOR || symbol == this.defs.OBJECT_SYNCHRONIZED || symbol == this.defs.ANY_IS || symbol == this.defs.ANY_IS_ERASED || symbol == this.defs.ANY_AS || symbol == this.defs.ANY_AS_ERASED;
    }

    public Type transformInfo(Symbol symbol, Type type) {
        if (!this.global.runTimeTypes) {
            return type;
        }
        if (symbol.isClass()) {
            Symbol[] symbolArray = this.membersToAdd(symbol);
            if (symbolArray.length == 0) {
                return type;
            }
            Scope scope = new Scope(symbol.members());
            for (int i = 0; i < symbolArray.length; ++i) {
                scope.enterOrOverload(symbolArray[i]);
            }
            return Type.compoundType(type.parents(), scope, symbol);
        }
        if (type.typeParams().length > 0 && !this.monoPrimitive(symbol)) {
            if (type.$tag == 5) {
                Type.PolyType polyType = (Type.PolyType)type;
                if (polyType.result.$tag == 3) {
                    Type.MethodType methodType = (Type.MethodType)polyType.result;
                    Symbol[] symbolArray = polyType.tparams;
                    Symbol[] symbolArray2 = methodType.vparams;
                    Type type2 = methodType.result;
                    LinkedList<Symbol> linkedList = new LinkedList<Symbol>(Arrays.asList(this.paramsToAdd(symbol)));
                    linkedList.addAll(Arrays.asList(symbolArray2));
                    Symbol[] symbolArray3 = linkedList.toArray(new Symbol[linkedList.size()]);
                    return new Type.PolyType(symbolArray, new Type.MethodType(symbolArray3, type2));
                }
            }
            throw Debug.abort("unexpected type: ", type);
        }
        return type;
    }

    private boolean isTrivial(Type type) {
        switch (type.$tag) {
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Symbol symbol = typeRef.sym;
                Type[] typeArray = typeRef.args;
                if (symbol == this.defs.ARRAY_CLASS) {
                    return this.isTrivial(typeArray[0]);
                }
                return symbol.isStatic() && typeArray.length == 0;
            }
            case 6: {
                return false;
            }
            case 7: {
                return false;
            }
            case 0: {
                return false;
            }
        }
        throw Debug.abort("unexpected type", type);
    }

    private boolean isStronglyTrivial(Type type) {
        if (this.isTrivial(type)) {
            Type[] typeArray = type.parents();
            for (int i = 0; i < typeArray.length; ++i) {
                if (this.isStronglyTrivial(typeArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isNestedClass(Symbol symbol) {
        return !symbol.owner().isPackageClass();
    }

    private boolean needsInstantiationMethod(Symbol symbol) {
        return !this.isNestedClass(symbol) && !this.isStronglyTrivial(symbol.type());
    }

    public void apply(CompilationUnit compilationUnit) {
        this.transformer.apply(compilationUnit);
    }

    private Tree qualifierOf(Tree tree) {
        if (tree.$tag == 27) {
            Tree.Select select = (Tree.Select)tree;
            Tree tree2 = select.qualifier;
            return tree2;
        }
        throw Debug.abort("cannot extract qualifier from ", tree);
    }

    private void debugPrintAncestor(Symbol symbol, Ancestor[][] ancestorArray) {
        System.out.println("ancestor for ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))));
        for (int i = 0; i < ancestorArray.length; ++i) {
            System.out.print(String.valueOf(String.valueOf("  [".concat(String.valueOf(i)))).concat("] "));
            for (int j = 0; j < ancestorArray[i].length; ++j) {
                if (j > 0) {
                    System.out.print("      ");
                }
                System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(Debug.show(ancestorArray[i][j].symbol)))))).concat("/par"))).concat(String.valueOf(ancestorArray[i][j].parentIndex)))).concat("/pos"))).concat(String.valueOf(ancestorArray[i][j].position)));
            }
            if (ancestorArray[i].length != 0) continue;
            System.out.println("<empty>");
        }
    }

    final /* synthetic */ Tree access$41(Tree tree) {
        return this.qualifierOf(tree);
    }

    final /* synthetic */ boolean access$33(Symbol symbol) {
        return this.needsInstantiationMethod(symbol);
    }

    final /* synthetic */ boolean access$44(Symbol symbol) {
        return this.isNestedClass(symbol);
    }

    final /* synthetic */ boolean access$46(Type type) {
        return this.isStronglyTrivial(type);
    }

    final /* synthetic */ boolean access$42(Type type) {
        return this.isTrivial(type);
    }

    final /* synthetic */ boolean access$43(Symbol symbol) {
        return this.monoPrimitive(symbol);
    }

    final /* synthetic */ Symbol access$35(Symbol symbol) {
        return this.getClassInitSym(symbol);
    }

    final /* synthetic */ Symbol access$34(Symbol symbol) {
        return this.getTConstructorSym(symbol);
    }

    final /* synthetic */ Symbol access$37(Symbol symbol) {
        return this.getLazyParentClassSym(symbol);
    }

    final /* synthetic */ Symbol access$36(Symbol symbol) {
        return this.getInstMethSym(symbol);
    }

    final /* synthetic */ Symbol access$49(Symbol symbol) {
        return this.getAccessorSym(symbol);
    }

    final /* synthetic */ HashMap access$51() {
        return this.ancestorCache;
    }

    final /* synthetic */ Map access$50() {
        return this.basicTypes;
    }

    final /* synthetic */ Map access$48() {
        return this.predefTypes;
    }

    final /* synthetic */ TEnv access$38() {
        return this.EENV;
    }

    final /* synthetic */ Symbol access$40() {
        return this.ARRAY_CONSTRUCTOR;
    }

    final /* synthetic */ Type.MethodType access$45() {
        return this.lazyForceType;
    }

    final /* synthetic */ HashMap access$47() {
        return this.constructorNeed;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.transformer.TypesAsValuesPhase").desiredAssertionStatus();
    }

    private class TV_MiniTransformer
    extends GenTransformer {
        private final Definitions defs;
        private static final /* synthetic */ boolean $assertionsDisabled;

        public TV_MiniTransformer(Global global) {
            super(global);
            this.defs = global.definitions;
        }

        public Tree transform(Tree tree) {
            if (tree.$tag == 4) {
                Tree.Apply apply = (Tree.Apply)tree;
                if (apply.fun.$tag == 37) {
                    Tree.TypeApply typeApply = (Tree.TypeApply)apply.fun;
                    Tree tree2 = typeApply.fun;
                    Tree[] treeArray = typeApply.args;
                    Tree[] treeArray2 = apply.args;
                    Symbol symbol = tree2.symbol();
                    if (symbol == this.defs.ANY_IS || symbol == this.defs.ANY_AS) {
                        if (!$assertionsDisabled && treeArray2.length != 0) {
                            throw new AssertionError();
                        }
                        Symbol symbol2 = symbol == this.defs.ANY_AS ? this.defs.ANY_AS_ERASED : this.defs.ANY_IS_ERASED;
                        return this.gen.mkApplyTV(tree.pos, (Tree)this.gen.Select(tree2.pos, this.transform(TypesAsValuesPhase.this.access$41(tree2)), symbol2), treeArray, treeArray2);
                    }
                    return super.transform(tree);
                }
            }
            return super.transform(tree);
        }

        final /* synthetic */ Definitions access$39() {
            return this.defs;
        }

        static {
            $assertionsDisabled = !Class.forName("scalac.transformer.TypesAsValuesPhase").desiredAssertionStatus();
        }
    }

    private class TV_Transformer
    extends TV_MiniTransformer {
        private Symbol currentOwner;
        private TreeList additionalTopLevelClasses;
        private final int VARIANT = -1073741824;
        private static final /* synthetic */ boolean $assertionsDisabled;

        public TV_Transformer(Global global) {
            super(global);
        }

        public void apply(CompilationUnit compilationUnit) {
            compilationUnit.global.log("transforming ".concat(String.valueOf(String.valueOf(compilationUnit))));
            this.additionalTopLevelClasses = new TreeList();
            TreeList treeList = new TreeList(this.transform(compilationUnit.body));
            treeList.append(this.additionalTopLevelClasses);
            this.additionalTopLevelClasses = null;
            compilationUnit.body = treeList.toArray();
        }

        public Tree transform(Tree tree) {
            switch (tree.$tag) {
                case 10: {
                    Tree.ClassDef classDef = (Tree.ClassDef)tree;
                    Tree.Template template = classDef.impl;
                    Symbol symbol = tree.symbol();
                    TreeList treeList = new TreeList();
                    if (TypesAsValuesPhase.this.access$33(symbol)) {
                        boolean bl = this.isCyclic(symbol);
                        Symbol symbol2 = TypesAsValuesPhase.this.access$34(symbol);
                        treeList.append(this.tConstructorVal(symbol, symbol2));
                        Symbol symbol3 = TypesAsValuesPhase.this.access$35(symbol);
                        treeList.append(this.classInitialiser(symbol, symbol3, symbol2));
                        Symbol symbol4 = TypesAsValuesPhase.this.access$36(symbol);
                        treeList.append(this.instantiatorBody(symbol, symbol4, bl));
                        if (bl) {
                            Symbol symbol5 = TypesAsValuesPhase.this.access$37(symbol);
                            Tree tree2 = this.lazyParentsClass(symbol, symbol5);
                            this.additionalTopLevelClasses.append(tree2);
                        }
                    }
                    treeList.append(this.transformStatements(template.body, template.symbol()));
                    return this.gen.ClassDef(symbol, this.transform(template.parents, symbol.primaryConstructor()), template.symbol(), treeList.toArray());
                }
                case 13: {
                    Tree.DefDef defDef = (Tree.DefDef)tree;
                    Tree tree3 = defDef.rhs;
                    Symbol symbol = this.getSymbolFor(tree);
                    if (symbol.name == Names.getScalaType && symbol.isSynthetic()) {
                        return this.gen.DefDef(symbol, this.scalaClassType(symbol.pos, symbol.owner().type(), symbol, TypesAsValuesPhase.this.access$38()));
                    }
                    return this.gen.DefDef(symbol, this.transform(tree3, symbol));
                }
                case 8: {
                    Tree.Block block = (Tree.Block)tree;
                    Tree[] treeArray = block.stats;
                    Tree tree4 = block.expr;
                    return this.gen.Block(tree.pos, this.transformStatements(treeArray), this.transform(tree4));
                }
                case 40: {
                    Tree tree5;
                    Tree.ValDef valDef = (Tree.ValDef)tree;
                    if (valDef.rhs.$tag == 21) {
                        tree5 = (Tree.Literal)valDef.rhs;
                        if (((Tree.Literal)tree5).value.$tag == 12) {
                            Tree tree6 = valDef.tpe;
                            Symbol symbol = this.getSymbolFor(tree);
                            Tree tree7 = this.gen.mkRef(tree.pos, this.typeAsValue(tree.pos, tree6.type, this.currentOwner, TypesAsValuesPhase.this.access$38()), this.access$39().TYPE_DEFAULTVALUE());
                            Tree tree8 = this.gen.mkApply__(tree.pos, tree7);
                            return this.gen.ValDef(symbol, tree8);
                        }
                    }
                    tree5 = valDef.rhs;
                    Symbol symbol = this.getSymbolFor(tree);
                    return this.gen.ValDef(symbol, this.transform(tree5, symbol));
                }
                case 23: {
                    Tree.New new_ = (Tree.New)tree;
                    if (new_.init.$tag != 4) break;
                    Tree.Apply apply = (Tree.Apply)new_.init;
                    if (apply.fun.$tag != 37) break;
                    Tree.TypeApply typeApply = (Tree.TypeApply)apply.fun;
                    Tree tree9 = typeApply.fun;
                    Tree[] treeArray = typeApply.args;
                    Tree[] treeArray2 = apply.args;
                    if (tree9.symbol() == TypesAsValuesPhase.this.access$40() && treeArray[0].type().symbol().isParameter()) {
                        if (!$assertionsDisabled && treeArray.length != 1) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && treeArray2.length != 1) {
                            throw new AssertionError();
                        }
                        Tree tree10 = this.gen.mkRef(tree.pos, this.typeAsValue(treeArray[0].pos, treeArray[0].type(), this.currentOwner, TypesAsValuesPhase.this.access$38()), this.access$39().TYPE_NEWARRAY());
                        return this.gen.mkApplyTV(tree10, treeArray, treeArray2);
                    }
                    return super.transform(tree);
                }
                case 4: {
                    Tree.Apply apply = (Tree.Apply)tree;
                    if (apply.fun.$tag != 37) break;
                    Tree.TypeApply typeApply = (Tree.TypeApply)apply.fun;
                    Tree tree11 = typeApply.fun;
                    Tree[] treeArray = typeApply.args;
                    Tree[] treeArray3 = apply.args;
                    Symbol symbol = tree11.symbol();
                    if (symbol == this.access$39().ANY_IS) {
                        if (!($assertionsDisabled || treeArray.length == 1 && treeArray3.length == 0)) {
                            throw new AssertionError();
                        }
                        Type type = treeArray[0].type;
                        Tree tree12 = this.transform(TypesAsValuesPhase.this.access$41(tree11));
                        return TypesAsValuesPhase.this.access$42(type) && !this.isSpecial(type) ? super.transform(tree) : this.genInstanceTest(tree.pos, tree12, type);
                    }
                    if (symbol == this.access$39().ANY_AS) {
                        if (!($assertionsDisabled || treeArray.length == 1 && treeArray3.length == 0)) {
                            throw new AssertionError();
                        }
                        Type type = treeArray[0].type;
                        Tree tree13 = this.transform(TypesAsValuesPhase.this.access$41(tree11));
                        return TypesAsValuesPhase.this.access$42(type) && !this.isSpecial(type) ? super.transform(tree) : this.genTypeCast(tree.pos, tree13, type);
                    }
                    if (!TypesAsValuesPhase.this.access$43(symbol)) {
                        Tree[] treeArray4 = this.transform(treeArray3);
                        Tree[] treeArray5 = new Tree[treeArray4.length + treeArray.length];
                        for (int i = 0; i < treeArray.length; ++i) {
                            treeArray5[i] = this.typeAsValue(treeArray[i].pos, treeArray[i].type, this.currentOwner, TypesAsValuesPhase.this.access$38());
                        }
                        System.arraycopy(treeArray4, 0, treeArray5, treeArray.length, treeArray4.length);
                        return this.gen.mkApplyTV(tree.pos, this.transform(tree11), treeArray, treeArray5);
                    }
                    return super.transform(tree);
                }
            }
            return super.transform(tree);
        }

        private Tree[] transformStatements(Tree[] treeArray) {
            ArrayList<Tree> arrayList = new ArrayList<Tree>();
            int n = 0;
            for (int i = 0; i < treeArray.length; ++i) {
                Tree tree = treeArray[i];
                switch (tree.$tag) {
                    case 10: {
                        Symbol symbol = tree.symbol();
                        boolean bl = this.isCyclic(symbol);
                        Symbol symbol2 = TypesAsValuesPhase.this.access$34(symbol);
                        arrayList.add(n++, this.tConstructorVal(symbol, symbol2));
                        Symbol symbol3 = TypesAsValuesPhase.this.access$36(symbol);
                        arrayList.add(this.instantiatorBody(symbol, symbol3, bl));
                        if (!bl) break;
                        Symbol symbol4 = TypesAsValuesPhase.this.access$37(symbol);
                        arrayList.add(this.lazyParentsClass(symbol, symbol4));
                        break;
                    }
                    case 0: {
                        Symbol symbol = tree.symbol();
                        Symbol symbol5 = TypesAsValuesPhase.this.access$36(symbol);
                        arrayList.add(this.typeAccessorBody(symbol, symbol5));
                        break;
                    }
                    case 1: {
                        Symbol symbol = tree.symbol();
                        Symbol symbol6 = TypesAsValuesPhase.this.access$36(symbol);
                        arrayList.add(this.typeAccessorBody(symbol, symbol6));
                    }
                }
                arrayList.add(this.transform(tree));
            }
            return arrayList.toArray(new Tree[arrayList.size()]);
        }

        private Tree[] transformStatements(Tree[] treeArray, Symbol symbol) {
            Symbol symbol2 = this.currentOwner;
            this.currentOwner = symbol;
            Tree[] treeArray2 = this.transformStatements(treeArray);
            this.currentOwner = symbol2;
            return treeArray2;
        }

        private Tree transform(Tree tree, Symbol symbol) {
            Symbol symbol2 = this.currentOwner;
            this.currentOwner = symbol;
            Tree tree2 = this.transform(tree);
            this.currentOwner = symbol2;
            return tree2;
        }

        private Tree[] transform(Tree[] treeArray, Symbol symbol) {
            Symbol symbol2 = this.currentOwner;
            this.currentOwner = symbol;
            Tree[] treeArray2 = this.transform(treeArray);
            this.currentOwner = symbol2;
            return treeArray2;
        }

        private int level(Symbol symbol) {
            Symbol symbol2 = symbol.parents()[0].symbol();
            if (!$assertionsDisabled && symbol2 == Symbol.NONE) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(symbol)));
            }
            if (symbol2 == this.access$39().ANY_CLASS) {
                return 0;
            }
            return 1 + this.level(symbol2);
        }

        private Tree.DefDef typeAccessorBody(Symbol symbol, Symbol symbol2) {
            Tree tree;
            if (symbol.isAbstractType()) {
                tree = Tree.Empty;
            } else if (symbol.isClass()) {
                tree = this.scalaClassType(symbol.pos, symbol.type(), symbol2, TypesAsValuesPhase.this.access$38());
            } else {
                Symbol[] symbolArray = symbol2.valueParams();
                int n = symbol2.pos;
                HashMap<Symbol, Integer> hashMap = new HashMap<Symbol, Integer>();
                Symbol[] symbolArray2 = symbol.typeParams();
                for (int i = 0; i < symbolArray2.length; ++i) {
                    hashMap.put(symbolArray2[i], new Integer(i));
                }
                17 var9_9 = new 17(hashMap, n, symbolArray, this);
                tree = this.typeAsValue(symbol.pos, symbol.type(), symbol2, var9_9);
            }
            return this.gen.DefDef(symbol2, tree);
        }

        private Tree tConstructorVal(Symbol symbol, Symbol symbol2) {
            return this.gen.ValDef(symbol2, symbol2.isStatic() ? Tree.Empty : this.tConstructorRHS(symbol2.pos, symbol, symbol2));
        }

        private Tree classInitialiser(Symbol symbol, Symbol symbol2, Symbol symbol3) {
            if (symbol3.isStatic()) {
                int n = symbol3.pos;
                Tree tree = this.tConstructorRHS(n, symbol, symbol2);
                Tree.Assign assign = this.gen.Assign(n, this.gen.Ident(n, symbol3), tree);
                return this.gen.DefDef(symbol2, assign);
            }
            return Tree.Empty;
        }

        private Tree tConstructorRHS(int n, Symbol symbol, Symbol symbol2) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Symbol[] symbolArray = symbol.typeParams();
            for (int i = 0; i < symbolArray.length; ++i) {
                if ((symbolArray[i].flags & 0x40000000) != 0) {
                    ++n4;
                    continue;
                }
                if ((symbolArray[i].flags & Integer.MIN_VALUE) != 0) {
                    ++n3;
                    continue;
                }
                ++n2;
            }
            Ancestor[][] ancestorArray = this.computeAncestors(symbol);
            int[] nArray = this.getAncestorCode(ancestorArray);
            Tree tree = TypesAsValuesPhase.this.access$44(symbol) ? (symbol.owner().isClass() ? this.gen.This(n, symbol.owner()) : this.gen.mkGlobalRef(n, this.access$39().TYPECONSTRUCTOR_FUNCTIONOUTER())) : this.gen.mkNullLit(n);
            Tree[] treeArray = new Tree[]{this.gen.mkIntLit(n, this.level(symbol)), this.gen.mkSymbolNameLit(n, symbol), tree, this.gen.mkIntLit(n, n2), this.gen.mkIntLit(n, n3), this.gen.mkIntLit(n, n4), this.gen.mkIntLit(n, ancestorArray.length), nArray.length == 0 ? this.gen.mkNullLit(n) : this.mkNewIntLitArray(n, this.getAncestorCode(ancestorArray), symbol2)};
            Symbol symbol3 = this.access$39().TYPECONSTRUCTOR_CLASS.primaryConstructor();
            Tree tree2 = this.gen.mkApply_V(n, this.gen.mkGlobalRef(n, symbol3), treeArray);
            return this.gen.New(n, tree2);
        }

        private Tree mkNewIntLitArray(int n, int[] nArray, Symbol symbol) {
            Tree[] treeArray = new Tree[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                treeArray[i] = this.gen.mkIntLit(n, nArray[i]);
            }
            return this.gen.mkNewArray(n, this.access$39().INT_TYPE(), treeArray, symbol);
        }

        private Tree lazyParentsClass(Symbol symbol, Symbol symbol2) {
            int n = symbol.pos;
            Symbol symbol3 = symbol2.primaryConstructor().valueParams()[0];
            Symbol symbol4 = symbol2.newMethod(n, 0, Names.force);
            symbol4.setInfo(TypesAsValuesPhase.this.access$45());
            symbol2.members().enter(symbol4);
            Tree.DefDef defDef = this.gen.DefDef(symbol4, this.parentsArray(n, symbol, symbol3, symbol4));
            return this.gen.ClassDef(symbol2, new Tree[]{defDef});
        }

        private Tree.DefDef instantiatorBody(Symbol symbol, Symbol symbol2, boolean bl) {
            int n = symbol.pos;
            Symbol symbol3 = symbol2.valueParams()[0];
            Tree[] cfr_ignored_0 = new Tree[2];
            Tree.Select select = this.gen.Select(n, this.gen.mkLocalRef(n, TypesAsValuesPhase.this.access$34(symbol)), this.access$39().TYPECONSTRUCTOR_GETINSTANTIATION());
            Tree[] treeArray = new Tree[]{this.gen.mkLocalRef(n, symbol3)};
            Symbol symbol4 = symbol2.newVariable(n, 0, Name.fromString("inst"));
            symbol4.setInfo(this.access$39().SCALACLASSTYPE_TYPE());
            Tree.ValDef valDef = this.gen.ValDef(symbol4, this.gen.mkApply_V(n, select, treeArray));
            Tree tree = this.gen.mkApply_V(n, this.gen.Select(n, this.gen.mkLocalRef(n, symbol4), this.access$39().ANY_BANGEQ), new Tree[]{this.gen.mkNullLit(n)});
            Tree tree2 = this.gen.mkLocalRef(n, symbol4);
            Tree tree3 = bl ? this.lazyInstantiateCall(n, symbol, symbol3) : this.strictInstantiateCall(n, symbol, symbol3, symbol2);
            Tree.If if_ = this.gen.If(n, tree, tree2, tree3, this.access$39().SCALACLASSTYPE_TYPE());
            return this.gen.DefDef(symbol2, this.gen.mkBlock(n, valDef, (Tree)if_));
        }

        private Tree strictInstantiateCall(int n, Symbol symbol, Symbol symbol2, Symbol symbol3) {
            Tree.Select select = this.gen.Select(n, this.gen.mkLocalRef(n, TypesAsValuesPhase.this.access$34(symbol)), this.access$39().TYPECONSTRUCTOR_INSTANTIATE());
            Tree[] treeArray = new Tree[]{this.gen.mkLocalRef(n, symbol2), this.parentsArray(n, symbol, symbol2, symbol3)};
            return this.gen.mkApply_V(n, select, treeArray);
        }

        private Tree lazyInstantiateCall(int n, Symbol symbol, Symbol symbol2) {
            Tree.Select select = this.gen.Select(n, this.gen.mkLocalRef(n, TypesAsValuesPhase.this.access$34(symbol)), this.access$39().TYPECONSTRUCTOR_INSTANTIATE());
            Symbol symbol3 = TypesAsValuesPhase.this.access$37(symbol);
            Tree tree = this.gen.mkPrimaryConstructorLocalRef(n, symbol3);
            Tree[] treeArray = new Tree[]{this.gen.mkLocalRef(n, symbol2)};
            Tree[] treeArray2 = new Tree[]{this.gen.mkLocalRef(n, symbol2), this.gen.New(n, this.gen.mkApply_V(tree, treeArray))};
            return this.gen.mkApply_V(n, select, treeArray2);
        }

        private Tree parentsArray(int n, Symbol symbol, Symbol symbol2, Symbol symbol3) {
            HashMap<Symbol, Integer> hashMap = new HashMap<Symbol, Integer>();
            Symbol[] symbolArray = symbol.typeParams();
            for (int i = 0; i < symbolArray.length; ++i) {
                hashMap.put(symbolArray[i], new Integer(i));
            }
            18 var8_8 = new 18(hashMap, n, symbol2, symbolArray, this);
            Type[] typeArray = symbol.parents();
            TreeList treeList = new TreeList();
            for (int i = 0; i < typeArray.length; ++i) {
                Type type = typeArray[i];
                if (TypesAsValuesPhase.this.access$46(type)) continue;
                treeList.append(this.typeAsValue(n, type, symbol3, var8_8));
            }
            boolean bl = treeList.length() == 0;
            return bl ? this.gen.mkGlobalRef(n, this.access$39().SCALACLASSTYPE_EMPTYARRAY()) : this.gen.mkNewArray(n, this.access$39().SCALACLASSTYPE_TYPE(), treeList.toArray(), symbol3);
        }

        private Tree genInstanceTest(int n, Tree tree, Type type) {
            Tree tree2 = this.typeAsValue(n, type, this.currentOwner, TypesAsValuesPhase.this.access$38());
            if (this.isKnowClassType(type)) {
                Symbol symbol = this.currentOwner.newVariable(n, 1024, Names.LOCAL(this.currentOwner));
                symbol.setType(tree.type);
                Tree.ValDef valDef = this.gen.ValDef(symbol, tree);
                Tree tree3 = this.gen.mkIsInstanceOf(n, this.gen.mkLocalRef(n, symbol), type, true);
                Symbol symbol2 = this.access$39().CLASSTYPE_ISNONTRIVIALINSTANCE();
                Tree tree4 = this.gen.mkAsInstanceOf(n, tree2, this.access$39().CLASSTYPE_TYPE(), true);
                Tree tree5 = this.gen.mkApply_V(n, this.gen.Select(n, tree4, symbol2), new Tree[]{this.gen.mkLocalRef(n, symbol)});
                Tree tree6 = this.gen.mkApply_V(n, this.gen.Select(n, tree3, this.access$39().BOOLEAN_AND()), new Tree[]{tree5});
                return this.gen.mkBlock(n, valDef, tree6);
            }
            Tree.Select select = this.gen.Select(n, tree2, this.access$39().TYPE_ISINSTANCE());
            return this.gen.mkApply_V(n, select, new Tree[]{tree});
        }

        private Tree genTypeCast(int n, Tree tree, Type type) {
            Tree tree2 = this.typeAsValue(n, type, this.currentOwner, TypesAsValuesPhase.this.access$38());
            Tree.Select select = this.gen.Select(n, tree2, this.access$39().TYPE_CAST());
            Tree tree3 = this.gen.mkApply_V(n, select, new Tree[]{tree});
            return this.gen.mkAsInstanceOf(n, tree3, type);
        }

        private boolean isSpecial(Type type) {
            if (type.$tag == 8) {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Symbol symbol = typeRef.sym;
                return symbol == this.access$39().ANY_CLASS || symbol == this.access$39().ANYVAL_CLASS || symbol == this.access$39().ALLREF_CLASS || symbol == this.access$39().ALL_CLASS;
            }
            return false;
        }

        private boolean isKnowClassType(Type type) {
            if (type.$tag == 8) {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Symbol symbol = typeRef.sym;
                return symbol != this.access$39().ARRAY_CLASS && !symbol.isParameter();
            }
            return false;
        }

        private void addConstructorsNeededBy(HashSet hashSet, Type type, HashSet hashSet2) {
            switch (type.$tag) {
                case 8: {
                    Type.TypeRef typeRef = (Type.TypeRef)type;
                    Symbol symbol = typeRef.sym;
                    Type[] typeArray = typeRef.args;
                    if (symbol.isParameter()) break;
                    hashSet2.add(symbol);
                    hashSet2.addAll(this.constructorsNeededBy(hashSet, symbol));
                    for (int i = 0; i < typeArray.length; ++i) {
                        this.addConstructorsNeededBy(hashSet, typeArray[i], hashSet2);
                    }
                    break;
                }
                case 0: {
                    Type.CompoundType compoundType = (Type.CompoundType)type;
                    Type[] typeArray = compoundType.parts;
                    for (int i = 0; i < typeArray.length; ++i) {
                        this.addConstructorsNeededBy(hashSet, typeArray[i], hashSet2);
                    }
                    break;
                }
            }
        }

        private HashSet constructorsNeededBy(HashSet hashSet, Symbol symbol) {
            HashSet hashSet2 = new HashSet();
            if (hashSet.add(symbol)) {
                Type[] typeArray = symbol.parents();
                for (int i = 0; i < typeArray.length; ++i) {
                    this.addConstructorsNeededBy(hashSet, typeArray[i], hashSet2);
                }
            }
            return hashSet2;
        }

        private HashSet constructorsNeededBy(Symbol symbol) {
            HashSet hashSet = (HashSet)TypesAsValuesPhase.this.access$47().get(symbol);
            if (hashSet == null) {
                hashSet = this.constructorsNeededBy(new HashSet(), symbol);
                TypesAsValuesPhase.this.access$47().put(symbol, hashSet);
            }
            return hashSet;
        }

        private boolean isCyclic(Symbol symbol) {
            HashSet hashSet = this.constructorsNeededBy(symbol);
            if (hashSet.contains(symbol)) {
                return true;
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Symbol symbol2 = (Symbol)iterator.next();
                if (!symbol2.isAbstractType()) continue;
                return true;
            }
            return false;
        }

        private Tree typeAsValue(int n, Type type, Symbol symbol, TEnv tEnv) {
            switch (type.$tag) {
                case 1: {
                    Type.ConstantType constantType = (Type.ConstantType)type;
                    Type type2 = constantType.base;
                    return this.typeAsValue(n, type2, symbol, tEnv);
                }
                case 8: {
                    Type.TypeRef typeRef = (Type.TypeRef)type;
                    Type type3 = typeRef.pre;
                    Symbol symbol2 = typeRef.sym;
                    Type[] typeArray = typeRef.args;
                    if (tEnv.definesVar(symbol2)) {
                        if (!$assertionsDisabled && typeArray.length != 0) {
                            throw new AssertionError();
                        }
                        return tEnv.treeForVar(symbol2);
                    }
                    if (symbol2 == this.access$39().ARRAY_CLASS) {
                        if (!$assertionsDisabled && typeArray.length != 1) {
                            throw new AssertionError();
                        }
                        return this.arrayType(n, typeArray[0], symbol, tEnv);
                    }
                    if (TypesAsValuesPhase.this.access$48().containsKey(symbol2)) {
                        return this.gen.mkGlobalRef(n, (Symbol)TypesAsValuesPhase.this.access$48().get(symbol2));
                    }
                    if (symbol2.isJava()) {
                        if (!$assertionsDisabled && typeArray.length > 1) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol2))).concat(" "))).concat(String.valueOf(typeArray.length)))));
                        }
                        return this.javaClassType(n, symbol2);
                    }
                    if (!symbol2.isParameter()) {
                        return this.scalaClassType(n, type, symbol, tEnv);
                    }
                    if (!$assertionsDisabled && this.isValuePrefix(type3)) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(type)));
                    }
                    return this.gen.mkLocalRef(n, TypesAsValuesPhase.this.access$49(symbol2));
                }
                case 6: {
                    return this.singleType(n, (Type.SingleType)type);
                }
                case 7: {
                    Type.ThisType thisType = (Type.ThisType)type;
                    Symbol symbol3 = thisType.sym;
                    return this.thisType(n, symbol3);
                }
                case 0: {
                    Type.CompoundType compoundType = (Type.CompoundType)type;
                    Type[] typeArray = compoundType.parts;
                    Scope scope = compoundType.members;
                    return this.compoundType(n, typeArray, scope, symbol, tEnv);
                }
            }
            throw Debug.abortIllegalCase(type);
        }

        private Tree arrayType(int n, Type type, Symbol symbol, TEnv tEnv) {
            Type type2 = type;
            int n2 = 1;
            while (type2.symbol() == this.access$39().ARRAY_CLASS) {
                type2 = type2.typeArgs()[0];
                ++n2;
            }
            if (TypesAsValuesPhase.this.access$42(type)) {
                Tree tree = TypesAsValuesPhase.this.access$50().containsKey(type) ? this.gen.mkStringLit(n, (String)TypesAsValuesPhase.this.access$50().get(type)) : this.gen.mkSymbolNameLit(n, type2.symbol());
                Tree tree2 = this.gen.mkGlobalRef(n, this.access$39().JAVACLASSTYPE_JAVAARRAYTYPE());
                Tree[] treeArray = new Tree[]{tree, this.gen.mkIntLit(n, n2)};
                return this.gen.mkApply_V(tree2, treeArray);
            }
            Tree tree = this.gen.mkGlobalRef(n, this.access$39().JAVAREFARRAYTYPE_JAVAREFARRAYTYPE());
            Tree[] treeArray = new Tree[]{this.typeAsValue(n, type, symbol, tEnv), this.gen.mkIntLit(n, n2)};
            return this.gen.mkApply_V(tree, treeArray);
        }

        private Tree javaClassType(int n, Symbol symbol) {
            Tree tree = this.gen.mkGlobalRef(n, this.access$39().JAVACLASSTYPE_JAVACLASSTYPE());
            Tree tree2 = this.gen.mkSymbolNameLit(n, symbol);
            Tree[] treeArray = new Tree[]{tree2};
            return this.gen.mkApply_V(tree, treeArray);
        }

        private Tree thisType(int n, Symbol symbol) {
            Tree tree = this.gen.mkPrimaryConstructorGlobalRef(n, this.access$39().SINGLETYPE_CLASS);
            Tree[] treeArray = new Tree[]{this.gen.This(n, symbol)};
            return this.gen.New(n, this.gen.mkApply_V(tree, treeArray));
        }

        private Tree singleType(int n, Type.SingleType singleType) {
            Tree tree = this.gen.mkPrimaryConstructorGlobalRef(n, this.access$39().SINGLETYPE_CLASS);
            Tree[] treeArray = new Tree[]{this.gen.mkQualifier(n, singleType)};
            return this.gen.New(n, this.gen.mkApply_V(tree, treeArray));
        }

        private Tree compoundType(int n, Type[] typeArray, Scope scope, Symbol symbol, TEnv tEnv) {
            Tree[] treeArray = new Tree[typeArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                treeArray[i] = this.typeAsValue(n, typeArray[i], symbol, tEnv);
            }
            Tree[] treeArray2 = new Tree[]{this.gen.mkNewArray(n, this.access$39().CLASSTYPE_TYPE(), treeArray, symbol), this.gen.mkBooleanLit(n, scope.isEmpty())};
            Tree tree = this.gen.mkPrimaryConstructorGlobalRef(n, this.access$39().COMPOUNDTYPE_CLASS);
            return this.gen.New(n, this.gen.mkApply_V(tree, treeArray2));
        }

        private Tree scalaClassType(int n, Type type, Symbol symbol, TEnv tEnv) {
            if (TypesAsValuesPhase.this.access$46(type)) {
                return this.javaClassType(n, type.symbol());
            }
            if (type.$tag == 8) {
                Tree tree;
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Type type2 = typeRef.pre;
                Symbol symbol2 = typeRef.sym;
                Type[] typeArray = typeRef.args;
                Symbol symbol3 = TypesAsValuesPhase.this.access$36(symbol2);
                Tree.Ident ident = TypesAsValuesPhase.this.access$44(symbol2) && symbol2.owner().isClass() ? this.gen.Select(n, this.gen.mkQualifier(n, type2), symbol3) : this.gen.Ident(n, symbol3);
                int[] nArray = this.typeParamsPermutation(symbol2.typeParams());
                Symbol[] symbolArray = new Symbol[typeArray.length];
                for (int i = 0; i < typeArray.length; ++i) {
                    symbolArray[i] = typeArray[nArray[i]].symbol();
                }
                if (tEnv.definesVarArray(symbolArray)) {
                    tree = tEnv.treeForVarArray(symbolArray);
                } else {
                    Tree[] treeArray = new Tree[typeArray.length];
                    for (int i = 0; i < typeArray.length; ++i) {
                        treeArray[i] = this.typeAsValue(n, typeArray[nArray[i]], symbol, tEnv);
                    }
                    tree = this.gen.mkNewArray(n, this.access$39().TYPE_TYPE(), treeArray, symbol);
                }
                return this.gen.mkApply_V(n, ident, new Tree[]{tree});
            }
            throw Debug.abort("unexpected type: ", type);
        }

        private int[] typeParamsPermutation(Symbol[] symbolArray) {
            int[] nArray = new int[symbolArray.length];
            int n = 0;
            for (int i = 0; i < symbolArray.length; ++i) {
                if ((symbolArray[i].flags & 0xC0000000) != 0) continue;
                nArray[n++] = i;
            }
            for (int i = 0; i < symbolArray.length; ++i) {
                if ((symbolArray[i].flags & Integer.MIN_VALUE) == 0) continue;
                nArray[n++] = i;
            }
            for (int i = 0; i < symbolArray.length; ++i) {
                if ((symbolArray[i].flags & 0x40000000) == 0) continue;
                nArray[n++] = i;
            }
            if (!$assertionsDisabled && n != nArray.length) {
                throw new AssertionError();
            }
            return nArray;
        }

        private boolean isValuePrefix(Type type) {
            switch (type.$tag) {
                case 7: {
                    Type.ThisType thisType = (Type.ThisType)type;
                    Symbol symbol = thisType.sym;
                    return !symbol.isPackage() && !symbol.isNone();
                }
                case 14: {
                    return false;
                }
            }
            return true;
        }

        private Ancestor[][] computeAncestors0(Symbol symbol) {
            int n;
            int n2;
            Ancestor[][] ancestorArray;
            Symbol[] symbolArray = this.notStronglyTrivialParents(symbol);
            int n3 = this.level(symbol);
            ArrayList[] arrayListArray = new ArrayList[n3 + 1];
            for (int i = 0; i < arrayListArray.length; ++i) {
                arrayListArray[i] = new ArrayList();
            }
            if (!TypesAsValuesPhase.this.access$42(symbol.type())) {
                arrayListArray[n3].add(new Ancestor(symbol, -1, -1));
            }
            for (int i = 0; i < symbolArray.length; ++i) {
                Symbol symbol2 = symbolArray[i];
                ancestorArray = this.computeAncestors(symbol2);
                if (!$assertionsDisabled && ancestorArray.length > arrayListArray.length) {
                    throw new AssertionError();
                }
                for (n2 = 0; n2 < ancestorArray.length; ++n2) {
                    ArrayList arrayList = arrayListArray[n2];
                    Ancestor[] ancestorArray2 = ancestorArray[n2];
                    block3: for (int j = 0; j < ancestorArray2.length; ++j) {
                        Symbol symbol3 = ancestorArray2[j].symbol;
                        if (!$assertionsDisabled && TypesAsValuesPhase.this.access$42(symbol3.type())) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(symbol3)));
                        }
                        Iterator iterator = ((AbstractList)arrayList).iterator();
                        while (iterator.hasNext()) {
                            Ancestor ancestor = (Ancestor)iterator.next();
                            if (ancestor.symbol != symbol3) continue;
                            continue block3;
                        }
                        arrayList.add(new Ancestor(symbol3, i, j));
                    }
                }
            }
            for (n = arrayListArray.length; n > 0 && arrayListArray[n - 1].isEmpty(); --n) {
            }
            ancestorArray = new Ancestor[n][];
            for (n2 = 0; n2 < ancestorArray.length; ++n2) {
                ancestorArray[n2] = arrayListArray[n2].toArray(new Ancestor[arrayListArray[n2].size()]);
            }
            return ancestorArray;
        }

        private Ancestor[][] computeAncestors(Symbol symbol) {
            Ancestor[][] ancestorArray = (Ancestor[][])TypesAsValuesPhase.this.access$51().get(symbol);
            if (ancestorArray == null) {
                ancestorArray = this.computeAncestors0(symbol);
                TypesAsValuesPhase.this.access$51().put(symbol, ancestorArray);
            }
            return ancestorArray;
        }

        private Symbol[] notStronglyTrivialParents(Symbol symbol) {
            Type[] typeArray = symbol.parents();
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>(typeArray.length);
            for (int i = 0; i < typeArray.length; ++i) {
                if (TypesAsValuesPhase.this.access$46(typeArray[i])) continue;
                arrayList.add(typeArray[i].symbol());
            }
            return arrayList.toArray(new Symbol[arrayList.size()]);
        }

        private int[] getAncestorCode(Ancestor[][] ancestorArray) {
            int n;
            Object[] objectArray;
            ArrayList[] arrayListArray = new ArrayList[ancestorArray.length];
            int n2 = 0;
            for (int i = 0; i < ancestorArray.length; ++i) {
                objectArray = ancestorArray[i];
                ArrayList<int> arrayList = new ArrayList<int>(objectArray.length);
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n].parentIndex <= 0) continue;
                    arrayList.add(objectArray[n]);
                }
                arrayListArray[i] = arrayList;
                if (arrayList.isEmpty()) continue;
                n2 += 2 + 2 * arrayList.size();
            }
            objectArray = new int[n2];
            int n3 = 0;
            for (n = 0; n < arrayListArray.length; ++n) {
                ArrayList arrayList = arrayListArray[n];
                if (arrayList.isEmpty()) continue;
                objectArray[n3++] = n;
                objectArray[n3++] = arrayList.size();
                Iterator iterator = ((AbstractList)arrayList).iterator();
                while (iterator.hasNext()) {
                    Ancestor ancestor = (Ancestor)iterator.next();
                    objectArray[n3++] = ancestor.parentIndex;
                    objectArray[n3++] = ancestor.position;
                }
            }
            if (!$assertionsDisabled && n3 != n2) {
                throw new AssertionError();
            }
            return objectArray;
        }

        static {
            $assertionsDisabled = !Class.forName("scalac.transformer.TypesAsValuesPhase").desiredAssertionStatus();
        }

        static class 18
        extends TEnv {
            final /* synthetic */ HashMap val$varMap;
            final /* synthetic */ int val$pos;
            final /* synthetic */ Symbol val$tpArraySym;
            final /* synthetic */ Symbol[] val$tparams;
            final /* synthetic */ TV_Transformer this$1;
            private static final /* synthetic */ boolean $assertionsDisabled;

            public boolean definesVar(Symbol symbol) {
                return this.val$varMap.containsKey(symbol);
            }

            public Tree treeForVar(Symbol symbol) {
                int n = (Integer)this.val$varMap.get(symbol);
                Tree tree = this.this$1.gen.mkLocalRef(this.val$pos, this.val$tpArraySym);
                return this.this$1.gen.mkArrayGet(this.val$pos, tree, n);
            }

            public boolean definesVarArray(Symbol[] symbolArray) {
                if (symbolArray.length == this.val$tparams.length) {
                    for (int i = 0; i < symbolArray.length; ++i) {
                        if (symbolArray[i] == this.val$tparams[i]) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }

            public Tree treeForVarArray(Symbol[] symbolArray) {
                if (!$assertionsDisabled && !this.definesVarArray(symbolArray)) {
                    throw new AssertionError();
                }
                return this.this$1.gen.mkLocalRef(this.val$pos, this.val$tpArraySym);
            }

            18(HashMap hashMap, int n, Symbol symbol, Symbol[] symbolArray, TV_Transformer tV_Transformer) {
                this.val$varMap = hashMap;
                this.val$pos = n;
                this.val$tpArraySym = symbol;
                this.val$tparams = symbolArray;
                this.this$1 = tV_Transformer;
            }

            static {
                $assertionsDisabled = !Class.forName("scalac.transformer.TypesAsValuesPhase").desiredAssertionStatus();
            }
        }

        static class 17
        extends TEnv {
            final /* synthetic */ HashMap val$varMap;
            final /* synthetic */ int val$pos;
            final /* synthetic */ Symbol[] val$vparams;
            final /* synthetic */ TV_Transformer this$1;

            public boolean definesVar(Symbol symbol) {
                return this.val$varMap.containsKey(symbol);
            }

            public Tree treeForVar(Symbol symbol) {
                int n = (Integer)this.val$varMap.get(symbol);
                Tree tree = this.this$1.gen.mkLocalRef(this.val$pos, this.val$vparams[0]);
                return this.this$1.gen.mkArrayGet(this.val$pos, tree, n);
            }

            17(HashMap hashMap, int n, Symbol[] symbolArray, TV_Transformer tV_Transformer) {
                this.val$varMap = hashMap;
                this.val$pos = n;
                this.val$vparams = symbolArray;
                this.this$1 = tV_Transformer;
            }
        }
    }

    private static class TEnv {
        public boolean definesVar(Symbol symbol) {
            return false;
        }

        public Tree treeForVar(Symbol symbol) {
            throw Debug.abort("no tree for variable ".concat(String.valueOf(String.valueOf(symbol))));
        }

        public boolean definesVarArray(Symbol[] symbolArray) {
            return false;
        }

        public Tree treeForVarArray(Symbol[] symbolArray) {
            throw Debug.abort("no tree for variable array ".concat(String.valueOf(symbolArray)));
        }
    }

    private static class Ancestor {
        public static final Ancestor[] EMPTY_ARRAY = new Ancestor[0];
        public final Symbol symbol;
        public final int parentIndex;
        public final int position;

        public Ancestor(Symbol symbol, int n, int n2) {
            this.symbol = symbol;
            this.parentIndex = n;
            this.position = n2;
        }
    }
}

