/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003, LAMP/EPFL                  **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
** $Id: ImmutableSetAdaptor.scala,v 1.4 2005/06/07 15:30:41 mihaylov Exp $
\*                                                                      */

package scala.collection.mutable;


/** This class can be used as an adaptor to create mutable sets from
 *  immutable set implementations. Only method <code>empty</code> has
 *  to be redefined if the immutable set on which this mutable set is
 *  originally based is not empty. <code>empty</code> is supposed to
 *  return the representation of an empty set.
 *
 *  @author  Matthias Zenger
 *  @version 1.0, 21/07/2003
 */
[serializable]
class ImmutableSetAdaptor[A](s: scala.collection.immutable.Set[A]) extends Set[A] {

    protected var set = s;
    
    def size: Int = set.size;
    
    override def isEmpty: Boolean = set.isEmpty;
    
    def contains(elem: A): Boolean = set.contains(elem);

    override def foreach(f: A => Unit): Unit = set.foreach(f);
    
    override def exists(p: A => Boolean): Boolean = set.exists(p);
    
    override def toList: List[A] = set.toList;
    
    override def toString() = set.toString();
    
    def elements: Iterator[A] = set.elements;
    
    def +=(elem: A): Unit = { set = set + elem; }
    
    def -=(elem: A): Unit = { set = set - elem; }
    
    def clear: Unit = { set = empty; }
    
    protected def empty: scala.collection.immutable.Set[A] = s;
}
