/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2002-2005, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: BoxedShortArray.scala,v 1.3 2005/08/26 12:26:05 michelou Exp $

package scala.runtime;

final class BoxedShortArray(val value: Array[Short]) extends BoxedArray {

  def length: Int = value.length;

  def apply(index: Int): Object = BoxedShort.box(value(index));

  def update(index: Int, elem: Object): Unit = { 
    value(index) = elem.asInstanceOf[BoxedNumber].shortValue() 
  }

  def unbox(elemTag: String): Object = value;

  override def equals(other: Any) =
    value == other ||
    other.isInstanceOf[BoxedShortArray] && value == other.asInstanceOf[BoxedShortArray].value;

  override def hashCode(): Int = value.hashCode();
}

