/*
 * servregi.h -- Interface to be used by service executables for manual
 *               registration, when invoked from the command line.
 *
 * (c) 1999 Harald Albrecht <harald@plt.rwth-aachen.de>
 * Chair of Process Control Engineering,
 * Aachen University of Technology, Germany.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must print or display the above
 *    copyright notice either during startup or must have a means for
 *    the user to view the copyright notice.
 * 3. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the Chair of Process Control Engineering nor the
 *    name of the Aachen University of Technology may be used to endorse or
 *    promote products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE CHAIR OF PROCESS CONTROL ENGINEERING
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE CHAIR OF PROCESS CONTROL
 * ENGINEERING BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef __SERVREGI_H
#define __SERVREGI_H

/* --------------------------------------------------------------------------
 * The default extension for the self-registration helper dll.
 */
#define SELFREGISTRATIONDLLEXTENSION ".srg"


/* --------------------------------------------------------------------------
 * There are three modes of installation possible:
 * - NtServiceAutomaticInstallation: automatic installation by an
 *   installation program. No manual intervention possible.
 * - NtServiceRegistration: manual registration from the command line. Manual
 *   intervention possible.
 * - NtServiceForcedRegistration: like NtServiceRegistration, but without
 *   manual intervention.
 */
typedef enum {
    NtServiceAutomaticInstallation,
    NtServiceRegistration,
    NtServiceForcedRegistration
} NtServiceInstallationMode;


/* --------------------------------------------------------------------------
 * The registration magic can be triggered by these two functions...
 */
extern int
RegisterService(HMODULE hModule, NtServiceInstallationMode instMode);
extern int
UnregisterService(HMODULE hModule, NtServiceInstallationMode instMode);


#endif
/* End of servregi.h */
