function [] = plot_splitting()

figure(1);
clf;

s1 = split_spin(2,0,1/2,1);
s2 = split_spin(2,1,1/2,1);
s3 = split_spin(2,1,3/2,1);

r1 = split_rel(2,0,1/2,1);
r2 = split_rel(2,1,1/2,1);
r3 = split_rel(2,1,3/2,1);

dd = .02*s3

ln=plot([0 1],[0 0],'-y', ...
        [1 2],[0 s1],':r',[1 2],[0 s2],':r',[1 2],[0 s3],':r', ...
        [2 3],[s1 s1],'-y',[2 3],[s2 s2],'-y',[2 3],[s3 s3],'-y', ...
        [3 4],[s1 r1],':r',[3 4],[s2 r2],':r',[3 4],[s3 r3],':r', ...
        [4 5],[r1 r1],'-y',[4 5],[r3 r3],'-y');

set(gca,'Visible','off');

tt(1) = text(0.5,0 +dd, 'n=2');
tt(2) = text(2.5,s1+dd,'l=0    j=1/2');
tt(3) = text(2.5,s2+dd,'l=1    j=1/2');
tt(4) = text(2.5,s3+dd,'l=1    j=3/2');
tt(5) = text(4.5,r1+dd,'l=0,1    j=1/2');
tt(6) = text(4.5,r3+dd,'l=1    j=3/2');

ll(1) = text(0.5,s3+30*dd,'n=2 energy state');
ll(2) = text(2.5,s3+30*dd,'corrected for spin coupling');
ll(3) = text(4.5,s3+30*dd,'spin coupling + relativity');

set(tt,'FontSize',[8],'FontName','new century schoolbook','FontAngle','italic')
set(tt,'HorizontalAlignment','center','VerticalAlignment','bottom');
set(ll,'FontSize',[8],'FontName','new century schoolbook');
set(ll,'HorizontalAlignment','center','VerticalAlignment','bot');

get(tt(1))

set(gca,'FontSize',[8]);
