/* ==== machdep.h ============================================================
 * Copyright (c) 1993 Chris Provenzano, proven@athena.mit.edu
 *
 *  Description : Machine dependent header for decstation with r2000/r3000
 *				  running Ultrix-4.2
 *
 *  1.00 93/07/21 proven
 *      -Started coding this file.
 */

#include <copyright.h>
#include <setjmp.h>
#include <sys/time.h>

/*
 * Stuff for compiling
 */
#if defined(__GNUC__)
#if defined(__cplusplus)
#define __BEGIN_DECLS   extern "C" {
#define __END_DECLS		};
#define __P(protos) 	protos
#else
#define __BEGIN_DECLS
#define __END_DECLS
#if defined(__STDC__)
#define __P(protos) 	protos
#else
#define __P(protos) 	
#define const       	__const   
#define inline      	__inline
#define signed      	__signed
#define volatile   	 	__volatile
#endif
#endif
#else /* !__GNUC__ */
#define __BEGIN_DECLS
#define __END_DECLS
#define const         
#define inline
#define signed
#define volatile
#endif

/*
 * The first machine dependent functions are the SEMAPHORES
 * needing the test and set instruction.
 */
#define SEMAPHORE_CLEAR 0
#define SEMAPHORE_SET   1

#define SEMAPHORE_TEST_AND_SET(lock)	semaphore_test_and_set(lock)
#define SEMAPHORE_RESET(lock)			*lock = SEMAPHORE_CLEAR

/*
 * New types
 */
typedef long	semaphore;

#if !defined(_POSIX_SOURCE)

typedef int		ssize_t;

#if !defined(__GNUC__)

typedef int		sigset_t; 
#define sigaddset(set, num)		((*set) |= (1 << (num - 1)))
#define sigemptyset(set)		(*set = 0) 

#endif
#endif

#define SIGMAX 	31

/*
 * New Structures
 */
struct machdep_pthread {
	void						*(*start_routine)(void *);
	void						*start_argument;
	void						*machdep_stack;
	struct itimerval			machdep_timer;
	jmp_buf						machdep_state;
};

/*
 * Static machdep_pthread initialization values.
 * For initial thread only.
 */
#define MACHDEP_PTHREAD_INIT	\
{ NULL, NULL, NULL, { { 0, 0 }, { 0, 0 } }, 0 }


/*
 * Min stacksize, arch dependent
 */
#define PTHREAD_STACK_MIN	1024

/*
 * Some fd flag defines that are necessary to distinguish between posix
 * behavior and bsd4.3 behavior.
 */
#define __FD_NONBLOCK 		O_NONBLOCK | O_NDELAY

/*
 * New functions
 */

__BEGIN_DECLS

#if defined(PTHREAD_KERNEL)

int	semaphore_text_and_set	__P((semaphore *));
int machdep_save_state		__P((void));

#endif

__END_DECLS
