/* ==== signal.c ============================================================
 * Copyright (c) 1993 by Chris Provenzano, proven@athena.mit.edu
 *
 * Description : Benchmark reads of /dev/null. Gives a good aprox. of
 *				 syscall times.
 *
 *  1.00 93/08/01 proven
 *      -Started coding this file.
 */

#include <sys/types.h>
#include <sys/time.h>
#include <fcntl.h>
#include <errno.h>
#include "util.h"

/* ==========================================================================
 * usage();
 */
void usage(void)
{
	printf("bench_pipe [-d?] [-c count]\n");
    errno = 0;
}

main(int argc, char **argv)
{
	struct timeval starttime, endtime;
	char buf[1];
	int count = 1000;
	int debug = 0;
	int fd0[2];
	int fd1[2];
	int i;

	char word[MAX_COMMAND_SIZE];

    /* Getopt variables. */
    extern int optind, opterr;
    extern char *optarg;

	while ((word[0] = getopt(argc, argv, "c:d?")) != (char)EOF) {
		switch (word[0]) {
		case 'd':
			debug++;
			break;
		case 'c':
			count = atoi(optarg);
			break;
		case '?':
			usage();
			return(OK);
		default:
			usage();
			return(NOTOK);
		}
	}

	if ((pipe(fd0) < OK) || (pipe(fd1) < OK)) {
		perror("pipe");
		exit();
	}

	switch (fork()) {
	case NOTOK:
		perror("fork");
		exit();
	case OK: /* Child */
		for (i = 0; i < count; i++) {
			if (read(fd1[0], buf, 1) < OK) {
				perror("child read");
				exit();
			}
			if (write(fd0[1], buf, 1) < OK) {
				perror("child write");
				exit();
			}
		}
		exit();
		break;
	default:
		break;
	}

	if (gettimeofday(&starttime, NULL)) {
		perror("First attempt to gettimeofday()");
		exit();
	}
	count --;
	if (write(fd1[1], buf, 1) < OK) {
		perror("first parent write");
		exit();
	}
	for (i = 0; i < count; i++) {
		if (read(fd0[0], buf, 1) < OK) {
			perror("parrent read");
			exit();
		}
		if (write(fd1[1], buf, 1) < OK) {
			perror("parrent write");
			exit();
		}
	}
	if (gettimeofday(&endtime, NULL)) {
		perror("Last attempt to gettimeofday()");
		exit();
	}

	printf("%d reads of /dev/null took %d usecs.\n", count, 
		(endtime.tv_sec - starttime.tv_sec) * 1000000 +
		(endtime.tv_usec - starttime.tv_usec));
}
