/* ==== signal.c ============================================================
 * Copyright (c) 1993 by Chris Provenzano, proven@athena.mit.edu
 *
 * Description : Benchmark reads of /dev/null. Gives a good aprox. of
 *				 syscall times.
 *
 *  1.00 93/08/01 proven
 *      -Started coding this file.
 */

#include <sys/types.h>
#include <sys/time.h>
#include <fcntl.h>
#include <errno.h>
#include "util.h"

/* ==========================================================================
 * usage();
 */
void usage(void)
{
	printf("getopt [-d?] [-c count]\n");
    errno = 0;
}

main(int argc, char **argv)
{
	struct timeval starttime, endtime;
	int count = 1000000;
	int debug = 0;
	int fd;
	int i;

	char word[MAX_COMMAND_SIZE];

    /* Getopt variables. */
    extern int optind, opterr;
    extern char *optarg;

	pthread_init();

	while ((word[0] = getopt(argc, argv, "c:d?")) != (char)EOF) {
		switch (word[0]) {
		case 'd':
			debug++;
			break;
		case 'c':
			count = atoi(optarg);
			break;
		case '?':
			usage();
			return(OK);
		default:
			usage();
			return(NOTOK);
		}
	}

	if ((fd = open("/dev/null", O_RDONLY)) < OK) {
		perror("dev/null");
		exit();
	}

	if (gettimeofday(&starttime, NULL)) {
		perror("First attempt to gettimeofday()");
		exit();
	}
	for (i = 0; i < count; i++) {
		if (read(fd, &word, 1) < OK) {
			perror(NULL);
			exit();
		}
	}
	if (gettimeofday(&endtime, NULL)) {
		perror("Last attempt to gettimeofday()");
		exit();
	}

	printf("%d reads of /dev/null took %d usecs.\n", count, 
		(endtime.tv_sec - starttime.tv_sec) * 1000000 +
		(endtime.tv_usec - starttime.tv_usec));
}
