/* connection.cc: Handle client connections. */

#include "threads.h"
#include "error.h"

#include "Connection.h"

#include <String.h>

extern "C" {
#include <string.h>
#include <unistd.h>
}

Connection::Connection(int fd)
{
    client_socket = fd;
}

/* Vestigial run(): echo input to output. */
void Connection::run()
{
    char buf[1024];
    int count;

    while (1) {
	count = read(client_socket, buf, 1024);
	printf("Read %d bytes from fd %d.\n", count, client_socket);
	if (count <= 0) {
	    if (count < 0)
		warn("read() failed: %s\n", strerror(-count));
	    return;
	}
	write(client_socket, buf, count);
    }
}

#if 0
void Connection::run()
{
    String line;
    char buf[1025], *s, *p;
    int count;

    while (1) {

	/* Read in some text from the socket. */
	count = read(client_socket, buf, 1024);

	/* Scan the text for newlines. */
	s = buf;
	p = memchr(buf, '\n', count);
	while (p) {
	    *p = 0;
	    line += s;
	    process_line(line);
	    line = "";

	    s = p + 1;
	    p = memchr(s, '\n', count - (s - buf));
	}

	buf[1024] = 0;
	line = s;
    }
}
#endif

