/* error.cc: Deal with error conditions. */

#include "threads.h"
#include "error.h"

extern "C" {
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>
}

void die(char *fmt, ...)
{
    char buf[1024];
    va_list arg;

    va_start(arg, fmt);
    vsprintf(buf, fmt, arg);
    va_end(arg);
    fputs(buf, stderr);
    exit(1);
}

void warn(char *fmt, ...)
{
    char buf[1024];
    va_list arg;

    va_start(arg, fmt);
    vsprintf(buf, fmt, arg);
    va_end(arg);
    fputs(buf, stderr);
}

