/*
 * nsref.h - Description of the basic nsReference type
 *
 * Copyright (C) 1997, George Madrid
 * All rights reserved.
 */

#ifndef INC_NSREF_H
#define INC_NSREF_H

/* ---------- Public stuff ---------- */
struct nsRefS;
typedef struct nsRefS * nsRef;

/* ---------- Function declarations ---------- */
int nsr_primclass(nsRef);
nsObj nsr_class(nsRef);

nsObj array_AddSlot(nsRef, nsObj);

/* ---------- Methods ---------- */
struct nsr_ops {
     nsObj (*getClass)(nsRef);
     nsRef (*setClass)(nsRef, nsObj);
     void (*Print)(nsRef);
     nsObj (*setARef)(nsRef, nsObj, nsObj);
     nsObj (*ARef)(nsRef, nsObj);
};

struct nsRefS {
     int primclass;		/* PRIMC_BINARY,PRIMC_ARRAY,PRIMC_FRAME */ 
     size_t size;		/* How big this structure really is */
     struct nsr_ops *ops;	/* Virtual functions (methods) */
};

#endif /* INC_NSREF_H */
