import sys
import getopt
import time

sys.argv = sys.argv[1:]

phase = 1
outfile = 'totw.html'

opts, args = getopt.getopt(sys.argv, 'o:')
for opt, arg in opts:
    if opt == '-o':
        outfile = arg
    else:
        print >>sys.stderr, "bad arg!"
        sys.exit(1)

nameMap = {
    "B": "Blofeld",
    "D": "Doom",
    "E": "Evil",
    "F": "Frankenstein",
    "M": "Mario",
    "W": "Wily"
    }

def handleControl(data, continent):
    cdata = data[continent]
    
    # is anyone controlling this one?
    nonzero = 0
    most = 0
    whohas = []
    for who in cdata['armies']:
        amt = cdata['armies'][who][0]
        if amt > 0:
            nonzero += 1
            if amt > most:
                most = amt
                whohas = [ who ]
            elif amt == most:
                whohas.append(who)

    if nonzero != 1:
        # no one controls
        cdata['control'] = 0
        cdata['controller'] = ''
        for who in whohas:
            print "  %s - %s gets +1 Science" % (continent, who)
        
    else:
        who = whohas[0]
        if cdata['controller'] == who:
            cdata['control'] += 1
        else:
            cdata['control'] = 1
            cdata['controller'] = who

        print "  %s - %s gets +2 Science" % (continent, who)

def generateList(data):
    ret = []
    for who in data:
        ret.append( (who, data[who][0]) )
    ret.sort( lambda x, y: x[1] - y[1] )
    return ret

def writeHtml():    
    of = open(outfile, 'w')
    print >>of, '''<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<meta http-equiv="refresh" content="300" />
<title>Taking Over the World</title>
<style>
.container { position: absolute; z-index: 100; border: 1px solid black; background-color: white; padding: 5px; width: 150px;}
.continent { font-weight: bold; font-size: 120%; text-align: center; }
.control { text-align: center; }
</style>
</head>
<body>
<div style="position: absolute; top: -75px; overflow: hidden; height: 854px;">
<img src="world_map.jpg" width="1230" />
</div>
'''
    for c in continentData:
        d = continentData[c]
        print >>of, '<div class="container" style="top: %dpx; left: %dpx;">' % (d['top'], d['left'])

        print >>of, '<div class="continent">%s</div>' % c
        if d['control'] > 0:
            print >>of, '<div class="control">[%s %d]</div>' % (d['controller'], d['control'])
        

        l = generateList(d['armies'])
        for p in l:
            if p[1] > 0:
                print >>of, '<div>%s - %d</div>' % p

        print >>of, '</div>'
    
    print >>of, "</body></html>"

# people taking over world:
#   doom    [physics]
#   evil    [lasers]
#   mario   [bio]
#   blofeld [chem]
#   wily    [robots]
#   franky  [paranormal]

continentMap = {
    "NA": "North America",
    "SA": "South America",
    "EU": "Europe",
    "AS": "Asia",
    "AF": "Africa",
    "AU": "Australia"
    }

continentData = {
    "North America": {'top': 240, 'left': 75},
    "South America": {'top': 500, 'left': 240},
    "Africa": {'top': 420, 'left': 532},
    "Europe": {'top': 200, 'left': 575},
    "Australia": {'top': 600, 'left': 975},
    "Asia": {'top': 250, 'left': 900}
}

for c in continentData:
    continentData[c]['control'] = 0
    continentData[c]['controller'] = ''
    continentData[c]['armies'] = {}
    for x in ["Blofeld", "Doom", "Evil", "Frankenstein", "Mario", "Wily"]:
        continentData[c]['armies'][x] = [0,0]

while True:
    writeHtml()

    # accept input
    nextLine = sys.stdin.readline().strip()

    pieces = nextLine.split(" ")

    command = pieces[0]
    
    if command == 'p':
        for c in continentData:
            total = 0
            nonzero = 0
            ref = continentData[c]['armies']
            for w in ref:
                a = ref[w][1]
                if a > 0:
                    total += a
                    nonzero += 1

            if nonzero > 1:
                total = (total + nonzero - 1) / nonzero
            else:
                total = 0

            for w in ref:
                a = ref[w][1]
                if a > 0:
                    ref[w][1] = max(0, a - total)
                ref[w][0] = ref[w][1]

            handleControl(continentData, c)

    elif command == 'a':
        try:
            who = nameMap[pieces[1]]
            where = continentMap[pieces[2]]
            howmany = int(pieces[3])

            continentData[where]['armies'][who][1] += howmany
        except Exception, e:
            # fuck error correction
            print e
            print >>sys.stderr, "ERROR in a command"
            pass
    else:
        pass
