#
#  $Id: URL.py,v 1.3 1999/12/11 12:35:12 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""A Store that retrieves a single file from a URL.

At present, this Store is read-only -- it fetches the file directly into
a prc.File object using urllib.  At some point in the future, there may
be write-back support for at least FTP.
"""

__version__ = '$Id: URL.py,v 1.3 1999/12/11 12:35:12 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'


import os, time

import Pyrite
import Pyrite.Store

from Pyrite import Database, pdbfile, _

from Pyrite import prc

class FileStore(Pyrite.Store.BaseStore):
    properties = ('read','create','delete','list')
    db_properties = ('id-unique','id-replace')
    
    def __init__(self, url = ''):
	Pyrite.Store.BaseStore.__init__(self)
	self.theurl = url
	self.cache = ''

    def open(self, name, mode='rs', dbclass=Database, properties=(), **kw):
	if not self.test_db_properties(properties):
	    raise RuntimeError, _("cannot provide db with properties %s") % properties
	if 'w' in mode:
	    raise RuntimeError, _("cannot open for write")
	try:
	    f = prc.File(None, read=0, write=0)
	    f.unpack(self._get())
	    i = f.getDBInfo()
	    db = dbclass(f, i, mode, self.db_properties)
	    return db
	except:
	    raise IOError, _("no such database")
	
    def create(self, name, creator, type, flags=0, version=1, dbclass=Database,
	       properties = (),
	       info = None, **kw):
	raise RuntimeError, _("this store cannot create databases")

    def delete(self, name):
	raise RuntimeError, _("this store cannot delete databases")

    def info(self, name):
	try:
	    f = prc.File(None, read=0, write=0)
	    f.unpack(self._get())
	    return f.getDBInfo()
	except:
	    raise IOError, _("no such database")

    def list(self):
	try:
	    i = self.info(None)
	    return [ i['name'] ]
	except:
	    return []

    def listinfo(self, name=None, creator=None, type=None):
	try:
	    i = self.info(None)
	    if name is not None and i['name'] != name: return []
	    if creator is not None and i['creator'] != creator: return []
	    if type is not None and i['type'] != type: return []
	    return [i]
	except:
	    return []

    def _get(self):
	if not self.cache:
	    u = urllib.urlopen(self.theurl)
	    self.cache = u.read()
	return self.cache
    
class Store(Pyrite.Store.Store):
    name = 'File'
    author = Pyrite.author
    version = Pyrite.version
    description = _("A single PRC/PDB file.")
    properties = ['read','create','delete','list']

    store_class = FileStore
