#!/usr/bin/python
#
#  $Id: sync.py,v 1.13 1999/12/16 10:00:32 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""Synchronization command-line utility.
"""

__version__ = '$Id: sync.py,v 1.13 1999/12/16 10:00:32 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'


import string, sys, os, traceback

import Pyrite
from Pyrite import _
from Pyrite.Application import Application

class App(Application):
    name = 'Pyrite Sync'
    version = Pyrite.version
    author = 'Rob Tillotson <robt@debian.org>'
    description = _("Run a series of conduits.")
    extra_help = _("At the moment, this only works for the default user.")
    
    def __init__(self):
	Application.__init__(self)

	self.config_path = 'Pyrite::Sync'
	
    def run_conduits(self, conduits=[]):
	cl = []
	for c in conduits:
	    try:
		p = self.get_plugin('Conduit', c)
		cl.append(p)
	    except:
		self.error(_("failed to load conduit '%s'") % c, 'warning')
		continue

	# do pre-sync
	cl0 = []
	for c in cl:
	    try:
		if c.presync(self):
		    cl0.append(c)
		else:
		    self.log(_("conduit '%s' has nothing to do, skipping it") % c.name)
	    except:
		a = sys.exc_info()
		self.error(_("during presync: %s: %s") % (a[0].__name__, a[1].args), 'error')
		if self.has_option('debug'):
		    traceback.print_tb(a[2])

	self.log(_("Connecting"))
	self.connect(immediate=1)
	
	# actual sync
	for c in cl0:
	    try: c(self)
	    except:
		a = sys.exc_info()
		self.error(_("during sync: %s: %s") % (a[0].__name__, a[1].args), 'error')
		if self.has_option('debug'):
		    traceback.print_tb(a[2])
	self.log(_("Disconnecting"))
	self.disconnect()
	
	# postsync
	for c in cl:
	    try: c.postsync(self)
	    except:
		a = sys.exc_info()
		self.error(_("during postsync: %s: %s") % (a[0].__name__, a[1].args), 'error')
		if self.has_option('debug'):
		    traceback.print_tb(a[2])

    def run_session(self):
	c = self.registry.get('Pyrite::Sync::conduits',
			      self.registry.get('Pyrite::Sync::Conduits',''))
	if type(c) == type(''):
	    c = filter(None, map(string.strip, string.split(c, ',')))
	if not c: return None

	self.run_conduits(c)
	
    def run(self, argv):
	if self.get_option('help'): return
	
	self.run_session()


if __name__ == '__main__':
    a = App()
    a()
    
