'\"
'\" Copyright 1990 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/options.man,v 1.12 92/07/14 11:36:10 ouster Exp $ SPRITE (Berkeley)
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS options cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
options \- Standard options supported by widgets
.BE

.SH DESCRIPTION
This manual entry describes the common configuration options supported
by widgets in the Tk toolkit.  Every widget does not necessarily support
every option (see the manual entries for individual widgets for a list
of the standard options supported by that widget), but if a widget does
support an option with one of the names listed below, then the option
has exactly the effect described below.
.PP
In the descriptions below,
``Name'' refers to the option's name in the option database (e.g.
in .Xdefaults files).  ``Class'' refers to the option's class value
in the option database.  ``Command-Line Switch'' refers to the
switch used in widget-creation and {\emconfigure} widget commands to
set this value.  For example, if an option's command-line switch is
{\em \-foreground} and there exists a widget {\em .a.b.c}, then the
command
.DS
\&{\em .a.b.c\0\0configure\0\0\-foreground black}
.DE
may be used to specify the value {\em black} for the option in the
the widget {\em .a.b.c}.  Command-line switches may be abbreviated,
as long as the abbreviation is unambiguous.
.ta 4c
.LP
.nf
Name:	{\em activeBackground}
Class:	{\em Foreground}
Command-Line Switch:	{\em \-activebackground}
.fi
.IP
Specifies background color to use when drawing active elements.
An element (a widget or portion of a widget) is active if the
mouse cursor is positioned over the element and pressing a mouse button
will cause some action to occur.
.LP
.nf
Name:	{\em activeBorderWidth}
Class:	{\em BorderWidth}
Command-Line Switch:	{\em \-activeborderwidth}
.fi
.IP
Specifies a non-negative value indicating
the width of the 3-D border drawn around active elements.  See above for
definition of active elements.
.VS
The value may have any of the forms acceptable to {\em Tk_GetPixels}.
.VE
This option is typically only available in widgets displaying more
than one element at a time (e.g. menus but not buttons).
.LP
.nf
Name:	{\em activeForeground}
Class:	{\em Background}
Command-Line Switch:	{\em \-activeforeground}
.fi
.IP
Specifies foreground color to use when drawing active elements.
See above for definition of active elements.
.LP
.nf
.VS
Name:	{\em anchor}
Class:	{\em Anchor}
Command-Line Switch:	{\em \-anchor}
.fi
.IP
Specifies how the information in a widget (e.g. text or a bitmap)
is to be displayed in the widget.
Must be one of the values {\em n}, {\em ne}, {\em e}, {\em se},
{\em s}, {\em sw}, {\em w}, {\em nw}, or {\em center}.
For example, {\em nw} means display the information such that its
top-left corner is at the top-left corner of the widget.
.VE
.LP
.nf
Name:	{\em background}
Class:	{\em Background}
Command-Line Switch:	{\em \-background or \-bg}
.fi
.IP
Specifies the normal background color to use when displaying the
widget.
.LP
.nf
Name:	{\em bitmap}
.VS
Class:	{\em Bitmap}
Command-Line Switch:	{\em \-bitmap}
.fi
.IP
Specifies a bitmap to display in the widget, in any of the forms
acceptable to {\em Tk_GetBitmap}.
The exact way in which the bitmap is displayed may be affected by
other options such as {\em anchor} or {\em justify}.
Typically, if this option is specified then it overrides other
options that specify a textual value to display in the widget;
the {\em bitmap} option may be reset to an empty string to re-enable
a text display.
.VE
.LP
.nf
Name:	{\em borderWidth}
Class:	{\em BorderWidth}
Command-Line Switch:	{\em \-borderwidth or \-bd}
.fi
.IP
Specifies a non-negative value indicating the width
of the 3-D border to draw around the outside of the widget (if such a
border is being drawn;  the {\em relief} option typically determines
this).  The value may also be used when drawing 3-D effects in the
interior of the widget.
.VS
The value may have any of the forms acceptable to {\em Tk_GetPixels}.
.VE
.LP
.nf
Name:	{\em cursor}
Class:	{\em Cursor}
Command-Line Switch:	{\em \-cursor}
.fi
.IP
Specifies the mouse cursor to be used for the widget.
The value may have any of the forms acceptable to {\em Tk_GetCursor}.
.LP
.nf
Name:	{\em cursorBackground}
Class:	{\em Foreground}
Command-Line Switch:	{\em \-cursorbackground}
.fi
.IP
Specifies the color to use as background in the area covered by the
insertion cursor.  This color will normally override either the normal
background for the widget (or the selection background if the insertion
cursor happens to fall in the selection).
.VS
\fIThis option is obsolete and is gradually being replaced by
the {\em insertBackground} option.}
.VE
.LP
.nf
Name:	{\em cursorBorderWidth}
Class:	{\em BorderWidth}
Command-Line Switch:	{\em \-cursorborderwidth}
.fi
.IP
Specifies a non-negative value indicating the width
of the 3-D border to draw around the insertion cursor.
.VS
The value may have any of the forms acceptable to {\em Tk_GetPixels}.
\fIThis option is obsolete and is gradually being replaced by
the {\em insertBorderWidth} option.}
.VE
.LP
.nf
Name:	{\em cursorOffTime}
Class:	{\em OffTime}
Command-Line Switch:	{\em \-cursorofftime}
.fi
.IP
Specifies a non-negative integer value indicating the number of
milliseconds the cursor should remain ``off'' in each blink cycle.
If this option is zero then the cursor doesn't blink:  it is on
all the time.
.VS
\fIThis option is obsolete and is gradually being replaced by
the {\em insertOffTime} option.}
.VE
.LP
.nf
Name:	{\em cursorOnTime}
Class:	{\em OnTime}
Command-Line Switch:	{\em \-cursorontime}
.fi
.IP
Specifies a non-negative integer value indicating the number of
milliseconds the cursor should remain ``on'' in each blink cycle.
.VS
\fIThis option is obsolete and is gradually being replaced by
the {\em insertOnTime} option.}
.VE
.LP
.nf
Name:	{\em cursorWidth}
Class:	{\em CursorWidth}
Command-Line Switch:	{\em \-cursorwidth}
.fi
.IP
Specifies a  value indicating the total width of the insertion cursor.
.VS
The value may have any of the forms acceptable to {\em Tk_GetPixels}.
.VE
If a border has been specified for
the cursor (using the {\em cursorBorderWidth} option), the border
will be drawn inside the width specified by the {\em cursorWidth}
option.
.VS
\fIThis option is obsolete and is gradually being replaced by
the {\em insertWidth} option.}
.VE
.LP
.nf
.VS
Name:	{\em disabledForeground}
Class:	{\em DisabledForeground}
Command-Line Switch:	{\em \-disabledforeground}
.fi
.IP
Specifies foreground color to use when drawing a disabled element.
If the option is specified as an empty string (which is typically the
case on monochrome displays), disabled elements are drawn with the
normal fooreground color but they are dimmed by drawing them
with a stippled fill pattern.
.VE
.LP
.nf
.VS
Name:	{\em exportSelection}
Class:	{\em ExportSelection}
Command-Line Switch:	{\em \-exportselection}
.fi
.IP
Specifies whether or not a selection in the widget should also be
the X selection.
The value may have any of the forms accepted by {\em Tcl_GetBoolean},
such as {\em true}, {\em false}, {\em 0}, {\em 1}, {\em yes}, or {\em no}.
If the selection is exported, then selecting in the widget deselects
the current X selection, selecting outside the widget deselects any
widget selection, and the widget will respond to selection retrieval
requests when it has a selection.  The default is usually for widgets
to export selections.
.VE
.LP
.nf
Name:	{\em font}
Class:	{\em Font}
Command-Line Switch:	{\em \-font}
.fi
.IP
Specifies the font to use when drawing text inside the widget.
.LP
.nf
Name:	{\em foreground}
Class:	{\em Foreground}
Command-Line Switch:	{\em \-foreground or \-fg}
.fi
.IP
Specifies the normal foreground color to use when displaying the widget.
.LP
.nf
Name:	{\em geometry}
Class:	{\em Geometry}
Command-Line Switch:	{\em \-geometry}
.fi
.IP
Specifies the desired geometry for the widget's window, in the
form \fIwidth{\em x\fIheight}, where \fIwidth} is the desired
width of the window and \fIheight} is the desired height.  The
units for \fIwidth} and \fIheight} depend on the particular
widget.  For widgets displaying text the units are usually the
size of the characters in the font being displayed;  for other
widgets the units are usually pixels.
.LP
.nf
.VS
Name:	{\em insertBackground}
Class:	{\em Foreground}
Command-Line Switch:	{\em \-insertbackground}
.fi
.IP
Specifies the color to use as background in the area covered by the
insertion cursor.  This color will normally override either the normal
background for the widget (or the selection background if the insertion
cursor happens to fall in the selection).
.LP
.nf
Name:	{\em insertBorderWidth}
Class:	{\em BorderWidth}
Command-Line Switch:	{\em \-insertborderwidth}
.fi
.IP
Specifies a non-negative value indicating the width
of the 3-D border to draw around the insertion cursor.
The value may have any of the forms acceptable to {\em Tk_GetPixels}.
.LP
.nf
Name:	{\em insertOffTime}
Class:	{\em OffTime}
Command-Line Switch:	{\em \-insertofftime}
.fi
.IP
Specifies a non-negative integer value indicating the number of
milliseconds the insertion cursor should remain ``off'' in each blink cycle.
If this option is zero then the cursor doesn't blink:  it is on
all the time.
.LP
.nf
Name:	{\em insertOnTime}
Class:	{\em OnTime}
Command-Line Switch:	{\em \-insertontime}
.fi
.IP
Specifies a non-negative integer value indicating the number of
milliseconds the insertion cursor should remain ``on'' in each blink cycle.
.LP
.nf
Name:	{\em insertWidth}
Class:	{\em InsertWidth}
Command-Line Switch:	{\em \-insertwidth}
.fi
.IP
Specifies a  value indicating the total width of the insertion cursor.
The value may have any of the forms acceptable to {\em Tk_GetPixels}.
If a border has been specified for the insertion
cursor (using the {\em insertBorderWidth} option), the border
will be drawn inside the width specified by the {\em insertWidth}
option.
.VE
.LP
.nf
Name:	{\em orient}
Class:	{\em Orient}
Command-Line Switch:	{\em \-orient}
.fi
.IP
For widgets that can lay themselves out with either a horizontal
or vertical orientation, such as scrollbars, this option specifies
which orientation should be used.  Must be either {\em horizontal}
or {\em vertical} or an abbreviation of one of these.
.LP
.nf
Name:	{\em padX}
Class:	{\em Pad}
Command-Line Switch:	{\em \-padx}
.fi
.IP
Specifies a non-negative value indicating how much extra space
to request for the widget in the X-direction.
.VS
The value may have any of the forms acceptable to {\em Tk_GetPixels}.
.VE
When computing how large a window it needs, the widget will
add this amount to the width it would normally need (as determined
by the width of the things displayed in the widget);  if the geometry
manager can satisfy this request, the widget will end up with extra
internal space to the left and/or right of what it displays inside.
.LP
.nf
Name:	{\em padY}
Class:	{\em Pad}
Command-Line Switch:	{\em \-pady}
.fi
.IP
Specifies a non-negative value indicating how much extra space
to request for the widget in the Y-direction.
.VS
The value may have any of the forms acceptable to {\em Tk_GetPixels}.
.VE
When computing how large a window it needs, the widget will add
this amount to the height it would normally need (as determined by
the height of the things displayed in the widget);  if the geometry
manager can satisfy this request, the widget will end up with extra
internal space above and/or below what it displays inside.
.LP
.nf
Name:	{\em relief}
Class:	{\em Relief}
Command-Line Switch:	{\em \-relief}
.fi
.IP
Specifies the 3-D effect desired for the widget.  Acceptable
values are {\em raised}, {\em sunken}, and {\em flat}.  The value
indicates how the interior of the widget should appear relative
to its exterior;  for example, {\em raised} means the interior of
the widget should appear to protrude from the screen, relative to
the exterior of the widget.
.LP
.nf
Name:	{\em repeatDelay}
Class:	{\em RepeatDelay}
Command-Line Switch:	{\em \-repeatdelay}
.fi
.IP
Specifies the number of milliseconds a button or key must be held
down before it begins to auto-repeat.  Used, for example, on the
up- and down-arrows in scrollbars.
.LP
.nf
Name:	{\em repeatInterval}
Class:	{\em RepeatInterval}
Command-Line Switch:	{\em \-repeatinterval}
.fi
.IP
Used in conjunction with {\em repeatDelay}:  once auto-repeat
begins, this option determines the number of milliseconds between
auto-repeats.
.LP
.nf
Name:	{\em scrollCommand}
Class:	{\em ScrollCommand}
Command-Line Switch:	{\em \-scrollcommand}
.fi
.IP
Specifies the prefix for a command used to communicate with scrollbar
widgets.  When the view in the widget's window changes (or
whenever anything else occurs that could change the display in a
scrollbar, such as a change in the total size of the widget's
contents), the widget will
generate a Tcl command by concatenating the scroll command and four
numbers.  The four numbers are, in order:  the total size of the
widget's contents, in unspecified units
(``unit'' is a widget-specific term;  for widgets
displaying text, the unit is a line);  the maximum number of units that
may be displayed at once in the widget's window, given its current size;  the
index of the top-most or left-most unit currently visible in the window
(index 0 corresponds to the first unit); and the index of the bottom-most
or right-most unit currently visible in the window.  This command is
then passed to the Tcl interpreter for execution.  Typically the
{\em scrollCommand} option consists of the path name of a scrollbar
widget followed by ``set'', e.g. ``.x.scrollbar set'':  this will cause
the scrollbar to be updated whenever the view in the window changes.
If this option is not specified, then no command will be executed.
.IP
.VS
The {\em scrollCommand} option is used for widgets that support scrolling
in only one direction.
For widgets that support scrolling in both directions, this
option is replaced with the {\em xScrollCommand} and {\em yScrollCommand}
options.
.VE
.LP
.nf
Name:	{\em selectBackground}
Class:	{\em Foreground}
Command-Line Switch:	{\em \-selectbackground}
.fi
.IP
Specifies the background color to use when displaying selected
items.
.LP
.nf
Name:	{\em selectBorderWidth}
Class:	{\em BorderWidth}
Command-Line Switch:	{\em \-selectborderwidth}
.fi
.IP
Specifies a non-negative value indicating the width
of the 3-D border to draw around selected items.
.VS
The value may have any of the forms acceptable to {\em Tk_GetPixels}.
.VE
.LP
.nf
Name:	{\em selectForeground}
Class:	{\em Background}
Command-Line Switch:	{\em \-selectforeground}
.fi
.IP
Specifies the foreground color to use when displaying selected
items.
.LP
.nf
.VS
Name:	{\em setGrid}
Class:	{\em SetGrid}
Command-Line Switch:	{\em \-setgrid}
.fi
.IP
Specifies a boolean value that determines whether this widget controls the
resizing grid for its top-level window.
This option is typically used in text widgets, where the information
in the widget has a natural size (the size of a character) and it makes
sense for the window's dimensions to be integral numbers of these units.
These natural window sizes form a grid.
If the {\em setGrid} option is set to true then the widget will
communicate with the window manager so that when the user interactively
resizes the top-level window that contains the widget, the dimensions of
the window will be displayed to the user in grid units and the window
size will be constrained to integral numbers of grid units.
See the section GRIDDED GEOMETRY MANAGEMENT in the {\em wm} manual
entry for more details.
.VE
.LP
.nf
Name:	{\em text}
Class:	{\em Text}
Command-Line Switch:	{\em \-text}
.fi
.IP
Specifies a string to be displayed inside the widget.  The way in which
the string is displayed depends on the particular widget and may be
determined by other options, such as {\em anchor} or {\em justify}.
.LP
.nf
.VS
Name:	{\em textVariable}
Class:	{\em Variable}
Command-Line Switch:	{\em \-textvariable}
.fi
.IP
Specifies the name of a variable.  The value of the variable is a text
string to be displayed inside the widget;  if the variable value changes
then the widget will automatically update itself to reflect the new value.
The way in which the string is displayed in the widget depends on the
particular widget and may be determined by other options, such as
{\em anchor} or {\em justify}.
.LP
.nf
Name:	{\em underline}
Class:	{\em Underline}
Command-Line Switch:	{\em \-underline}
.fi
.IP
Specifies the integer index of a character to underline in the widget.
This option is typically used to indicate keyboard traversal characters
in menu buttons and menu entries.  0 corresponds to the first character
of the text displayed in the widget, 1 to the next character, and so
on.
.LP
.nf
Name:	{\em xScrollCommand}
Class:	{\em ScrollCommand}
Command-Line Switch:	{\em \-xscrollcommand}
.fi
.IP
Specifies the prefix for a command used to communicate with horizontal
scrollbars.  This option is treated in the same way as the
{\em scrollCommand} option, except that it is used for horizontal
scrollbars associated with widgets that support both horizontal
and vertical scrolling.
See the description of {\em scrollCommand} for complete details
on how this option is used.
.LP
.nf
Name:	{\em yScrollCommand}
Class:	{\em ScrollCommand}
Command-Line Switch:	{\em \-yscrollcommand}
.fi
.IP
Specifies the prefix for a command used to communicate with vertical
scrollbars.  This option is treated in the same way as the
{\em scrollCommand} option, except that it is used for vertical
scrollbars associated with widgets that support both horizontal
and vertical scrolling.
See the description of {\em scrollCommand} for complete details
on how this option is used.
.VE

.SH KEYWORDS
class, name, standard option, switch
