#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#define TRUE 1

main(argc,argv)
int argc;
char *argv[];
{
  int sock,length;
  struct sockaddr_in server;
  int msgsock;
  char buf[1024];
  int rval;
  fd_set ready;
  struct timeval to;

  sock=socket(AF_INET,SOCK_STREAM,0);
  if (sock <0)
    {
      perror("opening stream socket");
      exit(1);
    }
  server.sin_family=AF_INET;
  server.sin_addr.s_addr=INADDR_ANY;
  server.sin_port=atoi(argv[1]);
  if (bind(sock,&server,sizeof(server)))
    {
      perror("Binding stream socket");
      exit(1);
    }
  
  length=sizeof(server);
  if (getsockname(sock,&server,&length))
    {
      perror("getting socket name");
      exit(1);
    }
  printf("Socket has port number %d\n",ntohs(server.sin_port));
  
  listen(sock,5);
  do
    {
      FD_ZERO(&ready);
      FD_SET(sock,&ready);
      to.tv_sec=5;
      if(select(sock+1,&ready,0,0,&to)<0)
	{
	  perror("select");
	  continue;
	}
      if (FD_ISSET(sock,&ready))
	{
	  msgsock=accept(sock,(struct sockaddr *)0,(int *)0);
	  if (msgsock== -1)
	    perror("accept");
	  else
	    do
	      {
		bzero(buf,sizeof(buf));
		if ((rval=read(msgsock,buf,1024))<0)
		  perror("reading stream message");
		else
		  {
		    if (rval==0)
		      printf("Ending connection\n");
		    else
		      printf("-->%s\n",buf);
		  }
	      }
	  while (rval>0);
	  close (msgsock);
	}
      else
	printf("Do something else.\n");
    }
  while (TRUE);
}
