// Copyright 1995 Barbara Liskov

#include "pattern.h"
#include "6170.h"

class simple_pattern: public pattern {
public:
    simple_pattern(string str);
    virtual bool match(string s);
    virtual string unparse();
private:
    string s;          // the string representing the pattern
};

pattern *create_simple_pattern(string s) {
    return new simple_pattern(s);
}

simple_pattern::simple_pattern(string str) {
    s = str;
}

bool simple_pattern::match(string t) {
    int si = 0;         // index in "s" upto (but excluding) where it is matched
    int ti = 0;         // index in "t" upto (but excluding) where it is matched
    int last_star = -1; // index in "s" of last star before "si"; -1 if none

    while (true) {
	// skip stars in pattern
	while (si < s.length() && s[si] == '*') {
	    last_star = si;
	    si++;
	}

	if (ti == t.length()) return (si == s.length());

	if (si == s.length()) {
	    // jump to last star and absorb one char
	    if (last_star == -1) return false;
	    si = last_star+1;
	    ti++;
	    continue;
	}

	char sc = s[si];
	char tc = t[ti];

	if (sc == '[') {
	    bool matched = false; // whether tc matches any char within []
	    bool negated = false; // whether search is negated
	    int si2 = si+1;       // index in "s" to search for end bracket
	    if (si2 < s.length() && s[si2] == '^') {
		negated = true;
		si2++;
	    }
	    for (; si2 < s.length(); si2++) {
		if (s[si2] == ']') break;
		if (s[si2] == tc) matched = true;
	    }
	    if (si2 < s.length()) { // found end bracket
		if (matched != negated) { // match successful
		    si = si2+1;
		} else { // mismatch: jump to the last star
		    if (last_star == -1) return false;
		    si = last_star+1;
		}
		ti++;
		continue;
	    }
	}

	if (sc == tc) {
	    si++;
	} else {
	    if (last_star == -1) return false;
	    si = last_star+1;
	}
	ti++;
	continue;
    }
}   

string simple_pattern::unparse() {
    return s;
}

