;*********************************************************************
;*
;*  This contains definitions for AD Oversampling Int. Library
;*
;*********************************************************************
;* FileName:            ADOver.inc
;* Dependencies:
;* Processor:
;* Assembler:           MPASMWIN 02.70.02 or higher
;* Linker:              MPLINK 2.33.00 or higher
;* Company:             Microchip Technology, Inc.
;*
;* Software License Agreement
;*
;* The software supplied herewith by Microchip Technology Incorporated
;* (the "Company") for its PICmicro Microcontroller is intended and
;* supplied to you, the Company's customer, for use solely and
;* exclusively on Microchip PICmicro Microcontroller products. The
;* software is owned by the Company and/or its supplier, and is
;* protected under applicable copyright laws. All rights are reserved.
;* Any use in violation of the foregoing restrictions may subject the
;* user to criminal sanctions under applicable laws, as well as to
;* civil liability for the breach of the terms and conditions of this
;* license.
;*
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;*
;*
;* ANY SPECIAL DESCRIPTION THAT MIGHT BE USEFUL FOR THIS FILE.
;*
;* Author               Date            Comment
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;* Caio Gubel      Oct. 24, 2002    For CLM (V1.0)
;*
;********************************************************************/

#ifndef		__ADOver_inc

	#define	    __ADOver_inc
	include     "ADOver.def"

#define ADOVERROUND	(0x01<<(ADOVEREXTRABITS-1))

	include  <P18xxx.inc>
	include  <P16xxx.inc>

        #ifndef ADOver_Source

;****************************************************************************
;Definitions of Shared Parameters
;****************************************************************************

	EXTERN	vADOverReadLow
	EXTERN	vADOverReadHigh

	EXTERN	vADOverValueLow		    			;used to add and average values from conversions (3 bytes)
	EXTERN	vADOverValueHigh
	EXTERN	vADOverValueUpper

	EXTERN	vADOverSampleCounterLow				;samples counters
	EXTERN	vADOverSampleCounterHigh

	EXTERN	vADOverSampleSizeHigh				;number of samples
	EXTERN	vADOverSampleSizeLow

	EXTERN	vADOverLow		    			;Higher Precision A/D Calculated Values
	EXTERN	vADOverHigh
	EXTERN	vADOverUpper

	EXTERN	vADOverSaveINTCON				;original INTCON

        EXTERN	ADOverInit                                      ;initialization of process
        EXTERN  ADOverGetData                                   ;function to get data

        #else

;****************************************************************************
;Definitions of Shared Parameters
;****************************************************************************

	GLOBAL	vADOverReadLow
	GLOBAL	vADOverReadHigh

	GLOBAL	vADOverValueLow		    			;used to add and average values from conversions (3 bytes)
	GLOBAL	vADOverValueHigh
	GLOBAL	vADOverValueUpper

	GLOBAL	vADOverSampleCounterLow				;samples counters
	GLOBAL	vADOverSampleCounterHigh
	GLOBAL	vADOverSampleSizeHigh				;number of samples
	GLOBAL	vADOverSampleSizeLow

	GLOBAL	vADOverLow			    		;Higher Precision A/D Calculated Values
	GLOBAL	vADOverHigh
	GLOBAL	vADOverUpper

	GLOBAL	vADOverSaveINTCON				;original INTCON

        #endif
#endif
