/*****************************************************************************
 *
 * Microchip DeviceNet Stack (Class Definitions)
 *
 *****************************************************************************
 * FileName:        class.h
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.20.00 or higher
 * Linker:          MPLINK 03.40.00 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains DeviceNet Class Definitions.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			04/28/03	...	
 * 
 *****************************************************************************/





#define		CLASS_IDENTITY								0x01
#define		CLASS_MESSAGE_ROUTER						0x02
#define		CLASS_DEVICENET								0x03
#define		CLASS_ASSEMBLY								0x04
#define		CLASS_CONNECTION							0x05
#define		CLASS_OFFLINK_CONNECTION_MANAGER			0x06
#define		CLASS_REGISTER								0x07
#define		CLASS_DISCRETE_INPUT_POINT					0x08
#define		CLASS_DISCRETE_OUTPUT_POINT					0x09
#define		CLASS_ANALOG_INPUT_POINT					0x0A
#define		CLASS_ANALOG_OUTPUT_POINT					0x0B
#define		CLASS_PRESENCE_SENSING						0x0E
#define		CLASS_PARAMETER								0x0F
#define		CLASS_PARAMETER_GROUP						0x10
#define		CLASS_GROUP									0x12
#define		CLASS_DISCRETE_INPUT_GROUP					0x1D
#define		CLASS_DISCRETE_OUTPUT_GROUP					0x1E
#define		CLASS_DISCRETE_GROUP						0x1F
#define		CLASS_ANALOG_INPUT_GROUP					0x20
#define		CLASS_ANALOG_OUTPUT_GROUP					0x21
#define		CLASS_ANALOG_GROUP							0x22
#define		CLASS_POSITION_SENSOR_OBJ					0x23
#define		CLASS_POSITION_CONTROLLER_SUPERVISOR_OBJ	0x24
#define		CLASS_POSITION_CONTROLLER_OBJ				0x25
#define		CLASS_BLOCK_SEQUENCER_OBJ					0x26
#define		CLASS_COMMAND_BLOCK_OBJ						0x27
#define		CLASS_MOTOR_DATA_OBJ						0x28
#define		CLASS_CONTROL_SUPERVISOR_OBJ				0x29
#define		CLASS_AC_DC_DRIVE_OBJ						0x2A
#define		CLASS_ACKNOWLEDGE_HANDLER_OBJ				0x2B
#define		CLASS_OVERLOAD_OBJ							0x2C
#define		CLASS_SOFTSTART_OBJ							0x2D
#define		CLASS_SELECTION_OBJ							0x2E
#define		CLASS_S_DEVICE_SUPERVISOR_OBJ				0x30
#define		CLASS_S_ANALOG_SENSOR_OBJ					0x31
#define		CLASS_S_ANALOG_ACTUATOR_OBJ					0x32
#define		CLASS_S_SINGLE_STAGE_CONTROLLER_OBJ			0x33
#define		CLASS_S_GAS_CALIBRATION_OBJ					0x34
#define		CLASS_TRIP_POINT_OBJ						0x35
#define		CLASS_FILE_OBJ								0x37
#define		CLASS_S_PARTIAL_PRESSURE_OBJ				0x38





